/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.editor;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.AnnotatedImageDescriptor;
import org.eclipse.dltk.ruby.internal.ui.RubyImages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RubyOutlineLabelDecorator
extends LabelProvider
implements ILabelDecorator {
    public String decorateText(String text, Object element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            try {
                if (method.exists() && (method.getFlags() & 0x100000) != 0) {
                    String cfr_ignored_0 = method.getParameters()[0];
                    return method.getElementName();
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        try {
            IMember member;
            if (obj instanceof IMember && (member = (IMember)obj).exists()) {
                int flags = member.getFlags();
                ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
                Rectangle bounds = image.getBounds();
                RubyOutlineImageDescriptor dsc = new RubyOutlineImageDescriptor((ImageDescriptor)baseImage, new Point(bounds.width, bounds.height), flags);
                return dsc.createImage();
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return image;
    }

    protected static class RubyOutlineImageDescriptor
    extends AnnotatedImageDescriptor {
        private int flags;

        public RubyOutlineImageDescriptor(ImageDescriptor baseImageDescriptor, Point size, int flags) {
            super(baseImageDescriptor, size);
            this.flags = flags;
        }

        protected void drawAnnotations() {
            ImageData data = null;
            if ((this.flags & 0x100) != 0) {
                data = RubyOutlineImageDescriptor.getImageData((ImageDescriptor)RubyImages.DESC_OVR_STATIC_FIELD);
            } else if ((this.flags & 4) != 0) {
                data = RubyOutlineImageDescriptor.getImageData((ImageDescriptor)RubyImages.DESC_OVR_CONST_FIELD);
            }
            if (data != null) {
                this.drawImageTopRight(data);
            }
            if ((this.flags & 0x80000) != 0) {
                data = RubyOutlineImageDescriptor.getImageData((ImageDescriptor)DLTKPluginImages.DESC_OVR_ABSTRACT);
                this.drawImageTopLeft(data);
            }
            if ((this.flags & 0x100000) != 0) {
                data = RubyOutlineImageDescriptor.getImageData((ImageDescriptor)DLTKPluginImages.DESC_OVR_CALLER);
                this.drawImageTopLeft(data);
            }
        }
    }
}

