/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.handlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.debug.ui.handlers.HandlerMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LaunchStatusDialog
extends IconAndMessageDialog {
    private final IProgressMonitor monitor;
    private String commandLine;
    private Label elapsedTimeValue;

    public LaunchStatusDialog(Shell shell, IProgressMonitor monitor) {
        super(shell);
        this.monitor = monitor;
        this.setShellStyle(LaunchStatusDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10000);
        this.message = HandlerMessages.LaunchStatusDialog_message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(HandlerMessages.LaunchStatusDialog_title);
    }

    protected Image getImage() {
        return this.getWarningImage();
    }

    public void updateElapsedTime(long elapsedTime) {
        int h = (int)(elapsedTime / 1000L / 60L / 60L);
        int m = (int)((elapsedTime -= (long)(h * 1000 * 60 * 60)) / 1000L / 60L);
        int s = (int)((elapsedTime -= (long)(m * 1000 * 60)) / 1000L);
        StringBuffer sb = new StringBuffer();
        if (h < 10) {
            sb.append('0');
        }
        sb.append(h);
        sb.append(':');
        if (m < 10) {
            sb.append('0');
        }
        sb.append(m);
        sb.append(':');
        if (s < 10) {
            sb.append('0');
        }
        sb.append(s);
        this.elapsedTimeValue.setText(sb.toString());
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData compositeData = new GridData(1808);
        compositeData.horizontalSpan = 2;
        composite.setLayoutData((Object)compositeData);
        Label commandLinePrompt = new Label(composite, 0);
        commandLinePrompt.setText(HandlerMessages.LaunchStatusDialog_commandLinePrompt);
        GridData commandLineData = new GridData(768);
        commandLineData.horizontalSpan = 2;
        commandLinePrompt.setLayoutData((Object)commandLineData);
        Text commandLineValue = new Text(composite, 72);
        commandLineValue.setText(this.commandLine);
        GridData commandLineValueData = new GridData(768);
        commandLineValueData.horizontalSpan = 2;
        commandLineValueData.widthHint = 500;
        commandLineValue.setLayoutData((Object)commandLineValueData);
        Label elapsedTimePrompt = new Label(composite, 0);
        elapsedTimePrompt.setText(HandlerMessages.LaunchStatusDialog_elapsedTimePrompt);
        this.elapsedTimeValue = new Label(composite, 0);
        this.elapsedTimeValue.setText("");
        this.elapsedTimeValue.setLayoutData((Object)new GridData(768));
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createCancelButton(parent);
    }

    protected void createCancelButton(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void cancelPressed() {
        this.monitor.setCanceled(true);
        this.close();
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }
}

