/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.ILaunchStatusHandler;
import org.eclipse.dltk.launching.Messages;

public class DebugSessionAcceptor
implements IDbgpThreadAcceptor,
IScriptDebugTargetListener {
    private final ScriptDebugTarget target;
    private IProgressMonitor parentMonitor;
    private boolean initialized = false;
    private boolean connected = false;
    private ILaunchStatusHandler statusHandler = null;
    private static final int WAIT_CHUNK = 1000;
    private IProgressMonitor initializeMonitor = null;

    public DebugSessionAcceptor(ScriptDebugTarget target, IProgressMonitor monitor) {
        this.target = target;
        this.parentMonitor = monitor;
        target.addListener((IScriptDebugTargetListener)this);
        target.getDbgpService().registerAcceptor(target.getSessionId(), (IDbgpThreadAcceptor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetInitialized() {
        DebugSessionAcceptor debugSessionAcceptor = this;
        synchronized (debugSessionAcceptor) {
            this.initialized = true;
            this.notify();
        }
    }

    public void targetTerminating() {
        this.target.getDbgpService().unregisterAcceptor(this.target.getSessionId());
        this.disposeStatusHandler();
    }

    public void disposeStatusHandler() {
        if (this.statusHandler != null) {
            this.statusHandler.dispose();
            this.statusHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitConnection(int timeout) {
        SubProgressMonitor sub = new SubProgressMonitor(this.parentMonitor, 1);
        sub.beginTask("", timeout / 1000);
        try {
            sub.setTaskName(Messages.DebugSessionAcceptor_waitConnection);
            long start = System.currentTimeMillis();
            try {
                long waitStart = start;
                while (true) {
                    DebugSessionAcceptor debugSessionAcceptor = this;
                    synchronized (debugSessionAcceptor) {
                        if (this.connected) {
                            return true;
                        }
                    }
                    if (this.target.isTerminated()) return false;
                    if (sub.isCanceled()) {
                        return false;
                    }
                    debugSessionAcceptor = this;
                    synchronized (debugSessionAcceptor) {
                        this.wait(1000L);
                    }
                    long now = System.currentTimeMillis();
                    if (timeout != 0 && now - start > (long)timeout) {
                        if (this.statusHandler == null) {
                            this.statusHandler = this.createStatusHandler();
                        }
                        this.statusHandler.updateElapsedTime(now - start);
                    }
                    sub.worked((int)((now - waitStart) / 1000L));
                    waitStart = now;
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        finally {
            sub.done();
        }
    }

    private ILaunchStatusHandler createStatusHandler() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.launching.launchStatusHandler");
        int i = 0;
        while (i < elements.length) {
            try {
                ILaunchStatusHandler handler = (ILaunchStatusHandler)elements[i].createExecutableExtension("class");
                handler.initialize((IDebugTarget)this.target, this.parentMonitor);
                return handler;
            }
            catch (Exception e) {
                DLTKLaunchingPlugin.logWarning(e);
                ++i;
            }
        }
        return new NopLaunchStatusHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDbgpThread(IDbgpSession session, IProgressMonitor monitor) {
        boolean isFirst;
        DebugSessionAcceptor debugSessionAcceptor = this;
        synchronized (debugSessionAcceptor) {
            boolean bl = isFirst = !this.connected;
            if (!this.connected) {
                this.connected = true;
                this.notify();
            }
        }
        if (isFirst) {
            IProgressMonitor sub = this.getInitializeMonitor();
            try {
                this.target.getDbgpThreadAcceptor().acceptDbgpThread(session, sub);
            }
            finally {
                sub.done();
            }
        } else {
            this.target.getDbgpThreadAcceptor().acceptDbgpThread(session, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private synchronized IProgressMonitor getInitializeMonitor() {
        if (this.initializeMonitor == null) {
            this.initializeMonitor = new SubProgressMonitor(this.parentMonitor, 1);
            this.initializeMonitor.beginTask("", 100);
            this.initializeMonitor.setTaskName(Messages.DebugSessionAcceptor_waitInitialization);
        }
        return this.initializeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitInitialized(int timeout) {
        IProgressMonitor sub = this.getInitializeMonitor();
        try {
            long now;
            long start = System.currentTimeMillis();
            do {
                DebugSessionAcceptor debugSessionAcceptor;
                try {
                    debugSessionAcceptor = this;
                    synchronized (debugSessionAcceptor) {
                        if (this.initialized) {
                            return true;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    return false;
                }
                if (this.target.isTerminated()) return false;
                if (sub.isCanceled()) {
                    return false;
                }
                debugSessionAcceptor = this;
                synchronized (debugSessionAcceptor) {
                    this.wait(1000L);
                }
                now = System.currentTimeMillis();
            } while (timeout == 0 || now - start <= (long)timeout);
            return false;
        }
        finally {
            sub.done();
        }
    }

    private static class NopLaunchStatusHandler
    implements ILaunchStatusHandler {
        private NopLaunchStatusHandler() {
        }

        public void initialize(IDebugTarget target, IProgressMonitor monitor) {
        }

        public void updateElapsedTime(long elapsedTime) {
        }

        public void dispose() {
        }
    }
}

