/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.Locale;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.compiler.problem.DLTKProblemReporter;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class DefaultProblemFactory
implements IProblemFactory {
    private Locale locale;

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale loc) {
        this.locale = loc;
        Locale.getDefault().equals(loc);
    }

    public IProblem createProblem(String originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
        String message = this.getLocalizedMessage(problemId, messageArguments);
        return new DefaultProblem(null, message, problemId, problemArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedMessage(int problemId, String[] messageArguments) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < messageArguments.length) {
            b.append(messageArguments[i]);
            if (i != messageArguments.length - 1) {
                b.append(" ");
            }
            ++i;
        }
        return b.toString();
    }

    public IProblemReporter createReporter(IResource resource) {
        return new DLTKProblemReporter(resource, this);
    }
}

