/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Stack;

public class CompletionString {
    public static String parse(String id, boolean dotBeforeBrackets) {
        return CompletionString.parse(id, dotBeforeBrackets, false);
    }

    public static String parse(String id, boolean dotBeforeBrackets, boolean functionCallParenthesis) {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int current = id.length();
        Stack<Bracket> inBrackStack = new Stack<Bracket>();
        boolean inStringSingle = false;
        boolean inStringDouble = false;
        int i = id.length();
        while (--i >= 0) {
            char c = id.charAt(i);
            if (c == '\'') {
                if (inStringSingle) {
                    inStringSingle = false;
                    continue;
                }
                if (!inStringDouble) {
                    inStringSingle = true;
                }
            }
            if (c == '\"') {
                if (inStringDouble) {
                    inStringDouble = false;
                    continue;
                }
                if (!inStringSingle) {
                    inStringDouble = true;
                }
            }
            if (inStringSingle || inStringDouble) continue;
            if (c == ']') {
                if (inBrackStack.isEmpty()) {
                    String brackets = "[]";
                    if (dotBeforeBrackets && i > 0 && (i - 2 < 0 || id.charAt(i - 2) != '.')) {
                        brackets = ".[]";
                    }
                    sb.insert(0, String.valueOf(brackets) + id.substring(i + 1, current));
                }
                inBrackStack.push(new Bracket('[', i));
                continue;
            }
            if (c == ')') {
                if (inBrackStack.isEmpty()) {
                    if (functionCallParenthesis) {
                        String parens = "()";
                        if (dotBeforeBrackets && i > 0 && (i - 2 < 0 || id.charAt(i - 2) != '.')) {
                            parens = ".()";
                        }
                        sb.insert(0, String.valueOf(parens) + id.substring(i + 1, current));
                    } else {
                        sb.insert(0, id.substring(i + 1, current));
                    }
                }
                inBrackStack.push(new Bracket('(', i));
                continue;
            }
            if (c == '[' || c == '(') {
                if (inBrackStack.isEmpty()) {
                    if (i + 1 < id.length() && id.charAt(i + 1) == c) {
                        id = String.valueOf(id.substring(0, i)) + id.substring(i + 1);
                        return CompletionString.parse(id, dotBeforeBrackets, functionCallParenthesis);
                    }
                    return String.valueOf(id.substring(i + 1, current)) + sb.toString();
                }
                if (c != ((Bracket)inBrackStack.peek()).ch) continue;
                current = i;
                inBrackStack.pop();
                continue;
            }
            if (c == ':') {
                if (i >= 1 && id.charAt(i - 1) == ':') {
                    --i;
                    continue;
                }
                start = i + 1;
                break;
            }
            if (c == '.' || c == '@' || !inBrackStack.isEmpty() || !Character.isWhitespace(c) && Character.isJavaIdentifierPart(c)) continue;
            start = i + 1;
            break;
        }
        if (start == 0 && current == id.length() && inBrackStack.isEmpty()) {
            return id;
        }
        if (!inBrackStack.isEmpty()) {
            Bracket last = (Bracket)inBrackStack.pop();
            id = String.valueOf(id.substring(start, last.position)) + id.substring(last.position + 1, id.length());
            return CompletionString.parse(id, dotBeforeBrackets, functionCallParenthesis);
        }
        sb.insert(0, id.substring(start, current));
        if (dotBeforeBrackets && sb.length() > 1 && sb.charAt(0) == '.' && sb.charAt(1) == '[') {
            return sb.substring(1);
        }
        return sb.toString();
    }

    private static class Bracket {
        final char ch;
        final int position;

        public Bracket(char ch, int position) {
            this.ch = ch;
            this.position = position;
        }
    }
}

