/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.preferences.CodeTemplateBlock;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateArea;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class CodeTemplatesPreferencePage
extends PropertyAndPreferencePage {
    public static final String DATA_SELECT_TEMPLATE = "CodeTemplatePreferencePage.select_template";
    private final IDLTKUILanguageToolkit toolkit;
    private final ICodeTemplateArea codeTemplateArea;
    private CodeTemplateBlock fCodeTemplateConfigurationBlock;

    protected CodeTemplatesPreferencePage(IDLTKUILanguageToolkit toolkit, ICodeTemplateArea codeTemplateArea) {
        this.toolkit = toolkit;
        this.codeTemplateArea = codeTemplateArea;
        this.setTitle(PreferencesMessages.CodeTemplatesPreferencePage_title);
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fCodeTemplateConfigurationBlock = new CodeTemplateBlock(this.getNewStatusChangedListener(), this.getProject(), container, this.toolkit, this.codeTemplateArea.getTemplateAccess());
        super.createControl(parent);
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fCodeTemplateConfigurationBlock.createContents(composite);
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    public boolean performOk() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            return this.fCodeTemplateConfigurationBlock.performOk(this.useProjectSettings());
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.performDefaults();
        }
    }

    public void dispose() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.dispose();
        }
        super.dispose();
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.performCancel();
        }
        return super.performCancel();
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.fCodeTemplateConfigurationBlock.hasProjectSpecificOptions(project);
    }

    public void applyData(Object data) {
        Object id;
        if (data instanceof Map && (id = ((Map)data).get(DATA_SELECT_TEMPLATE)) instanceof String) {
            TemplatePersistenceData[] templates = this.fCodeTemplateConfigurationBlock.fTemplateStore.getTemplateData();
            int index = 0;
            while (index < templates.length) {
                TemplatePersistenceData template = templates[index];
                if (id.equals(template.getId()) || id.equals(template.getTemplate().getName())) {
                    this.fCodeTemplateConfigurationBlock.postSetSelection(template);
                    break;
                }
                ++index;
            }
        }
        super.applyData(data);
    }

    protected String getPreferencePageId() {
        return this.codeTemplateArea.getTemplatePreferencePageId();
    }

    protected String getPropertyPageId() {
        return this.codeTemplateArea.getTemplatePropertyPageId();
    }
}

