/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.utils.CompoundIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMemberQuery
implements Iterable<Member> {
    private final List<QueueItem> types = new ArrayList<QueueItem>();

    public TypeMemberQuery() {
    }

    public TypeMemberQuery(Type type) {
        this.add(type);
    }

    public TypeMemberQuery(Type type, MemberPredicate predicate) {
        this.add(type, predicate);
    }

    public void add(Type type) {
        this.add(type, MemberPredicate.ALWAYS_TRUE);
    }

    public void add(Type type, MemberPredicate predicate) {
        this.types.add(new QueueItem(type, predicate));
    }

    protected boolean isValid(Type type) {
        return true;
    }

    @Override
    public Iterator<Member> iterator() {
        return new MemberIterator();
    }

    public Member findMember(String memberName) {
        for (Member member : this) {
            if (!memberName.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemberIterator
    extends CompoundIterator<Member> {
        private final TypeIterator typeIterator;

        public MemberIterator() {
            this.typeIterator = new TypeIterator();
            this.current = Collections.emptyList().iterator();
        }

        protected boolean fetchNext() {
            while (this.typeIterator.hasNext()) {
                QueueItem item = (QueueItem)this.typeIterator.next();
                if (item.predicate == MemberPredicate.ALWAYS_TRUE) {
                    this.current = item.type.getMembers().iterator();
                } else {
                    ArrayList<Member> filtered = new ArrayList<Member>(item.type.getMembers().size());
                    for (Member member : item.type.getMembers()) {
                        if (!item.predicate.evaluate(member)) continue;
                        filtered.add(member);
                    }
                    this.current = filtered.iterator();
                }
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    private static class QueueItem {
        final Type type;
        final MemberPredicate predicate;

        public QueueItem(Type type, MemberPredicate predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QueueItem) {
                QueueItem other = (QueueItem)obj;
                return this.type.equals(other.type) && this.predicate.equals((Object)other.predicate);
            }
            return false;
        }

        public String toString() {
            return (Object)((Object)this.predicate) + ":" + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeIterator
    extends CompoundIterator<QueueItem> {
        private final Set<QueueItem> visited = new HashSet<QueueItem>();
        private final List<QueueItem> queue = new ArrayList<QueueItem>();
        private final List<QueueItem> skipQueue = new ArrayList<QueueItem>();

        public TypeIterator() {
            this.queue.addAll(TypeMemberQuery.this.types);
            this.current = this.queue.iterator();
        }

        private boolean canVisit(QueueItem item) {
            return this.visited.add(item);
        }

        protected boolean fetchNext() {
            if (!this.skipQueue.isEmpty()) {
                this.queue.addAll(this.skipQueue);
                this.skipQueue.clear();
            }
            if (!this.queue.isEmpty()) {
                QueueItem[] copy = this.queue.toArray(new QueueItem[this.queue.size()]);
                this.queue.clear();
                QueueItem[] queueItemArray = copy;
                int n = copy.length;
                int n2 = 0;
                while (n2 < n) {
                    QueueItem superItem;
                    QueueItem item = queueItemArray[n2];
                    Type type = item.type;
                    Type superType = type.getSuperType();
                    if (superType != null && this.canVisit(superItem = new QueueItem(superType, item.predicate)) && TypeMemberQuery.this.isValid(superType)) {
                        this.queue.add(superItem);
                    }
                    for (Type trait : type.getTraits()) {
                        QueueItem traitItem = new QueueItem(trait, item.predicate);
                        if (!this.canVisit(traitItem) || !TypeMemberQuery.this.isValid(trait)) continue;
                        this.queue.add(traitItem);
                    }
                    ++n2;
                }
                this.current = this.queue.iterator();
                return this.current.hasNext();
            }
            return false;
        }
    }
}

