/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.dltk.tcl.internal.debug.ui.actions.ActionMessages;
import org.eclipse.dltk.tcl.internal.debug.ui.actions.IToggleSpawnpointsTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ToggleSpawnpointAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;

    public ToggleSpawnpointAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(ActionMessages.ToggleSpawnpointAction_0);
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
    }

    public void run() {
        IAdapterManager manager;
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        IToggleSpawnpointsTarget adapter = (IToggleSpawnpointsTarget)this.fPart.getAdapter(IToggleSpawnpointsTarget.class);
        if (adapter == null && (manager = Platform.getAdapterManager()).hasAdapter((Object)this.fPart, IToggleSpawnpointsTarget.class.getName())) {
            adapter = (IToggleSpawnpointsTarget)manager.loadAdapter((Object)this.fPart, IToggleSpawnpointsTarget.class.getName());
        }
        if (adapter == null) {
            return;
        }
        int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return;
        }
        try {
            ITextSelection selection = this.getTextSelection(document, line);
            if (adapter.canToggleSpawnpoints(this.fPart, selection)) {
                adapter.toggleSpawnpoints(this.fPart, selection);
            }
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    private void reportException(Exception e) {
        DebugUIPlugin.errorDialog((Shell)this.fPart.getSite().getShell(), (String)ActionMessages.ToggleSpawnpointAction_1, (String)ActionMessages.ToggleSpawnpointAction_2, (Throwable)e);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fPart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        IDocument document = this.getDocument();
        if (document != null) {
            int line;
            IAdapterManager manager;
            IToggleSpawnpointsTarget adapter = (IToggleSpawnpointsTarget)this.fPart.getAdapter(IToggleSpawnpointsTarget.class);
            if (adapter == null && (manager = Platform.getAdapterManager()).hasAdapter((Object)this.fPart, IToggleSpawnpointsTarget.class.getName())) {
                adapter = (IToggleSpawnpointsTarget)manager.loadAdapter((Object)this.fPart, IToggleSpawnpointsTarget.class.getName());
            }
            if (adapter != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
                try {
                    ITextSelection selection = this.getTextSelection(document, line);
                    if (adapter.canToggleSpawnpoints(this.fPart, selection)) {
                        this.setEnabled(true);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    this.reportException((Exception)((Object)e));
                }
            }
        }
        this.setEnabled(false);
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }
}

