/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.util.HashtableOfObjectToInt;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IProjectFragmentTimestamp;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuildpathAccessRule;
import org.eclipse.dltk.internal.core.BuildpathAttribute;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.ExternalFoldersManager;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.FileCacheStub;
import org.eclipse.dltk.internal.core.IFileCache;
import org.eclipse.dltk.internal.core.IFileCacheManagement;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelCache;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementDeltaBuilder;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.SourceModuleInfoCache;
import org.eclipse.dltk.internal.core.UserLibraryManager;
import org.eclipse.dltk.internal.core.ZipArchiveFile;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;
import org.eclipse.dltk.internal.core.builder.State;
import org.eclipse.dltk.internal.core.caching.DLTKCoreCache;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.internal.core.util.WeakHashSet;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelManager
implements ISaveParticipant {
    private static final int CONTAINERS_FILE_VERSION = 1;
    public static final String BP_VARIABLE_PREFERENCES_PREFIX = "org.eclipse.dltk.core.buildpathVariable.";
    public static final String BP_CONTAINER_PREFERENCES_PREFIX = "org.eclipse.dltk.core.buildpathContainer.";
    public static final String BP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.dltk.core.userLibrary.";
    public static final String BP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static final IPath BP_ENTRY_IGNORE_PATH = new Path("##<cp entry ignore>##");
    public static final String TRUE = "true";
    final Model model = new Model();
    public HashMap variables = new HashMap(5);
    public HashSet variablesWithInitializer = new HashSet(5);
    public HashSet readOnlyVariables = new HashSet(5);
    public HashMap previousSessionVariables = new HashMap(5);
    private ThreadLocal variableInitializationInProgress = new ThreadLocal();
    public HashMap containers = new HashMap(5);
    public HashMap previousSessionContainers = new HashMap(5);
    private ThreadLocal containerInitializationInProgress = new ThreadLocal();
    public boolean batchContainerInitializations = false;
    public HashMap containerInitializersCache = new HashMap(5);
    public static final IPath VARIABLE_INITIALIZATION_IN_PROGRESS = new Path("Variable Initialization In Progress");
    public static final IBuildpathContainer CONTAINER_INITIALIZATION_IN_PROGRESS = new IBuildpathContainer(){

        public IBuildpathEntry[] getBuildpathEntries() {
            return null;
        }

        public String getDescription() {
            return "Container Initialization In Progress";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    private ThreadLocal buildpathsBeingResolved = new ThreadLocal();
    public static boolean VERBOSE = false;
    public static boolean BP_RESOLVE_VERBOSE = false;
    public static final String BPVARIABLE_INITIALIZER_EXTPOINT_ID = "buildpathVariableInitializer";
    public static final String BPCONTAINER_INITIALIZER_EXTPOINT_ID = "buildpathContainerInitializer";
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private ThreadLocal<Map<IPath, IArchive>> zipFiles = new ThreadLocal();
    private IFileCache fileCache = null;
    private UserLibraryManager userLibraryManager;
    public static final ISourceModule[] NO_WORKING_COPY = new ISourceModule[0];
    private static ModelManager MANAGER = new ModelManager();
    public ModelCache cache;
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected HashSet<Openable> elementsOutOfSynchWithBuffers = new HashSet(11);
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    public IndexManager indexManager = new IndexManager();
    protected Map perProjectInfos = new HashMap(5);
    protected Map perWorkingCopyInfos = new HashMap(5);
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    HashSet<String> optionNames = new HashSet(20);
    Hashtable<String, String> optionsCache;
    private WeakHashSet stringSymbols = new WeakHashSet(5);
    Map workspaceScope = null;
    public static final String DELTA_LISTENER_PERF = "org.eclipse.dltk.core/perf/deltalistener";
    private ExternalFoldersManager externalFoldersManager = new ExternalFoldersManager();
    private DLTKCoreCache coreCache = null;
    private IEclipsePreferences.IPreferenceChangeListener propertyListener;
    private IEclipsePreferences.IPreferenceChangeListener resourcesPropertyListener;
    private SourceModuleInfoCache sourceModuleInfoCache = null;

    public IContentCache getCoreCache() {
        if (this.coreCache == null) {
            this.coreCache = new DLTKCoreCache();
        }
        return this.coreCache;
    }

    private ModelManager() {
        if (Platform.isRunning()) {
            this.indexManager = new IndexManager();
        }
    }

    public final Model getModel() {
        return this.model;
    }

    public static final ModelManager getModelManager() {
        return MANAGER;
    }

    protected HashSet<Openable> getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public synchronized Object getInfo(IModelElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    protected synchronized Object peekAtInfo(IModelElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    public synchronized Object removeInfoAndChildren(ModelElement element) throws ModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info != null) {
            boolean wasVerbose = false;
            try {
                if (VERBOSE) {
                    String elementType;
                    switch (element.getElementType()) {
                        case 2: {
                            elementType = "project";
                            break;
                        }
                        case 3: {
                            elementType = "root";
                            break;
                        }
                        case 4: {
                            elementType = "folder";
                            break;
                        }
                        case 6: {
                            elementType = "binary module";
                            break;
                        }
                        case 5: {
                            elementType = "source module";
                            break;
                        }
                        default: {
                            elementType = "element";
                        }
                    }
                    System.out.println(Thread.currentThread() + " CLOSING " + elementType + " " + element.toStringWithAncestors());
                    wasVerbose = true;
                    VERBOSE = false;
                }
                element.closing(info);
                if (element instanceof IParent && info instanceof ModelElementInfo) {
                    IModelElement[] children = ((ModelElementInfo)info).getChildren();
                    int i = 0;
                    int size = children.length;
                    while (i < size) {
                        ModelElement child = (ModelElement)children[i];
                        child.close();
                        ++i;
                    }
                }
                this.cache.removeInfo(element);
                if (wasVerbose) {
                    System.out.println(this.cache.toStringFillingRation("-> "));
                }
            }
            finally {
                VERBOSE = wasVerbose;
            }
            return info;
        }
        return null;
    }

    protected synchronized void putInfos(IModelElement openedElement, Map newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof ModelElementInfo) {
            IModelElement[] children = ((ModelElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                ModelElement child = (ModelElement)children[i];
                try {
                    child.close();
                }
                catch (ModelException modelException) {}
                ++i;
            }
        }
        Iterator it = newElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IModelElement element = (IModelElement)entry.getKey();
            if (!(element instanceof ArchiveProjectFragment) && !(element instanceof ExternalScriptFolder)) continue;
            Object info = entry.getValue();
            it.remove();
            this.cache.putInfo(element, info);
        }
        for (IModelElement element : newElements.keySet()) {
            Object info = newElements.get(element);
            this.cache.putInfo(element, info);
        }
    }

    public HashMap getTemporaryCache() {
        HashMap result = (HashMap)this.temporaryCache.get();
        if (result == null) {
            result = new HashMap();
            this.temporaryCache.set(result);
        }
        return result;
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    public static IModelElement create(IFile file, IScriptProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = DLTKCore.create(file.getProject());
        }
        if (Util.isValidSourceModule((IModelElement)project, (IResource)file)) {
            return ModelManager.createSourceModuleFrom(file, project);
        }
        return null;
    }

    public static IModelElement create(IResource resource, IScriptProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return DLTKCore.create((IProject)resource);
            }
            case 1: {
                return ModelManager.create((IFile)resource, project);
            }
            case 2: {
                return ModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return DLTKCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IModelElement create(IFolder folder, IScriptProject project) {
        IModelElement element;
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = DLTKCore.create(folder.getProject());
            element = ModelManager.determineIfOnBuildpath((IResource)folder, project);
            if (element == null) {
                IScriptProject[] projects;
                try {
                    projects = ModelManager.getModelManager().getModel().getScriptProjects();
                }
                catch (ModelException modelException) {
                    return null;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    project = projects[i];
                    element = ModelManager.determineIfOnBuildpath((IResource)folder, project);
                    if (element == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            element = ModelManager.determineIfOnBuildpath((IResource)folder, project);
        }
        return element;
    }

    public static ISourceModule createSourceModuleFrom(IFile file, IScriptProject project) {
        IScriptFolder folder;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = DLTKCore.create(file.getProject());
        }
        if ((folder = (IScriptFolder)ModelManager.determineIfOnBuildpath((IResource)file, project)) == null) {
            IProjectFragment root = project.getProjectFragment((IResource)file.getParent());
            folder = root.getScriptFolder((IPath)Path.EMPTY);
            if (VERBOSE) {
                System.out.println("WARNING : creating module element outside buildpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return folder.getSourceModule(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IModelElement determineIfOnBuildpath(IResource resource, IScriptProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IBuildpathEntry[] entries = ((ScriptProject)project).getResourceOnlyResolvedBuildpath();
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return null;
                }
                IBuildpathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    BuildpathEntry bpe;
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        return project.getProjectFragment(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, (bpe = (BuildpathEntry)entry).fullInclusionPatternChars(), bpe.fullExclusionPatternChars())) {
                        IProjectFragment root = ((ScriptProject)project).getFolderProjectFragment(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath folderPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() != 1) return root.getScriptFolder(folderPath);
                        folderPath = folderPath.removeLastSegments(1);
                        return root.getScriptFolder(folderPath);
                    }
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws ModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!ScriptProject.hasScriptNature(project)) {
                throw ((ScriptProject)DLTKCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(SourceModule workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.getOwner();
            HashMap<SourceModule, PerWorkingCopyInfo> workingCopyToInfos = (HashMap<SourceModule, PerWorkingCopyInfo>)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<SourceModule, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && problemRequestor != null) {
                info.problemRequestor = problemRequestor;
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceModule[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            ISourceModule[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            ISourceModule[] result = new ISourceModule[primaryLength + size];
            int index = 0;
            if (primaryWCs != null) {
                int i = 0;
                while (i < primaryLength) {
                    ISourceModule primaryWorkingCopy = primaryWCs[i];
                    boolean validSrcModule = false;
                    IResource res = primaryWorkingCopy.getResource();
                    validSrcModule = res != null ? Util.isValidSourceModule((IModelElement)primaryWorkingCopy, res) : Util.isValidSourceModule((IModelElement)primaryWorkingCopy, primaryWorkingCopy.getPath());
                    if (validSrcModule) {
                        SourceModule workingCopy = new SourceModule((ModelElement)primaryWorkingCopy.getParent(), primaryWorkingCopy.getElementName(), owner);
                        if (!workingCopyToInfos.containsKey(workingCopy)) {
                            result[index++] = primaryWorkingCopy;
                        }
                    } else {
                        System.err.println("Not valid primary working copy:" + primaryWorkingCopy.getElementName());
                    }
                    ++i;
                }
                if (index != primaryLength) {
                    ISourceModule[] iSourceModuleArray = result;
                    result = new ISourceModule[index + size];
                    System.arraycopy(iSourceModuleArray, 0, result, 0, index);
                }
            }
            Iterator iterator = workingCopyToInfos.values().iterator();
            while (iterator.hasNext()) {
                result[index++] = ((PerWorkingCopyInfo)iterator.next()).getWorkingCopy();
            }
            return result;
        }
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    public static ExternalFoldersManager getExternalManager() {
        return ModelManager.MANAGER.externalFoldersManager;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!DLTKLanguageManager.hasScriptNature(project)) {
            if (ScriptBuilder.DEBUG) {
                System.out.println(project + " is not a Java project");
            }
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Messages.bind(Messages.build_readStateProgress, project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return info.savedState;
    }

    public String getOption(String optionName) {
        if ("org.eclipse.dltk.core.encoding".equals(optionName)) {
            return DLTKCore.getEncoding();
        }
        String propertyName = optionName;
        if (this.optionNames.contains(propertyName)) {
            IPreferencesService service = Platform.getPreferencesService();
            String value = service.get(optionName, null, (Preferences[])this.preferencesLookup);
            return value == null ? null : value.trim();
        }
        return null;
    }

    public IEclipsePreferences getInstancePreferences() {
        return this.preferencesLookup[0];
    }

    public void setOptions(Hashtable newOptions) {
        try {
            IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
            IEclipsePreferences instancePreferences = this.getInstancePreferences();
            if (newOptions == null) {
                instancePreferences.clear();
            } else {
                Enumeration keys = newOptions.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!this.optionNames.contains(key) || key.equals("org.eclipse.dltk.core.encoding")) continue;
                    String value = (String)newOptions.get(key);
                    String defaultValue = defaultPreferences.get(key, null);
                    if (defaultValue != null && defaultValue.equals(value)) {
                        instancePreferences.remove(key);
                        continue;
                    }
                    instancePreferences.put(key, value);
                }
            }
            instancePreferences.flush();
            this.optionsCache = newOptions == null ? null : new Hashtable(newOptions);
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public Hashtable<String, String> getOptions() {
        if (this.optionsCache != null) {
            return new Hashtable<String, String>(this.optionsCache);
        }
        if (!Platform.isRunning()) {
            this.optionsCache = this.getDefaultOptionsNoInitialization();
            return this.optionsCache;
        }
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        for (String propertyName : this.optionNames) {
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
        }
        options.put("org.eclipse.dltk.core.encoding", DLTKCore.getEncoding());
        this.optionsCache = new Hashtable(options);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectOptions(ScriptProject scriptProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = scriptProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                info.options = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectPreferences(ScriptProject scriptProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = scriptProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                info.preferences = null;
            }
        }
    }

    public void setBuildpathBeingResolved(IScriptProject project, boolean buildpathIsResolved) {
        if (buildpathIsResolved) {
            this.getBuildpathBeingResolved().add(project);
        } else {
            this.getBuildpathBeingResolved().remove(project);
        }
    }

    private HashSet getBuildpathBeingResolved() {
        HashSet result = (HashSet)this.buildpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet();
            this.buildpathsBeingResolved.set(result);
        }
        return result;
    }

    public boolean isBuildpathBeingResolved(IScriptProject project) {
        return this.getBuildpathBeingResolved().contains(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardPerWorkingCopyInfo(SourceModule workingCopy) throws ModelException {
        ModelElementDeltaBuilder deltaBuilder = null;
        if (workingCopy.isPrimary() && workingCopy.hasUnsavedChanges()) {
            deltaBuilder = new ModelElementDeltaBuilder(workingCopy);
        }
        PerWorkingCopyInfo info = null;
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            Map workingCopyToInfos;
            WorkingCopyOwner owner;
            block12: {
                block11: {
                    owner = workingCopy.getOwner();
                    workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block11;
                    return -1;
                }
                info = (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
                if (info != null) break block12;
                return -1;
            }
            if (--info.useCount == 0) {
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.closeBuffer();
            if (deltaBuilder != null) {
                this.getSourceModuleInfoCache().remove(workingCopy);
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                    this.getDeltaProcessor().registerModelDelta(deltaBuilder.delta);
                }
            }
        }
        return info.useCount;
    }

    public synchronized String intern(String s) {
        return (String)this.stringSymbols.add(s);
    }

    public void startup() throws CoreException {
        try {
            this.cache = new ModelCache();
            DLTKCore.getPlugin().getStateLocation();
            this.initializePreferences();
            this.propertyListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    ModelManager.this.optionsCache = null;
                    if ("org.eclipse.dltk.core.contentCache".equals(event.getKey())) {
                        IFileCache newCache = ModelManager.this.createFileCache();
                        if (newCache instanceof IFileCacheManagement) {
                            ((IFileCacheManagement)newCache).start();
                        }
                        IFileCache oldCache = ModelManager.this.fileCache;
                        ModelManager.this.fileCache = newCache;
                        if (oldCache != null && oldCache instanceof IFileCacheManagement) {
                            ((IFileCacheManagement)oldCache).stop();
                        }
                    }
                }
            };
            ModelManager.installPreferenceChangeListener("org.eclipse.dltk.core", this.propertyListener);
            this.resourcesPropertyListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    if ("encoding".equals(event.getKey())) {
                        ModelManager.this.optionsCache = null;
                    }
                }
            };
            ModelManager.installPreferenceChangeListener(ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), this.resourcesPropertyListener);
            long start = -1L;
            if (VERBOSE) {
                start = System.currentTimeMillis();
            }
            this.loadContainers();
            if (VERBOSE) {
                this.traceContainers("Loaded", start);
            }
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 31);
            DLTKContentTypeManager.installListener();
            this.fileCache = this.createFileCache();
            if (this.fileCache instanceof IFileCacheManagement) {
                ((IFileCacheManagement)this.fileCache).start();
            }
            this.sourceModuleInfoCache = new SourceModuleInfoCache();
            this.sourceModuleInfoCache.start();
            this.startIndexing();
            Job processSavedState = new Job(Messages.savedState_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor progress) throws CoreException {
                                ISavedState savedState = workspace.addSaveParticipant(DLTKCore.getPlugin(), (ISaveParticipant)ModelManager.this);
                                if (savedState != null) {
                                    (this).ModelManager.this.deltaState.getDeltaProcessor().overridenEventType = 1;
                                    savedState.processResourceChangeEvents((IResourceChangeListener)(this).ModelManager.this.deltaState);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            processSavedState.setSystem(true);
            processSavedState.setPriority(20);
            processSavedState.schedule();
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    private static IEclipsePreferences getPluginPreferences(String pluginId) {
        return new InstanceScope().getNode(pluginId);
    }

    private static void installPreferenceChangeListener(String pluginId, IEclipsePreferences.IPreferenceChangeListener listener) {
        ModelManager.getPluginPreferences(pluginId).addPreferenceChangeListener(listener);
    }

    private IFileCache createFileCache() {
        String selectedCacheId = DLTKCore.getPlugin().getPluginPreferences().getString("org.eclipse.dltk.core.contentCache");
        if (selectedCacheId != null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.core.fileCache");
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (selectedCacheId.equals(element.getAttribute("id"))) {
                    try {
                        IFileCache cache = (IFileCache)element.createExecutableExtension("class");
                        if (!selectedCacheId.equals(cache.getId())) break;
                        return cache;
                    }
                    catch (Exception e) {
                        DLTKCore.error("FileCache create error", e);
                    }
                    break;
                }
                ++i;
            }
        }
        return new FileCacheStub();
    }

    private void startIndexing() {
        this.getIndexManager().reset();
        ProjectIndexerManager.startIndexing();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readState(IProject project) throws CoreException {
        File file = this.getSerializationFile(project);
        if (file != null && file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    String pluginID = in.readUTF();
                    if (!pluginID.equals("org.eclipse.dltk.core")) {
                        throw new IOException(Messages.build_wrongFileFormat);
                    }
                    String kind = in.readUTF();
                    if (!kind.equals("STATE")) {
                        throw new IOException(Messages.build_wrongFileFormat);
                    }
                    if (in.readBoolean()) {
                        State state = ScriptBuilder.readState(project, in);
                        return state;
                    }
                    if (!ScriptBuilder.DEBUG) return null;
                    System.out.println("Saved state thinks last build failed for " + project.getName());
                    return null;
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
            }
        }
        if (!ScriptBuilder.DEBUG) return null;
        if (file == null) {
            System.out.println("Project does not exist: " + project);
            return null;
        }
        System.out.println("Build state file " + file.getPath() + " does not exist");
        return null;
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = BP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            String projectName = propertyName.substring(containerPrefixLength, index).trim();
            IScriptProject project = ModelManager.getModelManager().getModel().getScriptProject(projectName);
            Path containerPath = new Path(propertyName.substring(index + 1).trim());
            ModelManager.recreatePersistedContainer(project, (IPath)containerPath, containerString, addToContainerValues);
        }
    }

    private static void recreatePersistedContainer(final IScriptProject project, final IPath containerPath, String containerString, boolean addToContainerValues) {
        if (!project.getProject().isAccessible()) {
            return;
        }
        if (containerString == null) {
            ModelManager.getModelManager().containerPut(project, containerPath, null);
        } else {
            IBuildpathEntry[] entries;
            try {
                entries = ((ScriptProject)project).decodeBuildpath(containerString, null);
            }
            catch (IOException e) {
                Util.log(e, "Could not recreate persisted container: \n" + containerString);
                entries = ScriptProject.INVALID_BUILDPATH;
            }
            if (entries != ScriptProject.INVALID_BUILDPATH) {
                HashMap<IPath, 5> projectContainers;
                final IBuildpathEntry[] containerEntries = entries;
                IBuildpathContainer container = new IBuildpathContainer(){

                    public IBuildpathEntry[] getBuildpathEntries() {
                        return containerEntries;
                    }

                    public String getDescription() {
                        return "Persisted container [" + containerPath + " for project [" + project.getElementName() + "]";
                    }

                    public int getKind() {
                        return 0;
                    }

                    public IPath getPath() {
                        return containerPath;
                    }

                    public String toString() {
                        return this.getDescription();
                    }
                };
                if (addToContainerValues) {
                    ModelManager.getModelManager().containerPut(project, containerPath, container);
                }
                if ((projectContainers = (HashMap<IPath, 5>)ModelManager.getModelManager().previousSessionContainers.get(project)) == null) {
                    projectContainers = new HashMap<IPath, 5>(1);
                    ModelManager.getModelManager().previousSessionContainers.put(project, projectContainers);
                }
                projectContainers.put(containerPath, container);
            }
        }
    }

    public void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode("org.eclipse.dltk.core");
        this.preferencesLookup[1] = new DefaultScope().getNode("org.eclipse.dltk.core");
        Object listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == ModelManager.this.preferencesLookup[0]) {
                    ModelManager.this.preferencesLookup[0] = new InstanceScope().getNode("org.eclipse.dltk.core");
                    ModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(listener);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
        listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == ModelManager.this.preferencesLookup[1]) {
                    ModelManager.this.preferencesLookup[1] = new DefaultScope().getNode("org.eclipse.dltk.core");
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(listener);
    }

    public void shutdown() {
        IEclipsePreferences preferences = ModelManager.getPluginPreferences("org.eclipse.dltk.core");
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Could not save DLTKCore preferences");
        }
        preferences.removePreferenceChangeListener(this.propertyListener);
        ModelManager.getPluginPreferences(ResourcesPlugin.getPlugin().getBundle().getSymbolicName()).removePreferenceChangeListener(this.resourcesPropertyListener);
        if (this.coreCache != null) {
            this.coreCache.stop();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
        DLTKContentTypeManager.uninstallListener();
        workspace.removeSaveParticipant((Plugin)DLTKCore.getDefault());
        if (this.fileCache != null && this.fileCache instanceof IFileCacheManagement) {
            ((IFileCacheManagement)this.fileCache).stop();
        }
        if (this.sourceModuleInfoCache != null) {
            this.sourceModuleInfoCache.stop();
        }
        if (this.indexManager != null) {
            this.indexManager.shutdown();
        }
        try {
            Job.getJobManager().join((Object)"org.eclipse.dltk.core", null);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(ScriptProject scriptProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = scriptProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                this.perProjectInfos.remove(project);
            }
        }
    }

    public synchronized IPath variableGet(String variableName) {
        HashSet initializations = this.variableInitializationInProgress();
        if (initializations.contains(variableName)) {
            return VARIABLE_INITIALIZATION_IN_PROGRESS;
        }
        return (IPath)this.variables.get(variableName);
    }

    private synchronized IPath variableGetDefaultToPreviousSession(String variableName) {
        IPath variablePath = (IPath)this.variables.get(variableName);
        if (variablePath == null) {
            return this.getPreviousSessionVariable(variableName);
        }
        return variablePath;
    }

    private HashSet variableInitializationInProgress() {
        HashSet initializations = (HashSet)this.variableInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashSet();
            this.variableInitializationInProgress.set(initializations);
        }
        return initializations;
    }

    public synchronized String[] variableNames() {
        int length = this.variables.size();
        String[] result = new String[length];
        Iterator vars = this.variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public synchronized void variablePut(String variableName, IPath variablePath) {
        HashSet initializations = this.variableInitializationInProgress();
        if (variablePath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
            initializations.add(variableName);
            return;
        }
        initializations.remove(variableName);
        if (variablePath == null) {
            this.variables.put(variableName, BP_ENTRY_IGNORE_PATH);
            this.variablesWithInitializer.remove(variableName);
        } else {
            this.variables.put(variableName, variablePath);
        }
        this.previousSessionVariables.remove(variableName);
    }

    public void variablePreferencesPut(String variableName, IPath variablePath) {
        String variableKey = BP_VARIABLE_PREFERENCES_PREFIX + variableName;
        if (variablePath == null) {
            this.getInstancePreferences().remove(variableKey);
        } else {
            this.getInstancePreferences().put(variableKey, variablePath.toString());
        }
        try {
            this.getInstancePreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public boolean variablePutIfInitializingWithSameValue(String[] variableNames, IPath[] variablePaths) {
        if (variableNames.length != 1) {
            return false;
        }
        String variableName = variableNames[0];
        IPath oldPath = this.variableGetDefaultToPreviousSession(variableName);
        if (oldPath == null) {
            return false;
        }
        IPath newPath = variablePaths[0];
        if (!oldPath.equals((Object)newPath)) {
            return false;
        }
        this.variablePut(variableName, newPath);
        return true;
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (DLTKLanguageManager.hasScriptNature(project)) {
            PerProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.dltk.core");
        return workingLocation.append("state.dat").toFile();
    }

    public Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
        for (String propertyName : this.optionNames) {
            String value = defaultPreferences.get(propertyName, null);
            if (value == null) continue;
            defaultOptions.put(propertyName, value);
        }
        defaultOptions.put("org.eclipse.dltk.core.encoding", DLTKCore.getEncoding());
        return defaultOptions;
    }

    public IEclipsePreferences getDefaultPreferences() {
        return this.preferencesLookup[1];
    }

    private Hashtable<String, String> getDefaultOptionsNoInitialization() {
        System.err.println("Add language dependent compiler options. Or implement it in another whan in DLTK way...");
        HashMap defaultOptionsMap = new HashMap();
        return new Hashtable<String, String>(defaultOptionsMap);
    }

    public IBuildpathContainer getBuildpathContainer(IPath containerPath, IScriptProject project) throws ModelException {
        IBuildpathContainer container = this.containerGet(project, containerPath);
        if (container == null) {
            if (this.batchContainerInitializations) {
                this.batchContainerInitializations = false;
                return this.initializeAllContainers(project, containerPath);
            }
            return this.initializeContainer(project, containerPath);
        }
        return container;
    }

    public synchronized IBuildpathContainer containerGet(IScriptProject project, IPath containerPath) {
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        if (projectInitializations.contains(containerPath)) {
            return CONTAINER_INITIALIZATION_IN_PROGRESS;
        }
        Map projectContainers = (Map)this.containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IBuildpathContainer container = (IBuildpathContainer)projectContainers.get(containerPath);
        return container;
    }

    private HashSet containerInitializationInProgress(IScriptProject project) {
        HashSet projectInitializations;
        HashMap initializations = (HashMap)this.containerInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashMap();
            this.containerInitializationInProgress.set(initializations);
        }
        if ((projectInitializations = (HashSet)initializations.get(project)) == null) {
            projectInitializations = new HashSet();
            initializations.put(project, projectInitializations);
        }
        return projectInitializations;
    }

    private IBuildpathContainer initializeAllContainers(IScriptProject scriptProjectToInit, IPath containerToInit) throws ModelException {
        block16: {
            final HashMap allContainerPaths = new HashMap();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IProject project = projects[i];
                if (DLTKLanguageManager.hasScriptNature(project)) {
                    ScriptProject scriptProject = new ScriptProject(project, this.getModel());
                    HashSet<IPath> paths = null;
                    IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
                    int j = 0;
                    int length2 = rawBuildpath.length;
                    while (j < length2) {
                        IBuildpathEntry entry = rawBuildpath[j];
                        IPath path = entry.getPath();
                        if (entry.getEntryKind() == 5 && this.containerGet(scriptProject, path) == null) {
                            if (paths == null) {
                                paths = new HashSet<IPath>();
                                allContainerPaths.put(scriptProject, paths);
                            }
                            paths.add(path);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            HashSet<IPath> containerPaths = (HashSet<IPath>)allContainerPaths.get(scriptProjectToInit);
            if (containerPaths == null) {
                containerPaths = new HashSet<IPath>();
                allContainerPaths.put(scriptProjectToInit, containerPaths);
            }
            containerPaths.add(containerToInit);
            this.containerInitializationInProgress.set(allContainerPaths);
            boolean ok = false;
            try {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            Set keys = allContainerPaths.keySet();
                            int length = keys.size();
                            IScriptProject[] scriptProjects = new IScriptProject[length];
                            keys.toArray(scriptProjects);
                            int i = 0;
                            while (i < length) {
                                IScriptProject scriptProject = scriptProjects[i];
                                HashSet pathSet = (HashSet)allContainerPaths.get(scriptProject);
                                if (pathSet != null) {
                                    int length2 = pathSet.size();
                                    IPath[] paths = new IPath[length2];
                                    pathSet.toArray(paths);
                                    int j = 0;
                                    while (j < length2) {
                                        IPath path = paths[j];
                                        ModelManager.this.initializeContainer(scriptProject, path);
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (workspace.isTreeLocked()) {
                        runnable.run(null);
                    } else {
                        workspace.run(runnable, null, 1, null);
                    }
                    ok = true;
                }
                catch (CoreException coreException) {
                    System.err.println("Exception while initializing all containers");
                    if (!ok) {
                        this.containerInitializationInProgress.set(null);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.containerInitializationInProgress.set(null);
                }
                throw throwable;
            }
            if (!ok) {
                this.containerInitializationInProgress.set(null);
            }
        }
        return this.containerGet(scriptProjectToInit, containerToInit);
    }

    IBuildpathContainer initializeContainer(IScriptProject project, IPath containerPath) throws ModelException {
        IBuildpathContainer container = null;
        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer(containerPath.segment(0));
        if (initializer != null) {
            if (BP_RESOLVE_VERBOSE) {
                this.verbose_triggering_container_initialization(project, containerPath, initializer);
            }
            this.containerPut(project, containerPath, CONTAINER_INITIALIZATION_IN_PROGRESS);
            boolean ok = false;
            try {
                initializer.initialize(containerPath, project);
                container = this.containerGet(project, containerPath);
                if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    return null;
                }
                try {
                    ok = true;
                }
                catch (CoreException e) {
                    if (e instanceof ModelException) {
                        throw (ModelException)e;
                    }
                    throw new ModelException(e);
                }
                catch (RuntimeException e) {
                    if (BP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                catch (Error e) {
                    if (BP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
            finally {
                if (!ok) {
                    this.containerRemoveInitializationInProgress(project, containerPath);
                    if (BP_RESOLVE_VERBOSE) {
                        this.verbose_container_initialization_failed(project, containerPath, container, initializer);
                    }
                }
            }
            if (BP_RESOLVE_VERBOSE) {
                this.verbose_container_value_after_initialization(project, containerPath, container);
            }
        } else if (BP_RESOLVE_VERBOSE) {
            Util.verbose("CPContainer INIT - no initializer found\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath);
        }
        return container;
    }

    private void verbose_triggering_container_initialization(IScriptProject project, IPath containerPath, BuildpathContainerInitializer initializer) {
        Util.verbose("BPContainer INIT - triggering initialization\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer + '\n' + "\tinvocation stack trace:");
        new Exception("<Fake exception>").printStackTrace(System.out);
    }

    private void verbose_container_value_after_initialization(IScriptProject project, IPath containerPath, IBuildpathContainer container) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CPContainer INIT - after resolution\n");
        buffer.append("\tproject: " + project.getElementName() + '\n');
        buffer.append("\tcontainer path: " + containerPath + '\n');
        if (container != null) {
            buffer.append("\tcontainer: " + container.getDescription() + " {\n");
            IBuildpathEntry[] entries = container.getBuildpathEntries();
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    buffer.append("\t\t" + entries[i] + '\n');
                    ++i;
                }
            }
            buffer.append("\t}");
        } else {
            buffer.append("\tcontainer: {unbound}");
        }
        Util.verbose(buffer.toString());
    }

    private void verbose_container_initialization_failed(IScriptProject project, IPath containerPath, IBuildpathContainer container, BuildpathContainerInitializer initializer) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            Util.verbose("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
        } else {
            Util.verbose("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
        }
    }

    public IBuildpathContainer getPreviousSessionContainer(IPath containerPath, IScriptProject project) {
        IBuildpathContainer previousContainer;
        Map previousContainerValues = (Map)this.previousSessionContainers.get(project);
        if (previousContainerValues != null && (previousContainer = (IBuildpathContainer)previousContainerValues.get(containerPath)) != null) {
            if (BP_RESOLVE_VERBOSE) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("CPContainer INIT - reentering access to project container during its initialization, will see previous value\n");
                buffer.append("\tproject: " + project.getElementName() + '\n');
                buffer.append("\tcontainer path: " + containerPath + '\n');
                buffer.append("\tprevious value: ");
                buffer.append(previousContainer.getDescription());
                buffer.append(" {\n");
                IBuildpathEntry[] entries = previousContainer.getBuildpathEntries();
                if (entries != null) {
                    int j = 0;
                    while (j < entries.length) {
                        buffer.append(" \t\t");
                        buffer.append(entries[j]);
                        buffer.append('\n');
                        ++j;
                    }
                }
                buffer.append(" \t}");
                Util.verbose(buffer.toString());
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousContainer;
        }
        return null;
    }

    public IPath getPreviousSessionVariable(String variableName) {
        IPath previousPath = (IPath)this.previousSessionVariables.get(variableName);
        if (previousPath != null) {
            return previousPath;
        }
        return null;
    }

    public synchronized void containerPut(IScriptProject project, IPath containerPath, IBuildpathContainer container) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            HashSet projectInitializations = this.containerInitializationInProgress(project);
            projectInitializations.add(containerPath);
            return;
        }
        this.containerRemoveInitializationInProgress(project, containerPath);
        HashMap<IPath, IBuildpathContainer> projectContainers = (HashMap<IPath, IBuildpathContainer>)this.containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IBuildpathContainer>(1);
            this.containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
        } else {
            projectContainers.put(containerPath, container);
        }
        Map previousContainers = (Map)this.previousSessionContainers.get(project);
        if (previousContainers != null) {
            previousContainers.remove(containerPath);
        }
    }

    public synchronized void containerRemove(IScriptProject project) {
        Map initializations = (Map)this.containerInitializationInProgress.get();
        if (initializations != null) {
            initializations.remove(project);
        }
        this.containers.remove(project);
    }

    private void containerRemoveInitializationInProgress(IScriptProject project, IPath containerPath) {
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        projectInitializations.remove(containerPath);
        if (projectInitializations.size() == 0) {
            Map initializations = (Map)this.containerInitializationInProgress.get();
            initializations.remove(project);
        }
    }

    public boolean containerPutIfInitializingWithSameEntries(IPath containerPath, IScriptProject[] projects, IBuildpathContainer[] respectiveContainers) {
        int projectLength = projects.length;
        if (projectLength != 1) {
            return false;
        }
        final IBuildpathContainer container = respectiveContainers[0];
        if (container == null) {
            return false;
        }
        IScriptProject project = projects[0];
        if (!this.containerInitializationInProgress(project).contains(containerPath)) {
            return false;
        }
        IBuildpathContainer previousSessionContainer = this.getPreviousSessionContainer(containerPath, project);
        final IBuildpathEntry[] newEntries = container.getBuildpathEntries();
        if (previousSessionContainer == null) {
            if (newEntries.length == 0) {
                this.containerPut(project, containerPath, container);
                return true;
            }
            return false;
        }
        final IBuildpathEntry[] oldEntries = previousSessionContainer.getBuildpathEntries();
        if (oldEntries.length != newEntries.length) {
            return false;
        }
        int i = 0;
        int length = newEntries.length;
        while (i < length) {
            if (!newEntries[i].equals(oldEntries[i])) {
                if (BP_RESOLVE_VERBOSE) {
                    Util.verbose("CPContainer SET  - missbehaving container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + Util.toString(projects, new Util.Displayable(){

                        public String displayString(Object o) {
                            return ((IScriptProject)o).getElementName();
                        }
                    }) + "}\n\tvalues on previous session: {\n" + Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < oldEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(oldEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "}\n\tnew values: {\n" + Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < newEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(newEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "\n\t}");
                }
                return false;
            }
            ++i;
        }
        this.containerPut(project, containerPath, container);
        return true;
    }

    public IArchive getArchive(IPath path, IProjectFragment archiveProjectFragment) throws CoreException {
        IArchive zipFile;
        Map<IPath, IArchive> map = this.zipFiles.get();
        if (map != null && (zipFile = map.get(path)) != null) {
            return zipFile;
        }
        File localFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        if (file != null) {
            URI location;
            if (file.getType() != 1 || (location = file.getLocationURI()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", -1, Messages.bind(Messages.file_notFound, path.toString()), null));
            }
            localFile = Util.toLocalFile(location, null);
            if (localFile == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", -1, Messages.bind(Messages.file_notFound, path.toString()), null));
            }
        } else {
            if (EnvironmentPathUtils.isFull(path)) {
                path = EnvironmentPathUtils.getLocalPath(path);
            }
            localFile = path.toFile();
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [ModelManager.getZipFile(IPath)] Creating ZipFile on " + localFile);
            }
            zipFile = this.openArchive(archiveProjectFragment, localFile);
            if (map != null) {
                map.put(path, zipFile);
            }
            return zipFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", -1, Messages.status_IOException, (Throwable)e));
        }
    }

    public IArchive openArchive(IProjectFragment archiveProjectFragment, File localFile) throws IOException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(archiveProjectFragment);
        if (toolkit != null) {
            return toolkit.openArchive(localFile);
        }
        return new ZipArchiveFile(localFile);
    }

    public IFileCache getFileCache() {
        return this.fileCache;
    }

    public void cacheZipFiles() {
        if (this.zipFiles.get() != null) {
            return;
        }
        this.zipFiles.set(new HashMap());
    }

    public void closeArchive(IArchive zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this.zipFiles.get() != null) {
            return;
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [ModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
            }
            zipFile.close();
        }
        catch (IOException iOException) {}
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    private void traceContainers(String action, long start) {
        Long delta = new Long(System.currentTimeMillis() - start);
        Long length = new Long(this.getContainersFile().length());
        String pattern = "{0} {1} bytes in containers.dat in {2}ms";
        String message = NLS.bind((String)pattern, (Object[])new Object[]{action, length, delta});
        System.out.println(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject;
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        this.savesContainers();
        if (VERBOSE) {
            this.traceContainers("Saved", start);
        }
        if (context.getKind() == 1) {
            context.needDelta();
            IndexManager manager = this.indexManager;
            if (manager != null && this.workspaceScope != null) {
                manager.cleanUpIndexes();
            }
        }
        if ((savedProject = context.getProject()) != null) {
            if (!ScriptProject.hasScriptNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            info.rememberExternalLibTimestamps();
            return;
        }
        ArrayList<IStatus> vStats = null;
        ArrayList values = null;
        Map map = this.perProjectInfos;
        synchronized (map) {
            values = new ArrayList(this.perProjectInfos.values());
        }
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            try {
                PerProjectInfo info = (PerProjectInfo)iterator.next();
                this.saveState(info, context);
                info.rememberExternalLibTimestamps();
            }
            catch (CoreException e) {
                if (vStats == null) {
                    vStats = new ArrayList<IStatus>();
                }
                vStats.add(e.getStatus());
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.dltk.core", 4, stats, Messages.build_cannotSaveStates, null));
        }
        this.deltaState.saveExternalLibTimeStamps();
    }

    private File getContainersFile() {
        return DLTKCore.getPlugin().getStateLocation().append("Containers.dat").toFile();
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (ScriptBuilder.DEBUG) {
            System.out.println(Messages.bind(Messages.build_saveStateProgress, info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("org.eclipse.dltk.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    ScriptBuilder.writeState(info.savedState, out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        if (ScriptBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(Messages.bind(Messages.build_saveStateComplete, String.valueOf(t)));
        }
    }

    private void savesContainers() throws CoreException {
        File file = this.getContainersFile();
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                ((DataOutputStream)out).writeInt(1);
                new ContainersSaveHelper((DataOutputStream)out).save();
                IScriptProject[] projects = this.getModel().getScriptProjects();
                int length = projects.length;
                ((DataOutputStream)out).writeInt(length);
                int i = 0;
                while (i < length) {
                    IScriptProject project = projects[i];
                    Map projectContainers = this.containerClone(project);
                    ((DataOutputStream)out).writeUTF(project.getElementName());
                    if (projectContainers == null) {
                        ((DataOutputStream)out).writeInt(0);
                    } else {
                        HashMap<IPath, String> containersToSave = new HashMap<IPath, String>();
                        for (IPath containerPath : projectContainers.keySet()) {
                            IBuildpathContainer container = (IBuildpathContainer)projectContainers.get(containerPath);
                            String containerString = null;
                            try {
                                if (container == null) {
                                    container = this.getPreviousSessionContainer(containerPath, project);
                                }
                                if (container != null) {
                                    IBuildpathEntry[] entries = container.getBuildpathEntries();
                                    containerString = ((ScriptProject)project).encodeBuildpath(entries, false, null);
                                }
                            }
                            catch (ModelException e) {
                                Util.log((Throwable)((Object)e), "Could not persist container " + containerPath + " for project " + project.getElementName());
                            }
                            if (containerString == null) continue;
                            containersToSave.put(containerPath, containerString);
                        }
                        ((DataOutputStream)out).writeInt(containersToSave.size());
                        for (IPath containerPath : containersToSave.keySet()) {
                            ((DataOutputStream)out).writeUTF(containerPath.toPortableString());
                            String containerString = (String)containersToSave.get(containerPath);
                            ((DataOutputStream)out).writeInt(containerString.length());
                            ((DataOutputStream)out).writeBytes(containerString);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.dltk.core", 4, "Problems while saving variables and containers", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected synchronized void resetZIPTypeCache() {
        this.cache.resetZIPTypeCache();
    }

    public DLTKWorkspaceScope getWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        if (this.workspaceScope == null) {
            this.workspaceScope = new HashMap();
        }
        if (this.workspaceScope.containsKey(toolkit)) {
            return (DLTKWorkspaceScope)this.workspaceScope.get(toolkit);
        }
        DLTKWorkspaceScope scope = new DLTKWorkspaceScope(toolkit);
        this.workspaceScope.put(toolkit, scope);
        return scope;
    }

    private synchronized Map containerClone(IScriptProject project) {
        Map originalProjectContainers = (Map)this.containers.get(project);
        if (originalProjectContainers == null) {
            return null;
        }
        HashMap projectContainers = new HashMap(originalProjectContainers.size());
        projectContainers.putAll(originalProjectContainers);
        return projectContainers;
    }

    /*
     * Unable to fully structure code
     */
    public void loadContainers() throws CoreException {
        block22: {
            this.loadVariablesAndContainers(this.getDefaultPreferences());
            this.loadVariablesAndContainers(this.getInstancePreferences());
            file = this.getContainersFile();
            in = null;
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                switch (in.readInt()) {
                    case 1: {
                        new ContainersLoadHelper((DataInputStream)in).load();
                    }
                }
            }
            catch (IOException e) {
                if (file.exists()) {
                    Util.log(e, "Unable to read variable and containers file");
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException v0) {}
                }
                break block22;
            }
            catch (RuntimeException e) {
                try {
                    if (file.exists()) {
                        Util.log(e, "Unable to read variable and containers file (file is corrupt)");
                    }
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var4_5) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var4_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block22;
                }
            }
            if (in == null) break block22;
            try {
                in.close();
            }
            catch (IOException v3) {}
        }
        this.containersReset(ModelManager.getRegisteredContainerIDs());
    }

    private void loadVariablesAndContainers(IEclipsePreferences preferences) {
        try {
            String[] propertyNames = preferences.keys();
            int variablePrefixLength = BP_VARIABLE_PREFERENCES_PREFIX.length();
            int i = 0;
            while (i < propertyNames.length) {
                String propertyValue;
                String propertyName = propertyNames[i];
                if (propertyName.startsWith(BP_VARIABLE_PREFERENCES_PREFIX)) {
                    String varName = propertyName.substring(variablePrefixLength);
                    String propertyValue2 = preferences.get(propertyName, null);
                    if (propertyValue2 != null) {
                        String pathString = propertyValue2.trim();
                        if (BP_ENTRY_IGNORE.equals(pathString)) {
                            preferences.remove(propertyName);
                        } else {
                            Path varPath = new Path(pathString);
                            this.variables.put(varName, varPath);
                            this.previousSessionVariables.put(varName, varPath);
                        }
                    }
                } else if (propertyName.startsWith(BP_CONTAINER_PREFERENCES_PREFIX) && (propertyValue = preferences.get(propertyName, null)) != null) {
                    preferences.remove(propertyName);
                    ModelManager.recreatePersistedContainer(propertyName, propertyValue, true);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static String[] getRegisteredContainerIDs() {
        Plugin dltkCorePlugin = DLTKCore.getPlugin();
        if (dltkCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.core", BPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    private synchronized void containersReset(String[] containerIDs) {
        int i = 0;
        while (i < containerIDs.length) {
            String containerID = containerIDs[i];
            for (IScriptProject project : this.containers.keySet()) {
                Map projectContainers = (Map)this.containers.get(project);
                if (projectContainers == null) continue;
                for (IPath containerPath : projectContainers.keySet()) {
                    if (!containerPath.segment(0).equals(containerID)) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++i;
        }
    }

    public void flushZipFiles() {
        Thread currentThread = Thread.currentThread();
        Map<IPath, IArchive> map = this.zipFiles.get();
        if (map == null) {
            return;
        }
        this.zipFiles.set(null);
        for (IArchive zipFile : map.values()) {
            try {
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + currentThread + ") [ModelManager.flushZipFiles()] Closing ZipFile on " + zipFile.getName());
                }
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ISourceModuleInfoCache getSourceModuleInfoCache() {
        return this.sourceModuleInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserLibraryManager getUserLibraryManager() {
        if (ModelManager.MANAGER.userLibraryManager == null) {
            UserLibraryManager libraryManager = new UserLibraryManager();
            ModelManager modelManager = MANAGER;
            synchronized (modelManager) {
                if (ModelManager.MANAGER.userLibraryManager == null) {
                    ModelManager.MANAGER.userLibraryManager = libraryManager;
                }
            }
        }
        return ModelManager.MANAGER.userLibraryManager;
    }

    private final class ContainersLoadHelper {
        private static final int ARRAY_INCREMENT = 200;
        private IBuildpathEntry[] allBuildpathEntries = null;
        private int allBuildpathEntryCount = 0;
        private final Map allPaths = new HashMap();
        private String[] allStrings = null;
        private int allStringsCount = 0;
        private final DataInputStream in;

        ContainersLoadHelper(DataInputStream in) {
            this.in = in;
        }

        void load() throws IOException {
            this.loadProjects(ModelManager.this.getModel());
        }

        private IAccessRule loadAccessRule() throws IOException {
            int problemId = this.loadInt();
            IPath pattern = this.loadPath();
            return new BuildpathAccessRule(pattern.toString().toCharArray(), problemId);
        }

        private IAccessRule[] loadAccessRules() throws IOException {
            int count = this.loadInt();
            if (count == 0) {
                return BuildpathEntry.NO_ACCESS_RULES;
            }
            IAccessRule[] rules = new IAccessRule[count];
            int i = 0;
            while (i < count) {
                rules[i] = this.loadAccessRule();
                ++i;
            }
            return rules;
        }

        private IBuildpathAttribute loadAttribute() throws IOException {
            String name = this.loadString();
            String value = this.loadString();
            return new BuildpathAttribute(name, value);
        }

        private IBuildpathAttribute[] loadAttributes() throws IOException {
            int count = this.loadInt();
            if (count == 0) {
                return BuildpathEntry.NO_EXTRA_ATTRIBUTES;
            }
            IBuildpathAttribute[] attributes = new IBuildpathAttribute[count];
            int i = 0;
            while (i < count) {
                attributes[i] = this.loadAttribute();
                ++i;
            }
            return attributes;
        }

        private boolean loadBoolean() throws IOException {
            return this.in.readBoolean();
        }

        private IBuildpathEntry[] loadBuildpathEntries() throws IOException {
            int count = this.loadInt();
            IBuildpathEntry[] entries = new IBuildpathEntry[count];
            int i = 0;
            while (i < count) {
                entries[i] = this.loadBuildpathEntry();
                ++i;
            }
            return entries;
        }

        private IBuildpathEntry loadBuildpathEntry() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allBuildpathEntryCount) {
                throw new IOException("Unexpected buildpathentry id");
            }
            if (id < this.allBuildpathEntryCount) {
                return this.allBuildpathEntries[id];
            }
            int contentKind = this.loadInt();
            int entryKind = this.loadInt();
            IPath path = this.loadPath();
            IPath[] inclusionPatterns = this.loadPaths();
            IPath[] exclusionPatterns = this.loadPaths();
            boolean isExported = this.loadBoolean();
            boolean isExternal = this.loadBoolean();
            IAccessRule[] accessRules = this.loadAccessRules();
            boolean combineAccessRules = this.loadBoolean();
            IBuildpathAttribute[] extraAttributes = this.loadAttributes();
            BuildpathEntry entry = new BuildpathEntry(contentKind, entryKind, path, isExported, inclusionPatterns, exclusionPatterns, accessRules, combineAccessRules, extraAttributes, isExternal);
            IBuildpathEntry[] array = this.allBuildpathEntries;
            if (array == null || id == array.length) {
                array = new IBuildpathEntry[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allBuildpathEntries, 0, array, 0, id);
                }
                this.allBuildpathEntries = array;
            }
            array[id] = entry;
            this.allBuildpathEntryCount = id + 1;
            return entry;
        }

        private void loadContainers(IScriptProject project) throws IOException {
            boolean projectIsAccessible = project.getProject().isAccessible();
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                IPath path = this.loadPath();
                IBuildpathEntry[] entries = this.loadBuildpathEntries();
                if (projectIsAccessible) {
                    PersistedBuildpathContainer container = new PersistedBuildpathContainer(project, path, entries);
                    ModelManager.this.containerPut(project, path, container);
                    HashMap<IPath, PersistedBuildpathContainer> oldContainers = (HashMap<IPath, PersistedBuildpathContainer>)ModelManager.this.previousSessionContainers.get(project);
                    if (oldContainers == null) {
                        oldContainers = new HashMap<IPath, PersistedBuildpathContainer>();
                        ModelManager.this.previousSessionContainers.put(project, oldContainers);
                    }
                    oldContainers.put(path, container);
                }
                ++i;
            }
        }

        private int loadInt() throws IOException {
            return this.in.readInt();
        }

        private IPath loadPath() throws IOException {
            if (this.loadBoolean()) {
                return null;
            }
            String portableString = this.loadString();
            IPath path = (IPath)this.allPaths.get(portableString);
            if (path == null) {
                path = Path.fromPortableString((String)portableString);
                this.allPaths.put(portableString, path);
            }
            return path;
        }

        private IPath[] loadPaths() throws IOException {
            int count = this.loadInt();
            IPath[] pathArray = new IPath[count];
            int i = 0;
            while (i < count) {
                pathArray[i] = this.loadPath();
                ++i;
            }
            return pathArray;
        }

        private void loadProjects(IScriptModel model) throws IOException {
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                String projectName = this.loadString();
                this.loadContainers(model.getScriptProject(projectName));
                ++i;
            }
        }

        private String loadString() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allStringsCount) {
                throw new IOException("Unexpected string id");
            }
            if (id < this.allStringsCount) {
                return this.allStrings[id];
            }
            String string = this.in.readUTF();
            String[] array = this.allStrings;
            if (array == null || id == array.length) {
                array = new String[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allStrings, 0, array, 0, id);
                }
                this.allStrings = array;
            }
            array[id] = string;
            this.allStringsCount = id + 1;
            return string;
        }
    }

    private final class ContainersSaveHelper {
        private final HashtableOfObjectToInt buildpathEntryIds = new HashtableOfObjectToInt();
        private final DataOutputStream out;
        private final HashtableOfObjectToInt stringIds;

        ContainersSaveHelper(DataOutputStream out) {
            this.out = out;
            this.stringIds = new HashtableOfObjectToInt();
        }

        void save() throws IOException, ModelException {
            this.saveProjects(ModelManager.this.getModel().getScriptProjects());
        }

        private void saveAccessRule(BuildpathAccessRule rule) throws IOException {
            this.saveInt(rule.problemId);
            this.savePath(rule.getPattern());
        }

        private void saveAccessRules(IAccessRule[] rules) throws IOException {
            int count = rules == null ? 0 : rules.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveAccessRule((BuildpathAccessRule)rules[i]);
                ++i;
            }
        }

        private void saveAttribute(IBuildpathAttribute attribute) throws IOException {
            this.saveString(attribute.getName());
            this.saveString(attribute.getValue());
        }

        private void saveAttributes(IBuildpathAttribute[] attributes) throws IOException {
            int count = attributes == null ? 0 : attributes.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveAttribute(attributes[i]);
                ++i;
            }
        }

        private void saveBuildpathEntries(IBuildpathEntry[] entries) throws IOException {
            int count = entries == null ? 0 : entries.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveBuildpathEntry(entries[i]);
                ++i;
            }
        }

        private void saveBuildpathEntry(IBuildpathEntry entry) throws IOException {
            if (this.saveNewId(entry, this.buildpathEntryIds)) {
                this.saveInt(entry.getContentKind());
                this.saveInt(entry.getEntryKind());
                this.savePath(entry.getPath());
                this.savePaths(entry.getInclusionPatterns());
                this.savePaths(entry.getExclusionPatterns());
                this.out.writeBoolean(entry.isExported());
                this.out.writeBoolean(entry.isExternal());
                this.saveAccessRules(entry.getAccessRules());
                this.out.writeBoolean(entry.combineAccessRules());
                this.saveAttributes(entry.getExtraAttributes());
            }
        }

        private void saveContainers(IScriptProject project, Map containerMap) throws IOException {
            this.saveInt(containerMap.size());
            for (Map.Entry entry : containerMap.entrySet()) {
                IPath path = (IPath)entry.getKey();
                IBuildpathContainer container = (IBuildpathContainer)entry.getValue();
                IBuildpathEntry[] cpEntries = null;
                if (container == null) {
                    container = ModelManager.this.getPreviousSessionContainer(path, project);
                }
                if (container != null) {
                    cpEntries = container.getBuildpathEntries();
                }
                this.savePath(path);
                this.saveBuildpathEntries(cpEntries);
            }
        }

        private void saveInt(int value) throws IOException {
            this.out.writeInt(value);
        }

        private boolean saveNewId(Object key, HashtableOfObjectToInt map) throws IOException {
            int id = map.get(key);
            if (id == -1) {
                int newId = map.size();
                map.put(key, newId);
                this.saveInt(newId);
                return true;
            }
            this.saveInt(id);
            return false;
        }

        private void savePath(IPath path) throws IOException {
            if (path == null) {
                this.out.writeBoolean(true);
            } else {
                this.out.writeBoolean(false);
                this.saveString(path.toPortableString());
            }
        }

        private void savePaths(IPath[] paths) throws IOException {
            int count = paths == null ? 0 : paths.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.savePath(paths[i]);
                ++i;
            }
        }

        private void saveProjects(IScriptProject[] projects) throws IOException, ModelException {
            int count = projects.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                IScriptProject project = projects[i];
                this.saveString(project.getElementName());
                Map containerMap = (HashMap)ModelManager.this.containers.get(project);
                containerMap = containerMap == null ? Collections.EMPTY_MAP : new HashMap(containerMap);
                this.saveContainers(project, containerMap);
                ++i;
            }
        }

        private void saveString(String string) throws IOException {
            if (this.saveNewId(string, this.stringIds)) {
                this.out.writeUTF(string);
            }
        }
    }

    public static class EclipsePreferencesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String propertyName = event.getKey();
            if (propertyName.startsWith(ModelManager.BP_CONTAINER_PREFERENCES_PREFIX)) {
                ModelManager.recreatePersistedContainer(propertyName, (String)event.getNewValue(), false);
            } else if (propertyName.startsWith(ModelManager.BP_USERLIBRARY_PREFERENCES_PREFIX)) {
                String libName = propertyName.substring(ModelManager.BP_USERLIBRARY_PREFERENCES_PREFIX.length());
                UserLibraryManager manager = ModelManager.getUserLibraryManager();
                manager.updateUserLibrary(libName, (String)event.getNewValue());
            }
        }
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IBuildpathEntry[] rawBuildpath;
        public IModelStatus rawBuildpathStatus;
        public IBuildpathEntry[] resolvedBuildpath;
        public IModelStatus unresolvedEntryStatus;
        public Map resolvedPathToRawEntries;
        public IEclipsePreferences preferences;
        public Hashtable options;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }

        public void rememberExternalLibTimestamps() {
            block7: {
                IBuildpathEntry[] buildpath = this.resolvedBuildpath;
                if (buildpath == null) {
                    return;
                }
                Map<IPath, Long> externalTimeStamps = ModelManager.getModelManager().deltaState.getExternalLibTimeStamps();
                int i = 0;
                int length = buildpath.length;
                while (i < length) {
                    Object target;
                    IPath path;
                    IBuildpathEntry entry = buildpath[i];
                    if (entry.getEntryKind() == 1 && externalTimeStamps.get(path = entry.getPath()) == null && (target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true)) instanceof IFileHandle) {
                        long timestamp = DeltaProcessor.getTimeStamp((IFileHandle)target);
                        externalTimeStamps.put(path, new Long(timestamp));
                    }
                    ++i;
                }
                Map<IPath, Long> customTimeStamps = ModelManager.getModelManager().deltaState.getCustomTimeStamps();
                try {
                    IScriptProject scriptProject = DLTKCore.create(this.project);
                    IProjectFragment[] fragments = scriptProject.getAllProjectFragments();
                    int i2 = 0;
                    while (i2 < fragments.length) {
                        if (fragments[i2] instanceof IProjectFragmentTimestamp) {
                            IProjectFragmentTimestamp stamp = (IProjectFragmentTimestamp)((Object)fragments[i2]);
                            long timeStamp = stamp.getTimeStamp();
                            customTimeStamps.put(fragments[i2].getPath(), new Long(timeStamp));
                        }
                        ++i2;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }

        public synchronized void resetResolvedBuildpath() {
            this.resolvedBuildpath = null;
        }

        public synchronized void updateBuildpathInformation(IBuildpathEntry[] newRawBuildpath) {
            this.rawBuildpath = newRawBuildpath;
            this.resolvedBuildpath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw buildpath:\n");
            if (this.rawBuildpath == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = this.rawBuildpath.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(this.rawBuildpath[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Resolved buildpath:\n");
            IBuildpathEntry[] resolvedCP = this.resolvedBuildpath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = resolvedCP.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(resolvedCP[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            return buffer.toString();
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IProblemRequestor problemRequestor;
        ISourceModule workingCopy;

        public PerWorkingCopyInfo(ISourceModule workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        public void acceptProblem(IProblem problem) {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(problem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public ISourceModule getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((ModelElement)((Object)this.workingCopy)).toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            return buffer.toString();
        }
    }

    private static final class PersistedBuildpathContainer
    implements IBuildpathContainer {
        private final IPath containerPath;
        private final IBuildpathEntry[] entries;
        private final IScriptProject project;

        PersistedBuildpathContainer(IScriptProject project, IPath containerPath, IBuildpathEntry[] entries) {
            this.containerPath = containerPath;
            this.entries = entries;
            this.project = project;
        }

        public IBuildpathEntry[] getBuildpathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return "Persisted container [" + this.containerPath + " for project [" + this.project.getElementName() + "]]";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return this.containerPath;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

