/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IProjectChange;
import org.eclipse.dltk.core.builder.IRenameChange;
import org.eclipse.dltk.internal.core.builder.AbstractBuildChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildChange
extends AbstractBuildChange
implements IBuildChange {
    private final IResourceDelta resourceDelta;
    private final List<IFile> files;
    private List<ISourceModule> modules;
    private List<IFile> realResources;
    private int buildType = 0;

    public BuildChange(IProject project, IResourceDelta resourceDelta, List<IFile> files, IProgressMonitor monitor) {
        super(project, monitor);
        this.resourceDelta = resourceDelta;
        this.files = files;
    }

    @Override
    public IResourceDelta getResourceDelta() {
        return this.resourceDelta;
    }

    @Override
    public List<IPath> getDeletes(int options) throws CoreException {
        return Collections.emptyList();
    }

    @Override
    public List<IRenameChange> getRenames() throws CoreException {
        return Collections.emptyList();
    }

    @Override
    public List<IFile> getResources(int options) throws CoreException {
        if (((options = BuildChange.validateFlags(options, 15)) & 0xB) == 10) {
            throw new IllegalArgumentException();
        }
        if (BuildChange.checkFlag(options, 4)) {
            return Collections.unmodifiableList(this.files);
        }
        this.loadSourceModules();
        return Collections.unmodifiableList(this.realResources);
    }

    @Override
    public List<ISourceModule> getSourceModules(int options) throws CoreException {
        BuildChange.validateFlags(options, 3);
        this.loadSourceModules();
        return Collections.unmodifiableList(this.modules);
    }

    private void loadSourceModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<ISourceModule>();
            this.realResources = new ArrayList<IFile>();
            this.locateSourceModules(this.files, this.modules, this.realResources);
        }
    }

    @Override
    public int getBuildType() {
        return this.buildType;
    }

    @Override
    public void setBuildType(int buildType) {
        this.buildType = buildType;
    }

    @Override
    public boolean isDependencyBuild() {
        return false;
    }

    @Override
    public boolean addChangedResource(IFile file) throws CoreException {
        return false;
    }

    @Override
    public List<IPath> getExternalPaths(int options) throws CoreException {
        return Collections.emptyList();
    }

    @Override
    public List<ISourceModule> getExternalModules(int options) throws CoreException {
        return Collections.emptyList();
    }

    @Override
    public IProjectChange[] getRequiredProjectChanges() {
        return NO_PROJECT_CHANGES;
    }
}

