/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class DoWhileStatement
extends Statement {
    private Expression fCondition;
    private Statement fAction;

    public DoWhileStatement(DLTKToken doToken, Statement action, Expression condition, int endPosition) {
        super(doToken.getColumn(), endPosition);
        this.fAction = action;
        this.fCondition = condition;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fAction != null) {
                this.fAction.traverse(pVisitor);
            }
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2009;
    }

    public Statement getAction() {
        return this.fAction;
    }

    public Expression getCondition() {
        return this.fCondition;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("do:");
        output.indent();
        if (this.fAction != null) {
            this.fAction.printNode(output);
        }
        output.dedent();
        if (this.fCondition != null) {
            output.formatPrintLn("while: ");
            this.fCondition.printNode(output);
        }
    }
}

