/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.javascript.parser.ISeverityReporter;
import org.eclipse.dltk.javascript.parser.JSProblemIdentifier;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.JavaScriptParserSeverityReporter;
import org.eclipse.dltk.javascript.parser.LineTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter
extends LineTracker
implements IProblemReporter,
JSProblemReporter {
    private final IProblemReporter problemReporter;
    private IProblemIdentifier id;
    private String message;
    private int line;
    private int start;
    private int end;
    private ProblemSeverity severity;
    private int problemCount;
    private final ISeverityReporter severityReporter;
    private Set<IProblemIdentifier> suppressed;
    private Stack<Set<IProblemIdentifier>> suppressedStack = null;

    public Reporter(ISourceLineTracker lineTracker, IProblemReporter problemReporter) {
        this(lineTracker, problemReporter, new JavaScriptParserSeverityReporter());
    }

    public Reporter(ISourceLineTracker lineTracker, IProblemReporter problemReporter, ISeverityReporter severityReporter) {
        super(lineTracker);
        this.problemReporter = problemReporter;
        this.severityReporter = severityReporter;
        this.reset();
    }

    private void reset() {
        this.severity = ProblemSeverity.WARNING;
        this.id = null;
        this.message = null;
        this.line = -1;
        this.start = -1;
        this.end = -1;
    }

    public void report() {
        if (this.problemReporter != null && this.message != null) {
            this.reportProblem(this.createProblem());
        }
        this.reset();
    }

    private IProblem createProblem() {
        if (this.line == -1 && this.start != -1) {
            this.line = this.getLineNumberOfOffset(this.start);
        }
        if (this.line > this.getNumberOfLines() && this.start >= 0 && this.start <= this.getLength()) {
            this.line = this.getLineNumberOfOffset(this.start);
        }
        if (this.severityReporter != null) {
            this.severity = this.severityReporter.getSeverity(this.id, this.severity);
            if (this.severity == null) {
                return null;
            }
        }
        return new DefaultProblem(this.message, this.id, null, this.severity, this.start, this.end, this.line);
    }

    public void setFormattedMessage(JSProblemIdentifier id, Object ... args) {
        this.id = id;
        this.message = id.formatMessage(args);
    }

    public void setMessage(JSProblemIdentifier id) {
        this.id = id;
        this.message = id.getMessage();
    }

    public void setMessage(IProblemIdentifier id, String message) {
        this.id = id;
        this.message = message;
    }

    public IProblemIdentifier getId() {
        return this.id;
    }

    public void setId(IProblemIdentifier id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public ProblemSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(ProblemSeverity severity) {
        this.severity = severity;
    }

    public void setRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public void reportProblem(IProblem problem) {
        if (this.problemReporter != null && problem != null) {
            ++this.problemCount;
            this.problemReporter.reportProblem(problem);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void reportProblem(IProblemIdentifier identifier, String message, int start, int end) {
        if (this.isSuppressed(identifier)) {
            return;
        }
        this.reportProblem(ProblemSeverity.WARNING, identifier, message, start, end);
    }

    @Override
    public void reportProblem(ProblemSeverity severity, IProblemIdentifier id, String message, int start, int end) {
        if (this.isSuppressed(id)) {
            return;
        }
        ProblemSeverity sev = severity;
        if (this.severityReporter != null && ((sev = this.severityReporter.getSeverity(id, sev)) == null || sev == ProblemSeverity.IGNORE)) {
            return;
        }
        this.reportProblem((IProblem)new DefaultProblem(message, id, null, sev, start, end, this.getLineNumberOfOffset(start)));
    }

    @Override
    public int getProblemCount() {
        return this.problemCount;
    }

    private boolean isSuppressed(IProblemIdentifier identifier) {
        return this.suppressed != null && this.suppressed.contains(identifier);
    }

    public void suppressProblems(IProblemIdentifier ... identifiers) {
        if (this.suppressed == null) {
            this.suppressed = new HashSet<IProblemIdentifier>();
        }
        Collections.addAll(this.suppressed, identifiers);
    }

    @Override
    public void pushSuppressWarnings(Collection<IProblemIdentifier> suppressed) {
        if (this.suppressedStack == null) {
            this.suppressedStack = new Stack();
        }
        this.suppressedStack.push(this.suppressed);
        this.suppressed = this.suppressed == null ? new HashSet<IProblemIdentifier>() : new HashSet<IProblemIdentifier>(this.suppressed);
        this.suppressed.addAll(suppressed);
    }

    @Override
    public void popSuppressWarnings() {
        if (this.suppressedStack != null && !this.suppressedStack.isEmpty()) {
            this.suppressed = this.suppressedStack.pop();
        }
    }
}

