/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.infoviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.DelegatedOpen;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.infoviews.InfoViewMessages;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementArray {
    private final Object[] elements;
    private static final long NAME_FLAGS = 786432L;
    private static final long TOOLTIP_FLAGS = -9223372034704359373L;

    public ModelElementArray(Object[] elements) {
        Assert.isLegal((elements != null && elements.length > 1 ? 1 : 0) != 0);
        this.elements = elements;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelElementArray) {
            ModelElementArray other = (ModelElementArray)obj;
            return Arrays.equals(this.elements, other.elements);
        }
        return false;
    }

    public Object[] getElements() {
        return this.elements;
    }

    private boolean isSingleMethodName() {
        IModelElement element0;
        if (this.elements[0] instanceof IModelElement && (element0 = (IModelElement)this.elements[0]).getElementType() == 9) {
            String methodName = element0.getElementName();
            int i = 1;
            while (i < this.elements.length) {
                if (!(this.elements[i] instanceof IModelElement)) {
                    return false;
                }
                IModelElement element = (IModelElement)this.elements[i];
                if (element.getElementType() != 9 || !methodName.equals(element.getElementName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getContentDescription() {
        if (this.isSingleMethodName()) {
            return NLS.bind((String)InfoViewMessages.ContentDescription_multipleMethodsWithSameName, (Object)((IModelElement)this.elements[0]).getElementName());
        }
        ScriptElementLabels labels = ScriptElementLabels.getDefault();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] instanceof IModelElement) {
                names.add(labels.getElementLabel((IModelElement)this.elements[i], 786432L));
            } else if (this.elements[i] instanceof DelegatedOpen) {
                names.add(((DelegatedOpen)this.elements[i]).getName());
            }
            ++i;
        }
        return this.sortAndJoin(names, ", ");
    }

    private String sortAndJoin(Set<String> names, String separator) {
        ArrayList<String> nameList = new ArrayList<String>(names);
        Collections.sort(nameList);
        return ModelElementArray.join(nameList, separator);
    }

    public String getTitleTooltip() {
        ScriptElementLabels labels = ScriptElementLabels.getDefault();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] instanceof IModelElement) {
                names.add(labels.getElementLabel((IModelElement)this.elements[i], -9223372034704359373L));
            } else if (this.elements[i] instanceof DelegatedOpen) {
                names.add(((DelegatedOpen)this.elements[i]).getName());
            }
            ++i;
        }
        return this.sortAndJoin(names, "\n");
    }

    private static String join(Collection<?> collection, String separator) {
        return TextUtils.join(collection, (String)separator);
    }
}

