/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.search.IOccurrencesFinder;

public class ModelElementOccurrencesFinder
implements IOccurrencesFinder {
    private ISourceModule module;
    private SearchPattern pattern;
    private String occurrenceLocationDescription;

    public String initialize(ISourceModule module, IModuleDeclaration root, int offset, int length) {
        IModelElement[] elements;
        this.module = module;
        this.pattern = null;
        try {
            elements = module.codeSelect(offset, length);
        }
        catch (ModelException e) {
            return e.toString();
        }
        if (elements.length == 0) {
            return "No selection";
        }
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            this.pattern = SearchPattern.createPattern((IModelElement)element, (int)2);
            if (this.pattern != null) {
                this.occurrenceLocationDescription = "Occurrence of '" + element.getElementName() + "'";
                break;
            }
            ++n2;
        }
        if (this.pattern == null) {
            return "Can't search for current selection";
        }
        return null;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        try {
            final ArrayList result = new ArrayList();
            new SearchEngine().search(this.pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createSearchScope((IModelElement)this.module), new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    result.add(new IOccurrencesFinder.OccurrenceLocation(match.getOffset(), match.getLength(), ModelElementOccurrencesFinder.this.occurrenceLocationDescription));
                }
            }, null);
            if (!result.isEmpty()) {
                return result.toArray(new IOccurrencesFinder.OccurrenceLocation[result.size()]);
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }
}

