/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.console.ui.ScriptConsoleUIPlugin;
import org.eclipse.dltk.tcl.internal.ui.text.TclCodeTemplateAccess;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateAccess;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TclUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.tcl.ui";
    public static final String ID_ACTION_SET = "org.eclipse.dltk.tcl.ui.TclActionSet";
    private static TclUI plugin;
    private TclTextTools fTclTextTools;
    private ICodeTemplateAccess codeTemplateAccess = null;

    public TclUI() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ScriptConsoleUIPlugin.getDefault();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.codeTemplateAccess != null) {
                if (this.codeTemplateAccess instanceof ITemplateAccess.ITemplateAccessInternal) {
                    ((ITemplateAccess.ITemplateAccessInternal)this.codeTemplateAccess).dispose();
                }
                this.codeTemplateAccess = null;
            }
        }
        finally {
            super.stop(context);
            plugin = null;
        }
    }

    public static TclUI getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return TclUI.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized TclTextTools getTextTools() {
        IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.tcl.core.nature");
        return (TclTextTools)languageToolkit.getTextTools();
    }

    public synchronized TclTextTools internalgetTextTools() {
        if (this.fTclTextTools == null) {
            this.fTclTextTools = new TclTextTools(true);
        }
        return this.fTclTextTools;
    }

    public static void error(String message) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    public static void error(Throwable t) {
        TclUI.error(t.getMessage(), t);
    }

    public static void error(String message, Throwable t) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public ICodeTemplateAccess getCodeTemplateAccess() {
        if (this.codeTemplateAccess == null) {
            this.codeTemplateAccess = new TclCodeTemplateAccess();
        }
        return this.codeTemplateAccess;
    }
}

