/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.Predicate;
import org.eclipse.dltk.internal.javascript.ti.IReferenceAttributes;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.validation.TypeInfoValidator;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.AttributeKey;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRNoneType;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.TypeMemberQuery;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.JSCustomType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementValue
implements IValue {
    protected static final IAssignProtection READONLY_PROPERTY = new IAssignProtection(){

        public IProblemIdentifier problemId() {
            return JavaScriptProblems.PROPERTY_READONLY;
        }

        public String problemMessage() {
            return ValidationMessages.AssignmentToReadonlyProperty;
        }
    };
    static final IRType NOT_INITIALIZED = new IRType(){

        public TypeCompatibility isAssignableFrom(IRType type) {
            return TypeCompatibility.FALSE;
        }

        public String getName() {
            return "NOT_INITIALIZED";
        }

        public ITypeSystem activeTypeSystem() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    };
    protected final ITypeSystem context;

    public static ElementValue findMember(ITypeSystem context, IRType type, String name) {
        return ElementValue.findMember(context, type, name, MemberPredicate.ALWAYS_TRUE);
    }

    static ElementValue findMemberA(ITypeSystem context, IRType type, String name) {
        Type target;
        MemberPredicate predicate = type instanceof IRClassType ? ((target = ((IRClassType)type).getTarget()) != null ? target.memberPredicateFor(type, MemberPredicate.STATIC) : MemberPredicate.STATIC) : (type instanceof IRSimpleType ? ((target = ((IRSimpleType)type).getTarget()) != null ? target.memberPredicateFor(type, MemberPredicate.NON_STATIC) : MemberPredicate.NON_STATIC) : (type instanceof IRUnionType ? MemberPredicate.ALWAYS_TRUE : MemberPredicate.NON_STATIC));
        return ElementValue.findMember(context, type, name, predicate);
    }

    public static ElementValue findMember(ITypeSystem context, IRType type, String name, Predicate<Member> predicate) {
        IRRecordMember member;
        IRType arrayType;
        ITypeSystem saved;
        if (type != null && (saved = type.activeTypeSystem()) != null) {
            context = saved;
        }
        if ("[]".equals(name) && (arrayType = TypeUtil.extractArrayItemType(type)) != null && TypeUtil.kind(arrayType) != TypeKind.UNKNOWN && !(arrayType instanceof IRNoneType)) {
            return new TypeValue(context, arrayType);
        }
        Type t = TypeUtil.extractType(context, type);
        if (t != null) {
            List<Member> selection = ElementValue.findMembers(t, name, predicate);
            if (!selection.isEmpty()) {
                if (selection.size() == 1) {
                    Member selected = selection.get(0);
                    if (selected instanceof Property) {
                        if (selected.getType() instanceof JSCustomType) {
                            return new PropertyValue(new NestedTypeSystem(context, t), (Property)selected);
                        }
                        return new PropertyValue(context, (Property)selected);
                    }
                    if (selected instanceof Method) {
                        if (selected.getType() instanceof JSCustomType) {
                            return new MethodValue(new NestedTypeSystem(context, t), (Method)selected);
                        }
                        return new MethodValue(context, (Method)selected);
                    }
                }
                return new MemberValue(context, selection.toArray(new Member[selection.size()]));
            }
        } else if (type instanceof IRUnionType) {
            for (IRType unionTarget : ((IRUnionType)type).getTargets()) {
                ElementValue member2 = ElementValue.findMember(context, unionTarget, name, predicate);
                if (member2 == null) continue;
                return member2;
            }
        } else if (type instanceof IRRecordType && (member = ((IRRecordType)type).getMember(name)) != null) {
            return new RTypeValue(context, member.getType(), member.getMember());
        }
        return null;
    }

    public static List<Member> findMembers(Type type, String name, Predicate<Member> predicate) {
        ArrayList<Member> selection = new ArrayList<Member>(4);
        for (Member member : new TypeMemberQuery(type, predicate).ignoreDuplicates()) {
            if (!name.equals(member.getName())) continue;
            selection.add(member);
        }
        return selection;
    }

    public static ElementValue createFor(Element element, ITypeSystem context) {
        if (element instanceof Method) {
            return new MethodValue(context, (Method)element);
        }
        if (element instanceof Property) {
            return new PropertyValue(context, (Property)element);
        }
        Type type = (Type)element;
        return new TypeValue(context, JSTypeSet.ref(context != null ? context.resolveType(type) : type));
    }

    public static ElementValue createClass(ITypeSystem context, Type type) {
        return new ClassValue(context, JSTypeSet.singleton(JSTypeSet.classType(type)));
    }

    public ElementValue(ITypeSystem context) {
        this.context = context;
    }

    protected abstract Object getElements();

    public IValue resolveValue() {
        return this;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final void addValue(IValue src) {
    }

    @Override
    public final void addReference(IValue src) {
    }

    @Override
    public final Object getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    @Override
    public Object getAttribute(String key, boolean includeReferences) {
        Object elements;
        if ("ELEMENT".equals(key)) {
            return this.getElements();
        }
        if (IReferenceAttributes.TYPE_SYSTEM.equals(key)) {
            return this.context;
        }
        if ("HIDE_ALLOWED".equals(key) && (elements = this.getElements()) instanceof Element) {
            return ((Element)elements).isHideAllowed() ? Boolean.TRUE : null;
        }
        return null;
    }

    @Override
    public final void setAttribute(String key, Object value) {
    }

    @Override
    public final Set<String> getDirectChildren() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return Collections.emptySet();
    }

    @Override
    public void deleteChild(String name) {
    }

    @Override
    public final boolean hasChild(String name) {
        return false;
    }

    @Override
    public final IValue createChild(String name, int flags) {
        return this.getChild(name, true);
    }

    @Override
    public void putChild(String name, IValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceKind getKind() {
        return ReferenceKind.UNKNOWN;
    }

    @Override
    public final ReferenceLocation getLocation() {
        return ReferenceLocation.UNKNOWN;
    }

    @Override
    public JSTypeSet getTypes() {
        return JSTypeSet.emptySet();
    }

    @Override
    public final void setDeclaredType(IRType declaredType) {
    }

    @Override
    public void addType(IRType type) {
    }

    @Override
    public final void setKind(ReferenceKind kind) {
    }

    @Override
    public final void setLocation(ReferenceLocation location) {
    }

    private static class ClassValue
    extends ElementValue
    implements IValue {
        private final JSTypeSet types;

        public ClassValue(ITypeSystem context, JSTypeSet types) {
            super(context);
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        public IValue getChild(String name, boolean resolve) {
            if (name.equals("()")) {
                IRType type;
                if (this.types.size() == 1 && (type = this.types.getFirst()) instanceof IRClassType) {
                    return new TypeValue(this.context, JSTypeSet.singleton(((IRClassType)type).toItemType()));
                }
                JSTypeSet returnTypes = JSTypeSet.create();
                for (IRType type2 : this.types) {
                    if (type2 instanceof IRClassType) {
                        returnTypes.add(((IRClassType)type2).toItemType());
                        continue;
                    }
                    returnTypes.add(type2);
                }
                return new TypeValue(this.context, returnTypes);
            }
            for (IRType type : this.types) {
                ElementValue child = ClassValue.findMember(this.context, type, name, MemberPredicate.STATIC);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            return this.types.getFirst();
        }

        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.TYPE;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }

    private static class MemberValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final Member[] members;

        public MemberValue(ITypeSystem context, Member[] members) {
            super(context);
            this.members = members;
        }

        protected Member[] getElements() {
            return this.members;
        }

        public IValue resolveValue() {
            IValue value;
            if (this.members.length == 1 && (value = this.context.valueOf(this.members[0])) != null) {
                value.setDeclaredType(this.getDeclaredType());
                value.setAttribute("ELEMENT", this.getAttribute("ELEMENT"));
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Method) {
                    return ReferenceKind.METHOD;
                }
                ++n2;
            }
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            ElementValue child;
            IRType type;
            if ("()".equals(name)) {
                JSTypeSet types = null;
                Member[] memberArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method;
                    Member member = memberArray[n2];
                    if (member instanceof Method && (method = (Method)member).getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(JSTypeSet.normalize(this.context, method.getType()));
                    }
                    ++n2;
                }
                if (types != null) {
                    if (this.functionOperator == null) {
                        this.functionOperator = new TypeValue(this.context, types);
                    }
                    return this.functionOperator;
                }
            }
            if ((type = this.getDeclaredType()) != null && (child = ElementValue.findMember(this.context, type, name)) != null) {
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Property) {
                    Property property = (Property)member;
                    if (property.getType() != null) {
                        return JSTypeSet.normalize(this.context, property.getType());
                    }
                } else if (member instanceof Method) {
                    return JSTypeSet.ref(TypeInfoModelLoader.getInstance().getType("Function"));
                }
                ++n2;
            }
            return null;
        }

        public JSTypeSet getDeclaredTypes() {
            JSTypeSet types = null;
            Member[] memberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                Member member = memberArray[n2];
                if (member instanceof Property) {
                    Property property = (Property)member;
                    if (property.getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(JSTypeSet.normalize(this.context, property.getType()));
                    }
                } else if (member instanceof Method) {
                    if (types == null) {
                        types = JSTypeSet.create();
                    }
                    types.add(JSTypeSet.ref(TypeInfoModelLoader.getInstance().getType("Function")));
                }
                ++n2;
            }
            if (types != null) {
                return types;
            }
            return JSTypeSet.emptySet();
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key)) {
                Member[] memberArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    Member member = memberArray[n2];
                    if (member instanceof Property && ((Property)member).isReadOnly()) {
                        return READONLY_PROPERTY;
                    }
                    ++n2;
                }
                return null;
            }
            return super.getAttribute(key, includeReferences);
        }
    }

    private static class MethodValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final Method method;

        public MethodValue(ITypeSystem context, Method method) {
            super(context);
            this.method = method;
        }

        protected Method getElements() {
            return this.method;
        }

        public IValue resolveValue() {
            IValue value = this.context.valueOf(this.method);
            if (value != null) {
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.METHOD;
        }

        public IValue getChild(String name, boolean resolve) {
            if ("()".equals(name) && this.method.getType() != null) {
                if (this.functionOperator == null) {
                    this.functionOperator = new TypeValue(this.context, JSTypeSet.singleton(JSTypeSet.normalize(this.context, this.method.getType())));
                }
                return this.functionOperator;
            }
            ElementValue child = ElementValue.findMember(this.context, this.getDeclaredType(), name);
            if (child != null) {
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            return JSTypeSet.ref(TypeInfoModelLoader.getInstance().getType("Function"));
        }

        public JSTypeSet getDeclaredTypes() {
            return JSTypeSet.singleton(this.getDeclaredType());
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.method + '>';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedTypeSystem
    implements ITypeSystem {
        private final ITypeSystem origin;
        private final Type ownerType;

        public NestedTypeSystem(ITypeSystem origin, Type ownerType) {
            this.origin = origin;
            this.ownerType = ownerType;
        }

        @Override
        public Type resolveType(Type type) {
            return this.origin.resolveType(type);
        }

        @Override
        public IValue valueOf(Member member) {
            return this.origin.valueOf(member);
        }

        @Override
        public Type parameterize(Type target, List<IRType> parameters) {
            return this.origin.parameterize(target, parameters);
        }

        @Override
        public <T> T getAttribute(AttributeKey<T> key) {
            if (TypeInfoValidator.MEMBER_OWNER == key) {
                return (T)this.ownerType;
            }
            return this.origin.getAttribute(key);
        }
    }

    private static class PropertyValue
    extends ElementValue
    implements IValue {
        private final Property property;
        private final Map<String, IValue> children = new HashMap<String, IValue>();
        private IRType declaredType = NOT_INITIALIZED;
        private JSTypeSet declaredTypes = null;

        public PropertyValue(ITypeSystem context, Property property) {
            super(context);
            this.property = property;
        }

        protected Property getElements() {
            return this.property;
        }

        public IValue resolveValue() {
            IValue value = this.context.valueOf(this.property);
            if (value != null) {
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            IValue child = this.children.get(name);
            if (child == null) {
                IRType propType;
                ElementValue eValue;
                if (name.equals("[]") && this.property.getType() != null) {
                    Type arrayType = null;
                    if (this.property.getType() instanceof ArrayType) {
                        arrayType = TypeUtil.extractType(((ArrayType)this.property.getType()).getItemType());
                    } else if (this.property.getType() instanceof MapType) {
                        arrayType = TypeUtil.extractType(((MapType)this.property.getType()).getValueType());
                    }
                    if (arrayType != null) {
                        child = PropertyValue.createFor(arrayType, this.context);
                        this.children.put(name, child);
                        return child;
                    }
                }
                if ((eValue = ElementValue.findMemberA(this.context, propType = this.getDeclaredType(), name)) != null) {
                    child = eValue.resolveValue();
                    this.children.put(name, child);
                }
            }
            return child;
        }

        public IRType getDeclaredType() {
            if (this.declaredType == NOT_INITIALIZED) {
                this.declaredType = JSTypeSet.normalize(this.context, this.property.getType());
            }
            return this.declaredType;
        }

        public JSTypeSet getDeclaredTypes() {
            if (this.declaredTypes == null) {
                IRType type = this.getDeclaredType();
                this.declaredTypes = type != null ? JSTypeSet.singleton(type) : JSTypeSet.emptySet();
            }
            return this.declaredTypes;
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key)) {
                return this.property.isReadOnly() ? READONLY_PROPERTY : null;
            }
            return super.getAttribute(key, includeReferences);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.property + '>';
        }
    }

    private static class RTypeValue
    extends ElementValue
    implements IValue {
        private final IRType type;
        private final Map<String, IValue> children = new HashMap<String, IValue>();
        private final Member element;

        public RTypeValue(ITypeSystem context, IRType type, Member element) {
            super(context);
            this.type = type;
            this.element = element;
        }

        protected Member getElements() {
            return this.element;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            IValue child = this.children.get(name);
            if (child == null) {
                ElementValue eValue;
                if (name.equals("[]")) {
                    Type arrayType = null;
                    if (this.type instanceof IRArrayType) {
                        arrayType = TypeUtil.extractType(this.context, ((IRArrayType)this.type).getItemType());
                    } else if (this.type instanceof IRMapType) {
                        arrayType = TypeUtil.extractType(this.context, ((IRMapType)this.type).getValueType());
                    }
                    if (arrayType != null) {
                        ElementValue arrayOpChild = RTypeValue.createFor(arrayType, this.context);
                        this.children.put(name, arrayOpChild);
                        return arrayOpChild;
                    }
                } else if ("()".equals(name) && this.type instanceof IRFunctionType) {
                    child = new Value();
                    child.addType(((IRFunctionType)this.type).getReturnType());
                    this.children.put(name, child);
                    return child;
                }
                if ((eValue = ElementValue.findMember(this.context, this.type, name)) != null) {
                    child = eValue.resolveValue();
                    this.children.put(name, child);
                }
            }
            return child;
        }

        public IRType getDeclaredType() {
            return this.type;
        }

        public JSTypeSet getDeclaredTypes() {
            if (this.type != null) {
                return JSTypeSet.singleton(this.type);
            }
            return JSTypeSet.emptySet();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.type + '>';
        }
    }

    private static class TypeValue
    extends ElementValue
    implements IValue {
        private Value arrayLookup;
        private final JSTypeSet types;

        public TypeValue(ITypeSystem context, IRType type) {
            super(context);
            this.types = JSTypeSet.singleton(type);
        }

        public TypeValue(ITypeSystem context, JSTypeSet types) {
            super(context);
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        public IValue getChild(String name, boolean resolve) {
            if (name.equals("[]")) {
                if (this.arrayLookup == null) {
                    this.arrayLookup = new Value();
                }
                return this.arrayLookup;
            }
            for (IRType type : this.types) {
                ElementValue child = TypeValue.findMember(this.context, type, name);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            return this.types.getFirst();
        }

        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        public final JSTypeSet getTypes() {
            return this.types;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }
}

