/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterCallback;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterIndentGenerator;
import org.eclipse.dltk.formatter.IFormatterRawWriter;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.formatter.internal.ExcludeRegionList;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.IRegion;

public class FormatterWriter
implements IFormatterWriter {
    private final StringBuilder writer = new StringBuilder();
    private final StringBuilder indent = new StringBuilder();
    private final StringBuilder trimmedSpaces = new StringBuilder();
    protected final StringBuilder callbackBuffer = new StringBuilder();
    private final StringBuilder emptyLines = new StringBuilder();
    private boolean lineStarted = false;
    private char lastChar = '\u0000';
    private int lineNumber = 0;
    private final List<IFormatterCallback> newLineCallbacks = new ArrayList<IFormatterCallback>();
    private final String lineDelimiter;
    private final IFormatterDocument document;
    private final IFormatterIndentGenerator indentGenerator;
    private int linesPreserve = -1;
    private int wrapLength = -1;
    private boolean preserveSpaces = true;
    private boolean skipNextNewLine = false;
    private boolean canAppendToPreviousLine = false;
    private boolean trimTrailingSpaces = true;
    private boolean trimBlankLines = true;
    private boolean keepLines = false;
    private final ExcludeRegionList excludes = new ExcludeRegionList();

    public FormatterWriter(IFormatterDocument document, String lineDelimiter, IFormatterIndentGenerator indentGenerator) {
        this.document = document;
        this.lineDelimiter = lineDelimiter;
        this.indentGenerator = indentGenerator;
    }

    public void ensureLineStarted(IFormatterContext context) {
        if (!this.lineStarted) {
            this.startLine(context);
        }
    }

    public void write(IFormatterContext context, int startOffset, int endOffset) {
        if (!this.excludes.isExcluded(startOffset, endOffset)) {
            if (endOffset > startOffset) {
                this.write(context, this.document.get(startOffset, endOffset));
            }
        } else {
            IRegion[] regions = this.excludes.selectValidRanges(startOffset, endOffset);
            int i = 0;
            while (i < regions.length) {
                this.write(context, this.document.get(regions[i]));
                ++i;
            }
        }
    }

    public void writeText(IFormatterContext context, String text) {
        if (text.length() != 0) {
            this.skipNextNewLine = false;
        }
        if (this.lineStarted) {
            this.trimTrailingSpaces(false);
        }
        this.write(context, text);
    }

    private void trimTrailingSpaces(boolean keepTrimmed) {
        int length = this.writer.length();
        while (length > 0 && FormatterUtils.isSpace(this.writer.charAt(length - 1))) {
            --length;
        }
        if (keepTrimmed) {
            this.trimmedSpaces.append(this.writer, length, this.writer.length());
        }
        if (length < this.writer.length()) {
            this.writer.setLength(length);
        }
    }

    public void writeLineBreak(IFormatterContext context) {
        if (this.lineStarted && !this.keepLines) {
            this.write(context, this.lineDelimiter);
            assert (!this.lineStarted);
            this.skipNextNewLine = true;
        }
    }

    public void skipNextLineBreaks(IFormatterContext context) {
        this.skipNextLineBreaks(context, true);
    }

    public void skipNextLineBreaks(IFormatterContext context, boolean value) {
        if (!this.keepLines) {
            this.skipNextNewLine = value;
        }
    }

    public void appendToPreviousLine(IFormatterContext context, String text) {
        if (!this.lineStarted && this.canAppendToPreviousLine) {
            this.skipNextNewLine = false;
            this.emptyLines.setLength(0);
            this.indent.setLength(0);
            int len = this.writer.length();
            if (len > 0) {
                if (this.writer.charAt(len - 1) == '\n') {
                    if (--len > 0 && this.writer.charAt(len - 1) == '\r') {
                        --len;
                    }
                } else if (this.writer.charAt(len - 1) == '\r') {
                    --len;
                }
                this.writer.setLength(len);
                if (text.length() == 0) {
                    this.writer.append((CharSequence)this.trimmedSpaces);
                    this.trimmedSpaces.setLength(0);
                } else {
                    this.writer.append(text);
                }
                this.lineStarted = true;
            }
        }
    }

    public void disableAppendToPreviousLine() {
        this.canAppendToPreviousLine = false;
    }

    protected void write(IFormatterContext context, String text) {
        if (!context.isWrapping()) {
            int i = 0;
            while (i < text.length()) {
                this.write(context, text.charAt(i));
                ++i;
            }
        } else {
            int start = this.findLineStart();
            int offset = this.lineStarted ? this.calculateOffset(start) : 0;
            int savedLineNumber = this.lineNumber;
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (this.lineStarted && !FormatterUtils.isSpace(ch) && !FormatterUtils.isLineSeparator(ch)) {
                    if (savedLineNumber != this.lineNumber) {
                        start = this.findLineStart();
                        offset = this.calculateOffset(start);
                        savedLineNumber = this.lineNumber;
                    }
                    if (this.wrapLength > 0 && offset > this.wrapLength) {
                        int begin = start;
                        while (begin < this.writer.length() && FormatterUtils.isSpace(this.writer.charAt(begin))) {
                            ++begin;
                        }
                        if (begin < this.writer.length() && this.writer.charAt(begin) == '#') {
                            ++begin;
                        }
                        while (begin < this.writer.length() && FormatterUtils.isSpace(this.writer.charAt(begin))) {
                            ++begin;
                        }
                        int wordBegin = this.writer.length();
                        while (wordBegin > begin && !FormatterUtils.isSpace(this.writer.charAt(wordBegin - 1))) {
                            --wordBegin;
                        }
                        int prevWordEnd = wordBegin;
                        while (prevWordEnd > begin && FormatterUtils.isSpace(this.writer.charAt(prevWordEnd - 1))) {
                            --prevWordEnd;
                        }
                        if (prevWordEnd > begin) {
                            this.writer.replace(prevWordEnd, wordBegin, String.valueOf(this.lineDelimiter) + "# ");
                            start = prevWordEnd + this.lineDelimiter.length();
                            offset = this.calculateOffset(start);
                        }
                    }
                }
                this.write(context, ch);
                ++offset;
                ++i;
            }
        }
    }

    private int calculateOffset(int pos) {
        int offset = 0;
        while (pos < this.writer.length()) {
            char ch;
            if ((ch = this.writer.charAt(pos++)) == '\t') {
                int tabSize = this.indentGenerator.getTabSize();
                offset = (offset + tabSize - 1) / tabSize * tabSize;
                continue;
            }
            ++offset;
        }
        return offset;
    }

    private int findLineStart() {
        int pos = this.writer.length();
        while (pos > 0 && !FormatterUtils.isLineSeparator(this.writer.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    protected void write(IFormatterContext context, char ch) {
        if (ch == '\n' || ch == '\r') {
            if (this.lineStarted) {
                this.trimmedSpaces.setLength(0);
                if (this.trimTrailingSpaces) {
                    this.trimTrailingSpaces(true);
                }
                this.writer.append(ch);
                this.lineStarted = false;
                if (!this.newLineCallbacks.isEmpty()) {
                    this.executeNewLineCallbacks(context);
                    assert (this.newLineCallbacks.isEmpty());
                }
            } else if (ch == '\n' && this.lastChar == '\r') {
                if (this.emptyLines.length() == 0) {
                    this.writer.append(ch);
                } else {
                    this.emptyLines.append(ch);
                }
            } else {
                if (!this.trimBlankLines) {
                    this.emptyLines.append((CharSequence)this.indent);
                }
                this.indent.setLength(0);
                this.emptyLines.append(ch);
            }
        } else if (!this.lineStarted) {
            if (Character.isWhitespace(ch)) {
                this.indent.append(ch);
            } else {
                this.startLine(context);
                this.writer.append(ch);
            }
        } else if (!this.preserveSpaces && context.isIndenting() && !context.isComment() && FormatterUtils.isSpace(ch)) {
            if (this.writer.charAt(this.writer.length() - 1) != ' ') {
                this.writer.append(' ');
            }
        } else {
            this.writer.append(ch);
        }
        this.lastChar = ch;
    }

    private void executeNewLineCallbacks(IFormatterContext context) {
        IFormatterRawWriter callbackWriter = new IFormatterRawWriter(){

            public void writeIndent(IFormatterContext context) {
                FormatterWriter.this.writeIndent(context, FormatterWriter.this.callbackBuffer);
            }

            public void writeText(IFormatterContext context, String text) {
                FormatterWriter.this.callbackBuffer.append(text);
            }
        };
        IFormatterCallback[] copy = this.newLineCallbacks.toArray(new IFormatterCallback[this.newLineCallbacks.size()]);
        this.newLineCallbacks.clear();
        IFormatterCallback[] iFormatterCallbackArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            IFormatterCallback callback = iFormatterCallbackArray[n2];
            callback.call(context, callbackWriter);
            ++n2;
        }
    }

    private void startLine(IFormatterContext context) {
        if (this.callbackBuffer.length() != 0) {
            this.writer.append((CharSequence)this.callbackBuffer);
            this.callbackBuffer.setLength(0);
        }
        if (context.getBlankLines() >= 0) {
            if (this.writer.length() != 0) {
                int i = 0;
                while (i < context.getBlankLines()) {
                    this.writer.append(this.lineDelimiter);
                    ++i;
                }
            }
            context.resetBlankLines();
        } else if (this.emptyLines.length() != 0) {
            this.writeEmptyLines();
        }
        this.skipNextNewLine = false;
        this.emptyLines.setLength(0);
        if (context.isIndenting()) {
            this.writeIndent(context);
        } else {
            this.writer.append((CharSequence)this.indent);
        }
        this.indent.setLength(0);
        this.lineStarted = true;
        ++this.lineNumber;
        this.canAppendToPreviousLine = true;
    }

    private void writeEmptyLines() {
        if (this.skipNextNewLine) {
            int i = 0;
            if (this.emptyLines.charAt(i) == '\r') {
                if (++i < this.emptyLines.length() && this.emptyLines.charAt(i) == '\n') {
                    ++i;
                }
            } else if (this.emptyLines.charAt(i) == '\n') {
                ++i;
            }
            if (i > 0) {
                this.emptyLines.delete(0, i);
            }
        }
        if (this.linesPreserve >= 0 && this.linesPreserve < Integer.MAX_VALUE && TextUtils.countLines((CharSequence)this.emptyLines) > this.linesPreserve) {
            this.writer.append(TextUtils.selectHeadLines((CharSequence)this.emptyLines, (int)this.linesPreserve));
        } else {
            this.writer.append((CharSequence)this.emptyLines);
        }
    }

    protected void writeIndent(IFormatterContext context) {
        this.writeIndent(context, this.writer);
    }

    protected void writeIndent(IFormatterContext context, StringBuilder buffer) {
        this.indentGenerator.generateIndent(context.getIndent(), buffer);
    }

    public String getOutput() {
        return this.writer.toString();
    }

    public void excludeRegion(IRegion region) {
        this.excludes.excludeRegion(region);
    }

    public void addNewLineCallback(IFormatterCallback callback) {
        this.newLineCallbacks.add(callback);
    }

    public void flush(IFormatterContext context) {
        if (!this.newLineCallbacks.isEmpty()) {
            if (this.lineStarted) {
                this.writer.append(this.lineDelimiter);
                this.lineStarted = false;
            }
            this.executeNewLineCallbacks(context);
            assert (this.newLineCallbacks.isEmpty());
        }
        if (this.callbackBuffer.length() != 0) {
            this.writer.append((CharSequence)this.callbackBuffer);
            this.callbackBuffer.setLength(0);
        }
        if (this.emptyLines.length() != 0) {
            this.writeEmptyLines();
            this.emptyLines.setLength(0);
        }
    }

    public int getLinesPreserve() {
        return this.linesPreserve;
    }

    public void setLinesPreserve(int value) {
        this.linesPreserve = value;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public boolean isPreserveSpaces() {
        return this.preserveSpaces;
    }

    public void setPreserveSpaces(boolean preserveSpaces) {
        this.preserveSpaces = preserveSpaces;
    }

    public boolean isTrimTrailingSpaces() {
        return this.trimTrailingSpaces;
    }

    public void setTrimTrailingSpaces(boolean trimTrailingSpaces) {
        this.trimTrailingSpaces = trimTrailingSpaces;
    }

    public boolean isTrimEmptyLines() {
        return this.trimBlankLines;
    }

    public void setTrimEmptyLines(boolean trimEmptyLines) {
        this.trimBlankLines = trimEmptyLines;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public boolean isKeepLines() {
        return this.keepLines;
    }
}

