/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.packages;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptProjectUtil;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension3;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.TclProblems;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.indexing.PackageSourceCollector;
import org.eclipse.dltk.tcl.internal.core.packages.DefaultVariablesRegistry;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.tcl.internal.core.packages.TclVariableResolver;
import org.eclipse.dltk.tcl.internal.validators.TclBuildContext;
import org.eclipse.dltk.tcl.internal.validators.packages.Messages;
import org.eclipse.dltk.tcl.validators.TclValidatorsCore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageRequireSourceAnalyser
implements IBuildParticipant,
IBuildParticipantExtension,
IBuildParticipantExtension2,
IBuildParticipantExtension3 {
    private final IScriptProject project;
    private final IInterpreterInstall install;
    private final TclVariableResolver variableResolver;
    private final PackageSourceCollector packageCollector = new PackageSourceCollector();
    private final List<ModuleInfo> modules = new ArrayList<ModuleInfo>();
    private int buildType;
    private boolean autoAddPackages;
    private Set<TclModuleInfo> providedByRequiredProjects = new HashSet<TclModuleInfo>();
    private List<TclPackageInfo> knownInfos;

    public PackageRequireSourceAnalyser(IScriptProject project) throws CoreException, IllegalStateException {
        this.project = project;
        if (!project.exists()) {
            throw new IllegalStateException(NLS.bind((String)Messages.TclCheckBuilder_interpreterNotFound, (Object)project.getElementName()));
        }
        this.install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        if (this.install == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.TclCheckBuilder_interpreterNotFound, (Object)project.getElementName()));
        }
        this.knownInfos = TclPackagesManager.getPackageInfos((IInterpreterInstall)this.install);
        this.variableResolver = new TclVariableResolver((TclVariableResolver.IVariableRegistry)new DefaultVariablesRegistry(project));
    }

    public boolean beginBuild(int buildType) {
        this.buildType = buildType;
        this.autoAddPackages = ScriptProjectUtil.isBuilderEnabled((IScriptProject)this.project);
        ArrayList moduleInfos = new ArrayList();
        moduleInfos.addAll(TclPackagesManager.getProjectModules((String)this.project.getElementName()));
        if (buildType == 1) {
            for (TclModuleInfo tclModuleInfo : moduleInfos) {
                tclModuleInfo.getProvided().clear();
                tclModuleInfo.getRequired().clear();
                tclModuleInfo.getSourced().clear();
            }
        }
        this.packageCollector.getModules().put(this.project, moduleInfos);
        this.loadProvidedPackagesFromRequiredProjects();
        return true;
    }

    private void loadProvidedPackagesFromRequiredProjects() {
        IBuildpathEntry[] resolvedBuildpath;
        try {
            resolvedBuildpath = this.project.getResolvedBuildpath(true);
        }
        catch (ModelException e) {
            TclValidatorsCore.error(e);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < resolvedBuildpath.length) {
            IPath path;
            IProject project;
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getEntryKind() == 2 && (project = workspaceRoot.getProject((path = entry.getPath()).lastSegment())).exists()) {
                List list = TclPackagesManager.getProjectModules((String)project.getName());
                this.providedByRequiredProjects.addAll(list);
            }
            ++i;
        }
    }

    public void buildExternalModule(IBuildContext context) throws CoreException {
        ISourceModule module = context.getSourceModule();
        if (module instanceof TclPackageSourceModule) {
            return;
        }
        TclModule tclModule = TclBuildContext.getStatements(context);
        EList statements = tclModule.getStatements();
        this.packageCollector.process((List)statements, module);
        this.addInfoForModule(context, module, null);
    }

    public void build(IBuildContext context) throws CoreException {
        ISourceModule module = context.getSourceModule();
        TclModule tclModule = TclBuildContext.getStatements(context);
        EList statements = tclModule.getStatements();
        if (statements == null) {
            return;
        }
        this.packageCollector.process((List)statements, module);
        this.addInfoForModule(context, module, null);
    }

    private void addInfoForModule(IBuildContext context, ISourceModule module, TclModuleInfo info) {
        IPath modulePath = module.getPath();
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.project);
        if (module.getResource() != null) {
            URI uri;
            modulePath = module.getResource().getLocation();
            if (modulePath == null) {
                uri = module.getResource().getLocationURI();
                if (uri != null) {
                    modulePath = this.updateModulePath(modulePath, env, uri);
                }
            } else {
                uri = module.getResource().getLocationURI();
                if (uri != null) {
                    modulePath = this.updateModulePath(modulePath, env, uri);
                }
            }
        }
        TclModuleInfo mInfo = this.packageCollector.getCreateCurrentModuleInfo(module);
        if (info != null) {
            mInfo.getProvided().addAll((Collection)info.getProvided());
            mInfo.getRequired().addAll((Collection)info.getRequired());
            mInfo.getSourced().addAll((Collection)info.getSourced());
        }
        this.modules.add(new ModuleInfo(module.getElementName(), context.getLineTracker(), context.getProblemReporter(), mInfo, modulePath, module));
    }

    private IPath updateModulePath(IPath modulePath, IEnvironment env, URI uri) {
        IFileHandle file;
        URI[] uris = EnvironmentManager.resolve((URI)uri);
        if (uris.length > 0 && (file = env.getFile(uris[0])) != null) {
            return file.getPath();
        }
        return modulePath;
    }

    public void endBuild(IProgressMonitor monitor) {
        monitor.subTask(Messages.TclCheckBuilder_retrievePackages);
        HashSet<String> names = new HashSet<String>();
        HashSet<String> autoNames = new HashSet<String>();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)this.project, names, autoNames);
        HashSet<String> newDependencies = new HashSet<String>();
        int remainingWork = this.modules.size();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.project);
        for (ModuleInfo moduleInfo : this.modules) {
            monitor.subTask(NLS.bind((String)Messages.TclCheckBuilder_processing, (Object)moduleInfo.name, (Object)Integer.toString(remainingWork)));
            for (TclSourceEntry ref : moduleInfo.moduleInfo.getRequired()) {
                EList corrections = moduleInfo.moduleInfo.getPackageCorrections();
                ArrayList<TclSourceEntry> toCheck = new ArrayList<TclSourceEntry>();
                for (UserCorrection userCorrection : corrections) {
                    if (!userCorrection.getOriginalValue().equals(ref.getValue())) continue;
                    for (Object correction : userCorrection.getUserValue()) {
                        TclSourceEntry to = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                        to.setEnd(ref.getEnd());
                        to.setStart(ref.getStart());
                        to.setValue((String)correction);
                        toCheck.add(to);
                    }
                }
                if (toCheck.isEmpty()) {
                    String resolved = this.variableResolver.resolve(ref.getValue());
                    if (resolved == null || resolved.equals(ref.getValue())) {
                        toCheck.add(ref);
                    } else {
                        TclSourceEntry to = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                        to.setEnd(ref.getEnd());
                        to.setStart(ref.getStart());
                        to.setValue(resolved);
                        toCheck.add(to);
                    }
                }
                for (TclSourceEntry tclSourceEntry : toCheck) {
                    this.checkPackage(tclSourceEntry, moduleInfo.reporter, moduleInfo.lineTracker, newDependencies, names, autoNames);
                }
            }
            this.checkSources(environment, moduleInfo);
            --remainingWork;
        }
        List list = (List)this.packageCollector.getModules().get(this.project);
        if (list != null) {
            for (TclModuleInfo moduleInfo : list) {
                for (TclSourceEntry ref : moduleInfo.getRequired()) {
                    EList corrections = moduleInfo.getPackageCorrections();
                    ArrayList<TclSourceEntry> toCheck = new ArrayList<TclSourceEntry>();
                    for (UserCorrection userCorrection : corrections) {
                        if (!userCorrection.getOriginalValue().equals(ref.getValue())) continue;
                        for (String correction : userCorrection.getUserValue()) {
                            TclSourceEntry to = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                            to.setEnd(ref.getEnd());
                            to.setStart(ref.getStart());
                            to.setValue(correction);
                            toCheck.add(to);
                        }
                    }
                    if (toCheck.isEmpty()) {
                        String resolved = this.variableResolver.resolve(ref.getValue());
                        if (resolved == null || resolved.equals(ref.getValue())) {
                            toCheck.add(ref);
                        } else {
                            TclSourceEntry to = TclPackagesFactory.eINSTANCE.createTclSourceEntry();
                            to.setEnd(ref.getEnd());
                            to.setStart(ref.getStart());
                            to.setValue(resolved);
                            toCheck.add(to);
                        }
                    }
                    for (TclSourceEntry tclSourceEntry : toCheck) {
                        this.checkPackage(tclSourceEntry, null, null, newDependencies, names, autoNames);
                    }
                }
            }
        }
        if (this.buildType != 10) {
            List mods = (List)this.packageCollector.getModules().get(this.project);
            ArrayList<TclModuleInfo> result = new ArrayList<TclModuleInfo>();
            for (TclModuleInfo tclModuleInfo : mods) {
                EList pkgCorrections = tclModuleInfo.getPackageCorrections();
                this.cleanCorrections((EList<UserCorrection>)pkgCorrections, (EList<TclSourceEntry>)tclModuleInfo.getRequired());
                EList sourceCorrections = tclModuleInfo.getSourceCorrections();
                this.cleanCorrections((EList<UserCorrection>)sourceCorrections, (EList<TclSourceEntry>)tclModuleInfo.getSourced());
                if (tclModuleInfo.getProvided().isEmpty() && tclModuleInfo.getRequired().isEmpty() && tclModuleInfo.getSourced().isEmpty() && sourceCorrections.isEmpty() && pkgCorrections.isEmpty()) continue;
                result.add(tclModuleInfo);
            }
            TclPackagesManager.setProjectModules((String)this.project.getElementName(), result);
            InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)this.project, names, newDependencies);
            try {
                ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.project}, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ModelException e) {
                DLTKCore.error((String)Messages.PackageRequireSourceAnalyser_ModelUpdateFailure, (Throwable)e);
            }
        }
    }

    private void cleanCorrections(EList<UserCorrection> corrections, EList<TclSourceEntry> entries) {
        HashSet<String> values = new HashSet<String>();
        for (TclSourceEntry tclSourceEntry : entries) {
            values.add(tclSourceEntry.getValue());
        }
        Iterator i = corrections.iterator();
        while (i.hasNext()) {
            UserCorrection userCorrection = (UserCorrection)i.next();
            if (values.contains(userCorrection.getOriginalValue())) continue;
            i.remove();
        }
    }

    private void checkSources(IEnvironment environment, ModuleInfo moduleInfo) {
        IPath moduleLocation = moduleInfo.moduleLocation;
        if (moduleLocation == null) {
            return;
        }
        IPath folder = moduleLocation.removeLastSegments(1);
        EList corrections = moduleInfo.moduleInfo.getSourceCorrections();
        for (TclSourceEntry source : moduleInfo.moduleInfo.getSourced()) {
            String value = source.getValue();
            HashSet<IPath> sourcedPaths = new HashSet<IPath>();
            Iterator i = corrections.iterator();
            while (i.hasNext()) {
                UserCorrection userCorrection = (UserCorrection)i.next();
                if (userCorrection.isVariable() || !userCorrection.getOriginalValue().equals(value)) continue;
                for (String userValue : userCorrection.getUserValue()) {
                    IPath sourcedPath = PackageRequireSourceAnalyser.toPath(environment, userValue);
                    if (sourcedPaths.add(sourcedPath)) continue;
                    i.remove();
                }
            }
            boolean autoCorrected = false;
            if (sourcedPaths.isEmpty()) {
                IPath sourcedPath = this.resolvePath(environment, folder, value);
                if (sourcedPath != null) {
                    autoCorrected = true;
                    sourcedPaths.add(sourcedPath);
                } else {
                    PackageRequireSourceAnalyser.setAutoCorrection((EList<UserCorrection>)corrections, value, null);
                }
            } else {
                PackageRequireSourceAnalyser.setAutoCorrection((EList<UserCorrection>)corrections, value, null);
            }
            for (IPath sourcedPath : sourcedPaths) {
                IFileHandle file = environment.getFile(sourcedPath);
                if (!file.exists()) {
                    this.reportSourceProblemCorrection(source, moduleInfo.reporter, NLS.bind((String)Messages.PackageRequireSourceAnalyser_CouldNotLocateSourcedFile, (Object)file.toOSString()), value, moduleInfo.lineTracker);
                    continue;
                }
                if (file.isDirectory()) {
                    this.reportSourceProblemCorrection(source, moduleInfo.reporter, Messages.PackageRequireSourceAnalyser_FolderSourcingNotSupported, value, moduleInfo.lineTracker);
                    continue;
                }
                if (!this.isAutoAddPackages()) {
                    this.reportSourceProblem(source, moduleInfo.reporter, Messages.PackageRequireSourceAnalyser_SourceNotAddedToBuildpath, value, moduleInfo.lineTracker);
                    continue;
                }
                if (!autoCorrected || this.buildType == 10) continue;
                PackageRequireSourceAnalyser.setAutoCorrection((EList<UserCorrection>)corrections, value, file.toString());
            }
            if (!sourcedPaths.isEmpty() || TclPackagesManager.isValidName((String)value)) continue;
            this.reportSourceProblemCorrection(source, moduleInfo.reporter, NLS.bind((String)Messages.PackageRequireSourceAnalyser_CouldNotLocateSourcedFileCorrectionRequired, (Object)value), value, moduleInfo.lineTracker);
        }
    }

    private static void setAutoCorrection(EList<UserCorrection> corrections, String src, String value) {
        Iterator i = corrections.iterator();
        while (i.hasNext()) {
            UserCorrection userCorrection = (UserCorrection)i.next();
            if (!userCorrection.isVariable() || !userCorrection.getOriginalValue().equals(src)) continue;
            if (value == null) {
                i.remove();
                continue;
            }
            if (userCorrection.getUserValue().size() != 1 || !((String)userCorrection.getUserValue().get(0)).equals(value)) continue;
            value = null;
        }
        if (value != null) {
            UserCorrection correction = TclPackagesFactory.eINSTANCE.createUserCorrection();
            correction.setVariable(true);
            correction.setOriginalValue(src);
            correction.getUserValue().add((Object)value);
            corrections.add((Object)correction);
        }
    }

    private IPath resolvePath(IEnvironment environment, IPath folder, String value) {
        String resolved = this.variableResolver.resolve(value);
        if (resolved != null) {
            return this.resolveSourceValue(folder, resolved, environment);
        }
        return null;
    }

    private IPath resolveSourceValue(IPath folder, String value, IEnvironment environment) {
        IPath valuePath;
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((valuePath = PackageRequireSourceAnalyser.toPath(environment, value)).isAbsolute()) {
            return valuePath;
        }
        if (TclPackagesManager.isValidName((String)value)) {
            return folder.append(valuePath);
        }
        return null;
    }

    private static IPath toPath(IEnvironment environment, String path) {
        if (environment.isLocal()) {
            return Path.fromOSString((String)path);
        }
        return new Path(path.replace('\\', '/'));
    }

    private void reportPackageProblem(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        if (reporter == null) {
            return;
        }
        reporter.reportProblem((IProblem)new DefaultProblem(message, (IProblemIdentifier)TclProblems.UNKNOWN_REQUIRED_PACKAGE, new String[]{pkgName}, ProblemSeverities.Warning, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportPackageProblemCorrection(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        if (reporter == null) {
            return;
        }
        reporter.reportProblem((IProblem)new DefaultProblem(message, (IProblemIdentifier)TclProblems.UNKNOWN_REQUIRED_PACKAGE_CORRECTION, new String[]{pkgName}, ProblemSeverities.Warning, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportSourceProblem(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        if (reporter == null) {
            return;
        }
        reporter.reportProblem((IProblem)new DefaultProblem(message, (IProblemIdentifier)TclProblems.UNKNOWN_SOURCE, new String[]{pkgName}, ProblemSeverities.Warning, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void reportSourceProblemCorrection(TclSourceEntry pkg, IProblemReporter reporter, String message, String pkgName, ISourceLineTracker lineTracker) {
        reporter.reportProblem((IProblem)new DefaultProblem(message, (IProblemIdentifier)TclProblems.UNKNOWN_SOURCE_CORRECTION, new String[]{pkgName}, ProblemSeverities.Warning, pkg.getStart(), pkg.getEnd(), lineTracker.getLineNumberOfOffset(pkg.getStart())));
    }

    private void checkPackage(TclSourceEntry pkg, IProblemReporter reporter, ISourceLineTracker lineTracker, Set<String> newDependencies, Set<String> names, Set<String> autoNames) {
        String packageName = pkg.getValue();
        List collected = (List)this.packageCollector.getModules().get(this.project);
        if (collected != null && this.isProvided(packageName, collected)) {
            return;
        }
        if (this.providedByRequiredProjects != null && this.isProvided(packageName, this.providedByRequiredProjects)) {
            return;
        }
        if (!this.isKnownPackage(packageName)) {
            if (!TclPackagesManager.isValidName((String)packageName)) {
                this.reportPackageProblemCorrection(pkg, reporter, NLS.bind((String)Messages.PackageRequireSourceAnalyser_CouldNotDetectPackageCorrectionRequired, (Object)packageName), packageName, lineTracker);
                return;
            }
            this.reportPackageProblem(pkg, reporter, NLS.bind((String)Messages.TclCheckBuilder_unknownPackage, (Object)packageName), packageName, lineTracker);
            return;
        }
        if (!this.isAutoAddPackages()) {
            if (!names.contains(packageName) && !autoNames.contains(packageName)) {
                this.reportPackageProblem(pkg, reporter, NLS.bind((String)Messages.TclCheckBuilder_unresolvedDependencies, (Object)packageName), packageName, lineTracker);
            }
            return;
        }
        newDependencies.add(packageName);
    }

    private boolean isProvided(String packageName, Collection<TclModuleInfo> infos) {
        for (TclModuleInfo tclModuleInfo : infos) {
            EList provided = tclModuleInfo.getProvided();
            for (TclSourceEntry tclSourceEntry : provided) {
                IModelElement element;
                if (!tclSourceEntry.getValue().equals(packageName) || (element = DLTKCore.create((String)tclModuleInfo.getHandle())) == null || !element.exists()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isKnownPackage(String packageName) {
        for (TclPackageInfo info : this.knownInfos) {
            if (!info.getName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAutoAddPackages() {
        return this.autoAddPackages;
    }

    public void prepare(IBuildChange buildChange, IBuildState buildState) {
    }

    public void clean() {
        TclPackagesManager.setProjectModules((String)this.project.getElementName(), Collections.emptyList());
        InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)this.project, Collections.emptySet(), Collections.emptySet());
    }

    private static class ModuleInfo {
        final String name;
        final ISourceLineTracker lineTracker;
        final TclModuleInfo moduleInfo;
        final IProblemReporter reporter;
        final IPath moduleLocation;
        final ISourceModule sourceModule;

        public ModuleInfo(String moduleName, ISourceLineTracker codeModel, IProblemReporter reporter, TclModuleInfo moduleInfo, IPath moduleLocation, ISourceModule sourceModule) {
            this.name = moduleName;
            this.lineTracker = codeModel;
            this.reporter = reporter;
            this.moduleInfo = moduleInfo;
            this.moduleLocation = moduleLocation;
            this.sourceModule = sourceModule;
        }
    }
}

