/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class FinallyClause
extends JSNode {
    private Keyword finallyKeyword;
    private Statement statement;

    public FinallyClause(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.finallyKeyword != null) {
                this.finallyKeyword.traverse(visitor);
            }
            if (this.statement != null) {
                this.statement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Keyword getFinallyKeyword() {
        return this.finallyKeyword;
    }

    public void setFinallyKeyword(Keyword keyword) {
        this.finallyKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("finally");
        buffer.append("\n");
        buffer.append(this.statement.toSourceString(indentationString));
        return buffer.toString();
    }
}

