/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.ISourceableBlock;
import org.eclipse.dltk.javascript.ast.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementBlock
extends Statement
implements ISourceableBlock {
    private final List<Statement> statements = new ArrayList<Statement>();
    private int LC = -1;
    private int RC = -1;

    public StatementBlock(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            for (Statement node : this.statements) {
                node.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public int getLC() {
        return this.LC;
    }

    public void setLC(int LC) {
        this.LC = LC;
    }

    public int getRC() {
        return this.RC;
    }

    public void setRC(int RC) {
        this.RC = RC;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LC >= 0 && this.RC > 0 || this.RC == -1 && this.LC == -1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("{\n");
        int i = 0;
        while (i < this.statements.size()) {
            buffer.append(((ISourceable)this.statements.get(i)).toSourceString(String.valueOf(indentationString) + "    "));
            ++i;
        }
        buffer.append(indentationString);
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public boolean isBlock() {
        return true;
    }
}

