/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.internal.launching.CompositeId;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.DefaultEntryResolver;
import org.eclipse.dltk.internal.launching.DefaultProjectBuildpathEntry;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.internal.launching.InterpreterListener;
import org.eclipse.dltk.internal.launching.ListenerList;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntryResolver;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathProvider;
import org.eclipse.dltk.internal.launching.ScriptSourceLookupUtil;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry2;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver2;
import org.eclipse.dltk.launching.IRuntimeBuildpathProvider;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptLaunchConfigurationConstants;
import org.eclipse.dltk.launching.StandardBuildpathProvider;
import org.eclipse.dltk.launching.StandardSourcepathProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptRuntime {
    public static final String INTERPRETER_CONTAINER = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".INTERPRETER_CONTAINER";
    public static final String EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRY_RESOLVERS = "runtimeBuildpathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_BUILDPATH_PROVIDERS = "buildpathProviders";
    public static final String EXTENSION_POINT_INTERPRETER_INSTALLS = "interpreterInstalls";
    public static final int ERR_UNABLE_TO_RESOLVE_INTERPRETER = 160;
    public static final String PREF_CONNECT_TIMEOUT = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".PREF_CONNECT_TIMEOUT";
    public static final String PREF_INTERPRETER_XML = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".PREF_INTERPRETER_XML";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    public static final String BUILDPATH_ATTR_LIBRARY_PATH_ENTRY = String.valueOf(DLTKLaunchingPlugin.getUniqueIdentifier()) + ".CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private static Object fgInterpreterLock = new Object();
    private static boolean fgInitializingInterpreters = false;
    private static IInterpreterInstallType[] fgInterpreterTypes = null;
    private static Map<DefaultInterpreterEntry, String> fgDefaultInterpreterId = new HashMap<DefaultInterpreterEntry, String>();
    private static Map<DefaultInterpreterEntry, String> fgDefaultInterpreterConnectorId = new HashMap<DefaultInterpreterEntry, String>();
    private static Map<String, IRuntimeBuildpathEntryResolver> fgContainerResolvers = null;
    private static Map<String, IRuntimeBuildpathEntryResolver> fgRuntimeBuildpathEntryResolvers = null;
    private static Map<String, IRuntimeBuildpathProvider> fgPathProviders = null;
    private static IRuntimeBuildpathProvider fgDefaultBuildpathProvider = new StandardBuildpathProvider();
    private static IRuntimeBuildpathProvider fgDefaultSourcepathProvider = new StandardSourcepathProvider();
    private static ListenerList fgInterpreterListeners = new ListenerList(5);
    private static ThreadLocal<List<IScriptProject>> fgProjects = new ThreadLocal();
    private static ThreadLocal<Integer> fgEntryCount = new ThreadLocal();
    private static Set<String> fgContributedInterpreters = new HashSet<String>();

    private ScriptRuntime() {
    }

    private static void initializeInterpreterTypeExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", "interpreterInstallTypes");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(DLTKLaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.ScriptRuntime_exceptionsOccurred, null);
        fgInterpreterTypes = new IInterpreterInstallType[configs.length];
        int i = 0;
        while (i < configs.length) {
            try {
                IInterpreterInstallType installType;
                ScriptRuntime.fgInterpreterTypes[i] = installType = (IInterpreterInstallType)configs[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            DLTKLaunchingPlugin.log((IStatus)status);
            ArrayList<IInterpreterInstallType> temp = new ArrayList<IInterpreterInstallType>(fgInterpreterTypes.length);
            int i2 = 0;
            while (i2 < fgInterpreterTypes.length) {
                if (fgInterpreterTypes[i2] != null) {
                    temp.add(fgInterpreterTypes[i2]);
                }
                fgInterpreterTypes = temp.toArray(new IInterpreterInstallType[temp.size()]);
                ++i2;
            }
        }
    }

    private static String getNatureFromProject(IScriptProject project) {
        try {
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
            if (toolkit != null) {
                return toolkit.getNatureId();
            }
        }
        catch (Exception e) {
            DLTKLaunchingPlugin.log(e);
        }
        return null;
    }

    private static String getEnvironmentFromProject(IScriptProject project) {
        return EnvironmentManager.getEnvironmentId((IProject)project.getProject());
    }

    public static IInterpreterInstall getInterpreterInstall(IScriptProject project) throws CoreException {
        IInterpreterInstall interpreter = null;
        IBuildpathEntry[] buildpath = project.getRawBuildpath();
        int i = 0;
        while (i < buildpath.length) {
            IBuildpathEntry entry = buildpath[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    interpreter = resolver.resolveInterpreterInstall(ScriptRuntime.getNatureFromProject(project), ScriptRuntime.getEnvironmentFromProject(project), entry);
                }
            }
            if (interpreter != null) {
                return interpreter;
            }
            ++i;
        }
        return null;
    }

    public static IInterpreterInstallType getInterpreterInstallType(String id) {
        IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes();
        if (installTypes == null) {
            return null;
        }
        int i = 0;
        while (i < installTypes.length) {
            IInterpreterInstallType type = installTypes[i];
            if (type != null && type.getId().equals(id)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultInterpreterInstall(IInterpreterInstall interpreter, IProgressMonitor monitor) throws CoreException {
        ScriptRuntime.setDefaultInterpreterInstall(interpreter, monitor, true);
    }

    public static void setDefaultInterpreterInstall(IInterpreterInstall interpreter, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IEnvironment env = interpreter.getEnvironment();
        if (env == null) {
            return;
        }
        String environmentId = env.getId();
        IInterpreterInstall previous = null;
        String nature = interpreter.getInterpreterInstallType().getNatureId();
        DefaultInterpreterEntry defaultInterpreterID = new DefaultInterpreterEntry(nature, environmentId);
        if (fgDefaultInterpreterId.get(defaultInterpreterID) != null) {
            previous = ScriptRuntime.getInterpreterFromCompositeId(fgDefaultInterpreterId.get(defaultInterpreterID));
        }
        fgDefaultInterpreterId.put(defaultInterpreterID, ScriptRuntime.getCompositeIdFromInterpreter(interpreter));
        if (savePreference) {
            ScriptRuntime.saveInterpreterConfiguration();
        }
        IInterpreterInstall current = null;
        if (fgDefaultInterpreterId.get(defaultInterpreterID) != null) {
            current = ScriptRuntime.getInterpreterFromCompositeId(fgDefaultInterpreterId.get(defaultInterpreterID));
        }
        if (previous != current) {
            ScriptRuntime.notifyDefaultInterpreterChanged(previous, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IInterpreterInstall getDefaultInterpreterInstall(DefaultInterpreterEntry entry) {
        IInterpreterInstall install = ScriptRuntime.getInterpreterFromCompositeId(ScriptRuntime.getDefaultInterpreterId(entry));
        if (install != null && install.getInstallLocation().exists()) {
            return install;
        }
        if (!ScriptRuntime.hasInterpreterInstalls(entry.getNature(), entry.getEnvironment())) {
            return null;
        }
        Object object = fgInterpreterLock;
        synchronized (object) {
            fgDefaultInterpreterId.clear();
            fgInterpreterTypes = null;
            ScriptRuntime.initializeInterpreters();
        }
        return ScriptRuntime.getInterpreterFromCompositeId(ScriptRuntime.getDefaultInterpreterId(entry));
    }

    private static boolean hasInterpreterInstalls(String natureId, String environmentId) {
        if (environmentId == null) {
            return false;
        }
        IInterpreterInstallType[] iInterpreterInstallTypeArray = ScriptRuntime.getInterpreterInstallTypes(natureId);
        int n = iInterpreterInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInstallType type = iInterpreterInstallTypeArray[n2];
            IInterpreterInstall[] iInterpreterInstallArray = type.getInterpreterInstalls();
            int n3 = iInterpreterInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IInterpreterInstall install = iInterpreterInstallArray[n4];
                if (environmentId.equals(install.getEnvironmentId())) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static IInterpreterInstallType[] getInterpreterInstallTypes() {
        ScriptRuntime.initializeInterpreters();
        return fgInterpreterTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IInterpreterInstallType[] getInterpreterInstallTypes(String nature) {
        ArrayList<IInterpreterInstallType> res = new ArrayList<IInterpreterInstallType>();
        Object object = fgInterpreterLock;
        synchronized (object) {
            ScriptRuntime.initializeInterpreters();
            int i = 0;
            while (i < fgInterpreterTypes.length) {
                IInterpreterInstallType t = fgInterpreterTypes[i];
                if (t.getNatureId().equals(nature)) {
                    res.add(t);
                }
                ++i;
            }
        }
        return res.toArray(new IInterpreterInstallType[res.size()]);
    }

    public static DefaultInterpreterEntry[] getDefaultInterpreterIDs() {
        Set<DefaultInterpreterEntry> set = fgDefaultInterpreterId.keySet();
        return set.toArray(new DefaultInterpreterEntry[set.size()]);
    }

    private static String getDefaultInterpreterId(DefaultInterpreterEntry entry) {
        ScriptRuntime.initializeInterpreters();
        return fgDefaultInterpreterId.get(entry);
    }

    private static String getDefaultInterpreterConnectorId(DefaultInterpreterEntry entry) {
        ScriptRuntime.initializeInterpreters();
        return fgDefaultInterpreterConnectorId.get(entry);
    }

    public static String getCompositeIdFromInterpreter(IInterpreterInstall Interpreter) {
        if (Interpreter == null) {
            return null;
        }
        IInterpreterInstallType InterpreterType = Interpreter.getInterpreterInstallType();
        String typeID = InterpreterType.getId();
        CompositeId id = new CompositeId(new String[]{typeID, Interpreter.getId()});
        return id.toString();
    }

    public static IInterpreterInstall getInterpreterFromCompositeId(String idString) {
        IInterpreterInstallType InterpreterType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (InterpreterType = ScriptRuntime.getInterpreterInstallType(id.get(0))) != null) {
            return InterpreterType.findInterpreterInstall(id.get(1));
        }
        return null;
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IScriptProject scriptProject = ScriptRuntime.getScriptModel().getScriptProject(projectName);
        if (scriptProject != null && scriptProject.getProject().exists() && !scriptProject.getProject().isOpen()) {
            ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_28, (Object[])new String[]{configuration.getName(), projectName}), 101, null);
        }
        if (scriptProject == null || !scriptProject.exists()) {
            ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Launch_configuration__0__references_non_existing_project__1___1, (Object[])new String[]{configuration.getName(), projectName}), 102, null);
        }
        return scriptProject;
    }

    private static IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static IInterpreterInstall computeInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        DefaultInterpreterEntry entry;
        IInterpreterInstall res;
        String nature = configuration.getAttribute("nature", null);
        String containerPath = configuration.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        IScriptProject proj = ScriptRuntime.getScriptProject(configuration);
        String environment = ScriptRuntime.getEnvironmentFromProject(proj);
        if (containerPath == null) {
            if (proj != null) {
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall(proj);
                if (install != null) {
                    return install;
                }
                if (nature == null) {
                    IDLTKLanguageToolkit tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)proj);
                    nature = tk.getNatureId();
                }
            }
        } else {
            IPath interpreterPath = Path.fromPortableString((String)containerPath);
            IBuildpathEntry entry2 = DLTKCore.newContainerEntry((IPath)interpreterPath);
            IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(interpreterPath.segment(0));
            if (resolver != null) {
                return resolver.resolveInterpreterInstall(nature, environment, entry2);
            }
            resolver = ScriptRuntime.getContainerResolver(interpreterPath.segment(0));
            if (resolver != null) {
                return resolver.resolveInterpreterInstall(nature, environment, entry2);
            }
        }
        if (nature == null) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_notDefaultInterpreter, 167, null);
        }
        if ((res = ScriptRuntime.getDefaultInterpreterInstall(entry = new DefaultInterpreterEntry(nature, environment))) == null) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_notDefaultInterpreter, 167, null);
        }
        return res;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        ScriptRuntime.abort(message, 100, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", code, message, exception));
    }

    public static void saveInterpreterConfiguration() throws CoreException {
        if (fgInterpreterTypes == null) {
            return;
        }
        try {
            String xml = ScriptRuntime.getInterpretersAsXML();
            ScriptRuntime.getPreferences().setValue(PREF_INTERPRETER_XML, xml);
            ScriptRuntime.savePreferences();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 4, LaunchingMessages.ScriptRuntime_exceptionsOccurred, (Throwable)e));
        }
    }

    private static String getInterpretersAsXML() throws IOException, ParserConfigurationException, TransformerException {
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        DefaultInterpreterEntry[] entries = ScriptRuntime.getDefaultInterpreterIDs();
        int i = 0;
        while (i < entries.length) {
            String id = ScriptRuntime.getDefaultInterpreterId(entries[i]);
            if (id != null) {
                container.setDefaultInterpreterInstallCompositeID(entries[i], id);
            }
            if ((id = ScriptRuntime.getDefaultInterpreterConnectorId(entries[i])) != null) {
                container.setDefaultInterpreterInstallConnectorTypeID(entries[i], id);
            }
            ++i;
        }
        IInterpreterInstallType[] InterpreterTypes = ScriptRuntime.getInterpreterInstallTypes();
        int i2 = 0;
        while (i2 < InterpreterTypes.length) {
            IInterpreterInstall[] Interpreters = InterpreterTypes[i2].getInterpreterInstalls();
            int j = 0;
            while (j < Interpreters.length) {
                IInterpreterInstall install = Interpreters[j];
                container.addInterpreter(install);
                ++j;
            }
            ++i2;
        }
        return container.getAsXML();
    }

    private static boolean addPersistedInterpreters(InterpreterDefinitionsContainer interpreterDefs) {
        String interpreterXMLString = ScriptRuntime.getPreferences().getString(PREF_INTERPRETER_XML);
        if (interpreterXMLString.length() > 0) {
            try {
                StringReader inputStream = new StringReader(interpreterXMLString);
                InterpreterDefinitionsContainer.parseXMLIntoContainer(inputStream, interpreterDefs);
                return false;
            }
            catch (IOException ioe) {
                DLTKLaunchingPlugin.log(ioe);
            }
        }
        return true;
    }

    private static String substitute(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
    }

    public static boolean isContributedInterpreterInstall(String id) {
        ScriptRuntime.getInterpreterInstallTypes();
        return fgContributedInterpreters.contains(id);
    }

    public static LibraryLocation[] getLibraryLocations(IInterpreterInstall interperterInstall) {
        return ScriptRuntime.getLibraryLocations(interperterInstall, null);
    }

    public static LibraryLocation[] getLibraryLocations(IInterpreterInstall interperterInstall, IProgressMonitor monitor) {
        LibraryLocation[] locations = interperterInstall.getLibraryLocations();
        if (locations != null) {
            return locations;
        }
        LibraryLocation[] defaultLocations = interperterInstall.getInterpreterInstallType().getDefaultLibraryLocations(interperterInstall.getInstallLocation(), interperterInstall.getEnvironmentVariables(), monitor);
        ArrayList<LibraryLocation> existingDefaultLocations = new ArrayList<LibraryLocation>();
        int i = 0;
        while (i < defaultLocations.length) {
            LibraryLocation location = defaultLocations[i];
            IFileHandle file = EnvironmentPathUtils.getFile((IPath)location.getLibraryPath());
            if (file.exists()) {
                existingDefaultLocations.add(location);
            }
            ++i;
        }
        return existingDefaultLocations.toArray(new LibraryLocation[existingDefaultLocations.size()]);
    }

    public static IBuildpathEntry getDefaultInterpreterContainerEntry() {
        return DLTKCore.newContainerEntry((IPath)ScriptRuntime.newDefaultInterpreterContainerPath());
    }

    public static IPath newDefaultInterpreterContainerPath() {
        return new Path(INTERPRETER_CONTAINER);
    }

    public static IPath newInterpreterContainerPath(IInterpreterInstall interpreter) {
        if (interpreter != null) {
            String name = interpreter.getName();
            String typeId = interpreter.getInterpreterInstallType().getId();
            return ScriptRuntime.newInterpreterContainerPath(typeId, name);
        }
        return null;
    }

    public static IPath newInterpreterContainerPath(String typeId, String name) {
        if (typeId == null || name == null) {
            return null;
        }
        IPath path = ScriptRuntime.newDefaultInterpreterContainerPath();
        path = path.append(typeId);
        path = path.append(name.replaceAll("/", "%2F"));
        return path;
    }

    public static IInterpreterInstall getInterpreterInstall(String nature, String environment, IPath InterpreterEnvironmentContainerPath) {
        try {
            return InterpreterContainerInitializer.resolveInterpreter(nature, environment, InterpreterEnvironmentContainerPath);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IInterpreterInstall getInterpreterInstall(String compositeId, String natureId) {
        IInterpreterInstall install = ScriptRuntime.getInterpreterFromCompositeId(compositeId);
        if (install == null) {
            DefaultInterpreterEntry entry = new DefaultInterpreterEntry(natureId, "org.eclipse.dltk.core.environment.localEnvironment");
            install = ScriptRuntime.getDefaultInterpreterInstall(entry);
        }
        return install;
    }

    public static String getInterpreterInstallTypeId(IPath InterpreterEnvironmentContainerPath) {
        return InterpreterContainerInitializer.getInterpreterTypeId(InterpreterEnvironmentContainerPath);
    }

    public static String getInterpreterInstallName(IPath InterpreterEnvironmentContainerPath) {
        return InterpreterContainerInitializer.getInterpreterName(InterpreterEnvironmentContainerPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRuntimeBuildpathEntry computeInterpreterEntry(ILaunchConfiguration configuration) throws CoreException {
        String containerAttr = configuration.getAttribute(ScriptLaunchConfigurationConstants.ATTR_CONTAINER_PATH, null);
        IPath containerPath = null;
        if (containerAttr == null) {
            IScriptProject proj = ScriptRuntime.getScriptProject(configuration);
            if (proj != null) return ScriptRuntime.computeInterpreterEntry(proj);
            containerPath = ScriptRuntime.newDefaultInterpreterContainerPath();
        } else {
            containerPath = Path.fromPortableString((String)containerAttr);
        }
        if (containerPath == null) return null;
        return ScriptRuntime.newRuntimeContainerBuildpathEntry(containerPath, 1);
    }

    public static IRuntimeBuildpathEntry computeInterpreterEntry(IScriptProject project) throws CoreException {
        IBuildpathEntry[] rawBuildpath = project.getRawBuildpath();
        IRuntimeBuildpathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawBuildpath.length) {
            IBuildpathEntry entry = rawBuildpath[i];
            block0 : switch (entry.getEntryKind()) {
                case 5: {
                    IBuildpathContainer container;
                    resolver = ScriptRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isInterpreterInstallReference(ScriptRuntime.getNatureFromProject(project), ScriptRuntime.getEnvironmentFromProject(project), entry) || (container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return ScriptRuntime.newRuntimeContainerBuildpathEntry(entry.getPath(), 1);
                        }
                        case 2: {
                            return ScriptRuntime.newRuntimeContainerBuildpathEntry(entry.getPath(), 2);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isInterpreterInstallReference(String lang, String environment, IRuntimeBuildpathEntry entry) {
        IBuildpathEntry buildpathEntry = entry.getBuildpathEntry();
        if (buildpathEntry != null) {
            switch (buildpathEntry.getEntryKind()) {
                case 5: {
                    IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(buildpathEntry.getPath().segment(0));
                    if (resolver == null) break;
                    return resolver.isInterpreterInstallReference(lang, environment, buildpathEntry);
                }
            }
        }
        return false;
    }

    public static void addInterpreterInstallChangedListener(IInterpreterInstallChangedListener listener) {
        fgInterpreterListeners.add(listener);
    }

    public static void removeInterpreterInstallChangedListener(IInterpreterInstallChangedListener listener) {
        fgInterpreterListeners.remove(listener);
    }

    private static void notifyDefaultInterpreterChanged(IInterpreterInstall previous, IInterpreterInstall current) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.defaultInterpreterInstallChanged(previous, current);
            ++i;
        }
    }

    public static void fireInterpreterChanged(PropertyChangeEvent event) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.interpreterChanged(event);
            ++i;
        }
    }

    public static void fireInterpreterAdded(IInterpreterInstall Interpreter) {
        if (!fgInitializingInterpreters) {
            Object[] listeners = fgInterpreterListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
                listener.interpreterAdded(Interpreter);
                ++i;
            }
        }
    }

    public static void fireInterpreterRemoved(IInterpreterInstall Interpreter) {
        Object[] listeners = fgInterpreterListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IInterpreterInstallChangedListener listener = (IInterpreterInstallChangedListener)listeners[i];
            listener.interpreterRemoved(Interpreter);
            ++i;
        }
    }

    public static Preferences getPreferences() {
        return DLTKLaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        DLTKLaunchingPlugin.getDefault().savePluginPreferences();
    }

    public static void addContainerResolver(IRuntimeBuildpathEntryResolver resolver, String containerIdentifier) {
        Map<String, IRuntimeBuildpathEntryResolver> map = ScriptRuntime.getContainerResolvers();
        map.put(containerIdentifier, resolver);
    }

    private static Map<String, IRuntimeBuildpathEntryResolver> getContainerResolvers() {
        if (fgContainerResolvers == null) {
            ScriptRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static void initializeResolvers() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_RUNTIME_BUILDPATH_ENTRY_RESOLVERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgContainerResolvers = new HashMap<String, IRuntimeBuildpathEntryResolver>(extensions.length);
        fgRuntimeBuildpathEntryResolvers = new HashMap<String, IRuntimeBuildpathEntryResolver>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeBuildpathEntryResolver res = new RuntimeBuildpathEntryResolver(extensions[i]);
            String container = res.getContainerId();
            String entryId = res.getRuntimeBuildpathEntryId();
            if (container != null) {
                fgContainerResolvers.put(container, res);
            }
            if (entryId != null) {
                fgRuntimeBuildpathEntryResolvers.put(entryId, res);
            }
            ++i;
        }
    }

    private static Map<String, IRuntimeBuildpathProvider> getBuildpathProviders() {
        if (fgPathProviders == null) {
            ScriptRuntime.initializeProviders();
        }
        return fgPathProviders;
    }

    private static void initializeProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_RUNTIME_BUILDPATH_PROVIDERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgPathProviders = new HashMap<String, IRuntimeBuildpathProvider>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeBuildpathProvider res = new RuntimeBuildpathProvider(extensions[i]);
            fgPathProviders.put(res.getIdentifier(), res);
            ++i;
        }
    }

    private static IRuntimeBuildpathEntryResolver2 getContainerResolver(String containerId) {
        return (IRuntimeBuildpathEntryResolver2)ScriptRuntime.getContainerResolvers().get(containerId);
    }

    public static String[] computeScriptLibraryPath(IScriptProject project, boolean requiredProjects) throws CoreException {
        HashSet<IScriptProject> visited = new HashSet<IScriptProject>();
        ArrayList<String> entries = new ArrayList<String>();
        ScriptRuntime.gatherScriptLibraryPathEntries(project, requiredProjects, visited, entries);
        ArrayList<String> resolved = new ArrayList<String>(entries.size());
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String entry : entries) {
            IPath location;
            String resolvedEntry = manager.performStringSubstitution(entry);
            Path path = new Path(resolvedEntry);
            if (path.isAbsolute()) {
                File file = path.toFile();
                resolved.add(file.getAbsolutePath());
                continue;
            }
            IResource resource = root.findMember((IPath)path);
            if (resource == null || (location = resource.getLocation()) == null) continue;
            resolved.add(location.toFile().getAbsolutePath());
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    private static void gatherScriptLibraryPathEntries(IScriptProject project, boolean requiredProjects, Set<IScriptProject> visited, List<String> entries) throws CoreException {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IBuildpathEntry[] rawBuildpath = project.getRawBuildpath();
        IBuildpathEntry[] required = ScriptRuntime.processScriptLibraryPathEntries(project, requiredProjects, rawBuildpath, entries);
        if (required != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < required.length) {
                IScriptProject requiredProject;
                IBuildpathEntry entry = required[i];
                String projectName = entry.getPath().segment(0);
                IProject p = root.getProject(projectName);
                if (p.exists() && (requiredProject = DLTKCore.create((IProject)p)) != null) {
                    ScriptRuntime.gatherScriptLibraryPathEntries(requiredProject, requiredProjects, visited, entries);
                }
                ++i;
            }
        }
    }

    private static IBuildpathEntry[] processScriptLibraryPathEntries(IScriptProject project, boolean collectRequired, IBuildpathEntry[] buildpathEntries, List<String> entries) throws CoreException {
        ArrayList<IBuildpathEntry> req = null;
        int i = 0;
        while (i < buildpathEntries.length) {
            IBuildpathEntry entry = buildpathEntries[i];
            IBuildpathAttribute[] extraAttributes = entry.getExtraAttributes();
            int j = 0;
            while (j < extraAttributes.length) {
                String[] paths = ScriptRuntime.getLibraryPaths(extraAttributes[j]);
                if (paths != null) {
                    int k = 0;
                    while (k < paths.length) {
                        entries.add(paths[k]);
                        ++k;
                    }
                }
                ++j;
            }
            if (entry.getEntryKind() == 5) {
                IBuildpathEntry[] requiredProjects;
                IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
                if (container != null && (requiredProjects = ScriptRuntime.processScriptLibraryPathEntries(project, collectRequired, container.getBuildpathEntries(), entries)) != null) {
                    if (req == null) {
                        req = new ArrayList();
                    }
                    int j2 = 0;
                    while (j2 < requiredProjects.length) {
                        req.add(requiredProjects[j2]);
                        ++j2;
                    }
                }
            } else if (collectRequired && entry.getEntryKind() == 2) {
                if (req == null) {
                    req = new ArrayList<IBuildpathEntry>();
                }
                req.add(entry);
            }
            ++i;
        }
        if (req != null) {
            return req.toArray(new IBuildpathEntry[req.size()]);
        }
        return null;
    }

    public static IBuildpathAttribute newLibraryPathsAttribute(String[] paths) {
        StringBuffer value = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            value.append(paths[i]);
            if (i < paths.length - 1) {
                value.append("|");
            }
            ++i;
        }
        return DLTKCore.newBuildpathAttribute((String)BUILDPATH_ATTR_LIBRARY_PATH_ENTRY, (String)value.toString());
    }

    public static String[] getLibraryPaths(IBuildpathAttribute attribute) {
        if (BUILDPATH_ATTR_LIBRARY_PATH_ENTRY.equals(attribute.getName())) {
            String value = attribute.getValue();
            return value.split("\\|");
        }
        return null;
    }

    private static void addInterpreterExtensions(InterpreterDefinitionsContainer InterpreterDefs) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.launching", EXTENSION_POINT_INTERPRETER_INSTALLS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement element = configs[i];
            try {
                if ("interpreterInstall".equals(element.getName())) {
                    IInterpreterInstall install;
                    IInterpreterInstallType installType;
                    String id;
                    String InterpreterType = element.getAttribute("interpreterInstallType");
                    if (InterpreterType == null) {
                        ScriptRuntime.abort(MessageFormat.format((String)"Missing required interpreterInstallType attribute for interpreterInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                    }
                    if ((id = element.getAttribute("id")) == null) {
                        ScriptRuntime.abort(MessageFormat.format((String)"Missing required id attribute for interpreterInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                    }
                    if ((installType = ScriptRuntime.getInterpreterInstallType(InterpreterType)) == null) {
                        ScriptRuntime.abort(MessageFormat.format((String)"InterpreterInstall {0} contributed by {1} references undefined Interpreter install type {2}", (Object[])new String[]{id, element.getContributor().getName(), InterpreterType}), null);
                    }
                    if ((install = installType.findInterpreterInstall(id)) == null) {
                        IStatus status;
                        String home;
                        String name = element.getAttribute("name");
                        if (name == null) {
                            ScriptRuntime.abort(MessageFormat.format((String)"interpreterInstall {0} contributed by {1} missing required attribute name", (Object[])new String[]{id, element.getContributor().getName()}), null);
                        }
                        if ((home = element.getAttribute("home")) == null) {
                            ScriptRuntime.abort(MessageFormat.format((String)"interpreterInstall {0} contributed by {1} missing required attribute home", (Object[])new String[]{id, element.getContributor().getName()}), null);
                        }
                        String InterpreterArgs = element.getAttribute("interpreterArgs");
                        InterpreterStandin standin = new InterpreterStandin(installType, id);
                        standin.setName(name);
                        IEnvironment localEnv = EnvironmentManager.getLocalEnvironment();
                        IFileHandle homeFile = localEnv.getFile(ScriptRuntime.toPath(element, ScriptRuntime.substitute(home)));
                        if (homeFile.exists()) {
                            homeFile = localEnv.getFile((IPath)new Path(homeFile.getCanonicalPath()));
                        }
                        if (!(status = installType.validateInstallLocation(homeFile, standin.getEnvironmentVariables(), standin.getLibraryLocations(), (IProgressMonitor)new NullProgressMonitor())).isOK()) {
                            ScriptRuntime.abort(MessageFormat.format((String)"Illegal install location {0} for interpreterInstall {1} contributed by {2}: {3}", (Object[])new String[]{home, id, element.getContributor().getName(), status.getMessage()}), null);
                        }
                        standin.setInstallLocation(homeFile);
                        if (InterpreterArgs != null) {
                            standin.setInterpreterArgs(InterpreterArgs);
                        }
                        IConfigurationElement[] libraries = element.getChildren("library");
                        LibraryLocation[] locations = null;
                        if (libraries.length > 0) {
                            locations = new LibraryLocation[libraries.length];
                            int j = 0;
                            while (j < libraries.length) {
                                IConfigurationElement library = libraries[j];
                                String libPathStr = library.getAttribute("path");
                                if (libPathStr == null) {
                                    ScriptRuntime.abort(MessageFormat.format((String)"library for interpreterInstall {0} contributed by {1} missing required attribute libPath", (Object[])new String[]{id, element.getContributor().getName()}), null);
                                }
                                locations[j] = new LibraryLocation(homeFile.getFullPath().append(ScriptRuntime.substitute(libPathStr)));
                                ++j;
                            }
                        }
                        standin.setLibraryLocations(locations);
                        InterpreterDefs.addInterpreter(standin, true);
                    }
                    fgContributedInterpreters.add(id);
                } else {
                    ScriptRuntime.abort(MessageFormat.format((String)"Illegal element {0} in InterpreterInstalls extension contributed by {1}", (Object[])new String[]{element.getName(), element.getContributor().getName()}), null);
                }
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
            ++i;
        }
    }

    private static IPath toPath(IConfigurationElement element, String path) throws CoreException {
        String bundleId = element.getAttribute("bundle");
        if (bundleId != null) {
            Bundle bundle;
            if (bundleId.equals(".")) {
                bundleId = element.getContributor().getName();
            }
            if ((bundle = Platform.getBundle((String)bundleId)) != null) {
                try {
                    File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                    Path bundlePath = new Path(bundleFile.getCanonicalPath());
                    return bundlePath.append((IPath)new Path(path));
                }
                catch (IOException e) {
                    ScriptRuntime.abort(NLS.bind((String)"Error resolving {0} bundle location", (Object)bundleId), e);
                }
            }
        }
        return new Path(path);
    }

    private static InterpreterStandin detectInterpreterInstall(String natureId, List<IInterpreterInstallType> interpTypes) {
        int i = 0;
        while (i < interpTypes.size()) {
            IInterpreterInstallType interpType = interpTypes.get(i);
            IFileHandle[] detectedLocations = interpType.detectInstallLocations();
            if (detectedLocations != null && detectedLocations.length != 0) {
                long unique = System.currentTimeMillis();
                while (interpType.findInterpreterInstall(String.valueOf(unique)) != null) {
                    ++unique;
                }
                String interpID = String.valueOf(unique);
                InterpreterStandin detected = new InterpreterStandin(interpType, interpID);
                detected.setInstallLocation(detectedLocations[0]);
                detected.setName(interpType.generateDetectedInterpreterName(detected.getInstallLocation()));
                return detected;
            }
            ++i;
        }
        return null;
    }

    private static Map<String, List<IInterpreterInstallType>> getInterpreterTypesByNature() {
        HashMap<String, List<IInterpreterInstallType>> result = new HashMap<String, List<IInterpreterInstallType>>();
        IInterpreterInstallType[] iInterpreterInstallTypeArray = fgInterpreterTypes;
        int n = fgInterpreterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInstallType type = iInterpreterInstallTypeArray[n2];
            String natureId = type.getNatureId();
            if (!result.containsKey(natureId)) {
                result.put(natureId, new ArrayList());
            }
            ((List)result.get(natureId)).add(type);
            ++n2;
        }
        return result;
    }

    private static Map<String, List<IInterpreterInstall>> getValidInterpretersByNature(List<IInterpreterInstall> validInterpreters) {
        HashMap<String, List<IInterpreterInstall>> result = new HashMap<String, List<IInterpreterInstall>>();
        for (IInterpreterInstall install : validInterpreters) {
            String natureId = install.getNatureId();
            if (!result.containsKey(natureId)) {
                result.put(natureId, new ArrayList());
            }
            ((List)result.get(natureId)).add(install);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeInterpreters() {
        InterpreterDefinitionsContainer defs = null;
        boolean setPref = false;
        Object object = fgInterpreterLock;
        synchronized (object) {
            if (fgInterpreterTypes == null) {
                try {
                    fgInitializingInterpreters = true;
                    ScriptRuntime.initializeInterpreterTypeExtensions();
                    defs = new InterpreterDefinitionsContainer();
                    setPref = ScriptRuntime.addPersistedInterpreters(defs);
                    Map<String, List<IInterpreterInstallType>> typesByNature = ScriptRuntime.getInterpreterTypesByNature();
                    Map<String, List<IInterpreterInstall>> interpsByNature = ScriptRuntime.getValidInterpretersByNature(defs.getValidInterpreterList());
                    for (String natureId : typesByNature.keySet()) {
                        if (interpsByNature.containsKey(natureId) && !interpsByNature.get(natureId).isEmpty()) continue;
                        InterpreterListener listener = new InterpreterListener();
                        ScriptRuntime.addInterpreterInstallChangedListener(listener);
                        setPref = true;
                        InterpreterStandin interpreterStandin = ScriptRuntime.detectInterpreterInstall(natureId, typesByNature.get(natureId));
                        DefaultInterpreterEntry entry = null;
                        if (interpreterStandin != null) {
                            entry = new DefaultInterpreterEntry(natureId, interpreterStandin.getEnvironmentId());
                        }
                        ScriptRuntime.removeInterpreterInstallChangedListener(listener);
                        if (!listener.isChanged()) {
                            if (interpreterStandin == null) continue;
                            defs.addInterpreter(interpreterStandin);
                            defs.setDefaultInterpreterInstallCompositeID(entry, ScriptRuntime.getCompositeIdFromInterpreter(interpreterStandin));
                            continue;
                        }
                        ScriptRuntime.addPersistedInterpreters(defs);
                        if (entry == null) continue;
                        defs.setDefaultInterpreterInstallCompositeID(entry, fgDefaultInterpreterId.get(entry));
                    }
                    ScriptRuntime.addInterpreterExtensions(defs);
                    DefaultInterpreterEntry[] natures = defs.getInterpreterNatures();
                    int i = 0;
                    while (i < natures.length) {
                        boolean bl;
                        String defId = defs.getDefaultInterpreterInstallCompositeID(natures[i]);
                        boolean bl2 = false;
                        if (defId != null) {
                            for (IInterpreterInstall iterpreter : defs.getValidInterpreterList()) {
                                if (!ScriptRuntime.getCompositeIdFromInterpreter(iterpreter).equals(defId)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) {
                            setPref = true;
                            List<IInterpreterInstall> list = defs.getValidInterpreterList(natures[i]);
                            if (!list.isEmpty()) {
                                IInterpreterInstall Interpreter = list.get(0);
                                defs.setDefaultInterpreterInstallCompositeID(natures[i], ScriptRuntime.getCompositeIdFromInterpreter(Interpreter));
                            }
                        }
                        String defInstCID = defs.getDefaultInterpreterInstallCompositeID(natures[i]);
                        fgDefaultInterpreterId.put(natures[i], defInstCID);
                        String defIntCTypeID = defs.getDefaultInterpreterInstallConnectorTypeID(natures[i]);
                        fgDefaultInterpreterConnectorId.put(natures[i], defIntCTypeID);
                        ++i;
                    }
                    List<IInterpreterInstall> InterpreterList = defs.getValidInterpreterList();
                    for (InterpreterStandin interpreterStandin : InterpreterList) {
                        interpreterStandin.convertToRealInterpreter();
                    }
                }
                finally {
                    fgInitializingInterpreters = false;
                }
            }
        }
        if (defs != null) {
            IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IInterpreterInstallType type = installTypes[i];
                IInterpreterInstall[] installs = type.getInterpreterInstalls();
                if (installs != null) {
                    int j = 0;
                    while (j < installs.length) {
                        ScriptRuntime.fireInterpreterAdded(installs[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (setPref) {
                try {
                    String xml = defs.getAsXML();
                    DLTKLaunchingPlugin.getDefault().getPluginPreferences().setValue(PREF_INTERPRETER_XML, xml);
                }
                catch (ParserConfigurationException e) {
                    DLTKLaunchingPlugin.log(e);
                }
                catch (IOException e) {
                    DLTKLaunchingPlugin.log(e);
                }
                catch (TransformerException e) {
                    DLTKLaunchingPlugin.log(e);
                }
            }
        }
    }

    public static IRuntimeBuildpathEntry newDefaultProjectBuildpathEntry(IScriptProject project) {
        return new DefaultProjectBuildpathEntry(project);
    }

    public static IRuntimeBuildpathEntry newProjectRuntimeBuildpathEntry(IScriptProject project) {
        IBuildpathEntry cpe = DLTKCore.newProjectEntry((IPath)project.getProject().getFullPath());
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newArchiveRuntimeBuildpathEntry(IResource resource) {
        IBuildpathEntry cpe = DLTKCore.newLibraryEntry((IPath)resource.getFullPath());
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newArchiveRuntimeBuildpathEntry(IPath path) {
        IBuildpathEntry cpe = DLTKCore.newLibraryEntry((IPath)path);
        return ScriptRuntime.newRuntimeBuildpathEntry(cpe);
    }

    public static IRuntimeBuildpathEntry newRuntimeContainerBuildpathEntry(IPath path, int buildpathProperty) throws CoreException {
        return ScriptRuntime.newRuntimeContainerBuildpathEntry(path, buildpathProperty, null);
    }

    public static IRuntimeBuildpathEntry newRuntimeContainerBuildpathEntry(IPath path, int buildpathProperty, IScriptProject project) throws CoreException {
        IBuildpathEntry cpe = DLTKCore.newContainerEntry((IPath)path);
        RuntimeBuildpathEntry entry = new RuntimeBuildpathEntry(cpe, buildpathProperty);
        entry.setScriptProject(project);
        return entry;
    }

    public static IRuntimeBuildpathEntry newRuntimeBuildpathEntry(String memento) throws CoreException {
        try {
            Element root = null;
            DocumentBuilder parser = DLTKLaunchingPlugin.getParser();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String id = root.getAttribute("id");
            if (id == null || id.length() == 0) {
                return new RuntimeBuildpathEntry(root);
            }
            IRuntimeBuildpathEntry2 entry = DLTKLaunchingPlugin.getDefault().newRuntimeBuildpathEntry(id);
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element element;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && "memento".equals((element = (Element)node).getNodeName())) {
                    entry.initializeFrom(element);
                }
                ++i;
            }
            return entry;
        }
        catch (SAXException e) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_31, e);
        }
        catch (IOException e) {
            ScriptRuntime.abort(LaunchingMessages.ScriptRuntime_32, e);
        }
        return null;
    }

    private static IRuntimeBuildpathEntry newRuntimeBuildpathEntry(IBuildpathEntry entry) {
        return new RuntimeBuildpathEntry(entry);
    }

    public static IRuntimeBuildpathEntry[] computeUnresolvedRuntimeBuildpath(IScriptProject project) throws CoreException {
        IBuildpathEntry[] entries = project.getRawBuildpath();
        ArrayList<IRuntimeBuildpathEntry> buildpathEntries = new ArrayList<IRuntimeBuildpathEntry>(3);
        int i = 0;
        while (i < entries.length) {
            IBuildpathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
                    if (container == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            buildpathEntries.add(ScriptRuntime.newRuntimeContainerBuildpathEntry(container.getPath(), 1, project));
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        buildpathEntries.add(ScriptRuntime.newDefaultProjectBuildpathEntry(project));
        return buildpathEntries.toArray(new IRuntimeBuildpathEntry[buildpathEntries.size()]);
    }

    public static IRuntimeBuildpathProvider getBuildpathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute("buildpathProvider", null);
        IRuntimeBuildpathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultBuildpathProvider;
        } else {
            provider = ScriptRuntime.getBuildpathProviders().get(providerId);
            if (provider == null) {
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_26, (Object[])new String[]{providerId}), null);
            }
        }
        return provider;
    }

    public static IRuntimeBuildpathProvider getScriptpathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute("sourcepathProvider", null);
        IRuntimeBuildpathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultSourcepathProvider;
        } else {
            provider = ScriptRuntime.getBuildpathProviders().get(providerId);
            if (provider == null) {
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_27, (Object[])new String[]{providerId}), null);
            }
        }
        return provider;
    }

    private static IRuntimeBuildpathEntry[] computeDefaultContainerEntries(IRuntimeBuildpathEntry entry, ILaunchConfiguration config) throws CoreException {
        IScriptProject project = entry.getScriptProject();
        if (project == null) {
            project = ScriptRuntime.getScriptProject(config);
        }
        return ScriptRuntime.computeDefaultContainerEntries(entry, project);
    }

    private static IRuntimeBuildpathEntry[] computeDefaultContainerEntries(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        if (project == null || entry == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
        if (container == null) {
            ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Could_not_resolve_classpath_container___0__1, (Object[])new String[]{entry.getPath().toString()}), null);
            return null;
        }
        IBuildpathEntry[] cpes = container.getBuildpathEntries();
        int property = -1;
        switch (container.getKind()) {
            case 1: {
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        ArrayList<IRuntimeBuildpathEntry> resolved = new ArrayList<IRuntimeBuildpathEntry>(cpes.length);
        List<IScriptProject> projects = fgProjects.get();
        Integer count = fgEntryCount.get();
        if (projects == null) {
            projects = new ArrayList<IScriptProject>();
            fgProjects.set(projects);
            count = new Integer(0);
        }
        int intCount = count;
        fgEntryCount.set(new Integer(++intCount));
        try {
            int i = 0;
            while (i < cpes.length) {
                IBuildpathEntry cpe = cpes[i];
                if (cpe.getEntryKind() == 2) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                    IScriptProject jp = DLTKCore.create((IProject)p);
                    if (!projects.contains(jp)) {
                        projects.add(jp);
                        IRuntimeBuildpathEntry buildpath = ScriptRuntime.newDefaultProjectBuildpathEntry(jp);
                        IRuntimeBuildpathEntry[] entries = ScriptRuntime.resolveRuntimeBuildpathEntry(buildpath, jp);
                        int j = 0;
                        while (j < entries.length) {
                            IRuntimeBuildpathEntry e = entries[j];
                            if (!resolved.contains(e)) {
                                resolved.add(entries[j]);
                            }
                            ++j;
                        }
                    }
                } else {
                    IRuntimeBuildpathEntry e = ScriptRuntime.newRuntimeBuildpathEntry(cpe);
                    if (!resolved.contains(e)) {
                        resolved.add(e);
                    }
                }
                ++i;
            }
        }
        finally {
            if (--intCount == 0) {
                fgProjects.set(null);
                fgEntryCount.set(null);
            } else {
                fgEntryCount.set(new Integer(intCount));
            }
        }
        IRuntimeBuildpathEntry[] result = new IRuntimeBuildpathEntry[resolved.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (IRuntimeBuildpathEntry)resolved.get(i);
            result[i].setBuildpathProperty(property);
            ++i;
        }
        return result;
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IResource resource = entry.getResource();
                if (resource instanceof IProject) {
                    IProject p = (IProject)resource;
                    IScriptProject project = DLTKCore.create((IProject)p);
                    if (project != null && p.isOpen() && project.exists()) break;
                    return new IRuntimeBuildpathEntry[0];
                }
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Buildpath_references_non_existant_project___0__3, (Object[])new String[]{entry.getPath().lastSegment()}), null);
                break;
            }
            case 4: {
                IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getContainerName());
                if (resolver == null) {
                    return ScriptRuntime.computeDefaultContainerEntries(entry, configuration);
                }
                return resolver.resolveRuntimeBuildpathEntry(entry, configuration);
            }
            case 2: {
                IPath path;
                IFileHandle fileHandle;
                String location = entry.getLocation();
                if (location == null) {
                    ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Buildpath_references_non_existant_archive___0__4, (Object[])new String[]{entry.getPath().toString()}), null);
                }
                if ((fileHandle = EnvironmentPathUtils.isFull((IPath)(path = entry.getPath())) ? EnvironmentPathUtils.getFile((IPath)path) : LocalEnvironment.getInstance().getFile(path)) != null && fileHandle.exists()) break;
                ScriptRuntime.abort(MessageFormat.format((String)LaunchingMessages.ScriptRuntime_Buildpath_references_non_existant_archive___0__4, (Object[])new String[]{entry.getPath().toString()}), null);
                break;
            }
            case 5: {
                IRuntimeBuildpathEntryResolver resolver = ScriptRuntime.getContributedResolver(((IRuntimeBuildpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeBuildpathEntry(entry, configuration);
            }
        }
        return new IRuntimeBuildpathEntry[]{entry};
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        switch (entry.getType()) {
            case 4: {
                IRuntimeBuildpathEntryResolver2 resolver = ScriptRuntime.getContainerResolver(entry.getContainerName());
                if (resolver == null) {
                    return ScriptRuntime.computeDefaultContainerEntries(entry, project);
                }
                return resolver.resolveRuntimeBuildpathEntry(entry, project);
            }
            case 5: {
                IRuntimeBuildpathEntryResolver resolver = ScriptRuntime.getContributedResolver(((IRuntimeBuildpathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeBuildpathEntry(entry, project);
            }
        }
        return new IRuntimeBuildpathEntry[]{entry};
    }

    public static IRuntimeBuildpathEntry[] computeUnresolvedRuntimeBuildpath(ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.getBuildpathProvider(configuration).computeUnresolvedBuildpath(configuration);
    }

    public static IRuntimeBuildpathEntry[] resolveRuntimeBuildpath(IRuntimeBuildpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.getBuildpathProvider(configuration).resolveBuildpath(entries, configuration);
    }

    private static Map<String, IRuntimeBuildpathEntryResolver> getEntryResolvers() {
        if (fgRuntimeBuildpathEntryResolvers == null) {
            ScriptRuntime.initializeResolvers();
        }
        return fgRuntimeBuildpathEntryResolvers;
    }

    private static IRuntimeBuildpathEntryResolver getContributedResolver(String typeId) {
        IRuntimeBuildpathEntryResolver resolver = ScriptRuntime.getEntryResolvers().get(typeId);
        if (resolver == null) {
            return new DefaultEntryResolver();
        }
        return resolver;
    }

    public static String[] computeDefaultRuntimeClassPath(IScriptProject jproject) throws CoreException {
        IRuntimeBuildpathEntry[] unresolved = ScriptRuntime.computeUnresolvedRuntimeBuildpath(jproject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeBuildpathEntry entry = unresolved[i];
            if (entry.getBuildpathProperty() == 3) {
                IRuntimeBuildpathEntry[] entries = ScriptRuntime.resolveRuntimeBuildpathEntry(entry, jproject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    public static ISourceContainer[] getSourceContainers(IRuntimeBuildpathEntry[] resolved) {
        return ScriptSourceLookupUtil.translate(resolved);
    }

    public static IRuntimeBuildpathEntry[] computeUnresolvedSourceBuildpath(ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.getScriptpathProvider(configuration).computeUnresolvedBuildpath(configuration);
    }

    public static class DefaultInterpreterEntry {
        private final String nature;
        private final String environment;

        public DefaultInterpreterEntry(String nature, String environment) {
            this.nature = nature;
            this.environment = environment;
        }

        public String getNature() {
            return this.nature;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
            result = 31 * result + (this.nature == null ? 0 : this.nature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultInterpreterEntry other = (DefaultInterpreterEntry)obj;
            if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
                return false;
            }
            return !(this.nature == null ? other.nature != null : !this.nature.equals(other.nature));
        }

        public String toString() {
            return String.valueOf(this.nature) + "/" + this.environment;
        }
    }
}

