/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser.structure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.xotcl.internal.core.parser.structure.XOTclType;

public class XOTclNames {
    private static final String ATTR = XOTclNames.class.getName();
    private final Map<String, Map<String, XOTclTypeInfo>> names = new HashMap<String, Map<String, XOTclTypeInfo>>();

    public static XOTclNames get(ITclModelBuildContext context) {
        return (XOTclNames)context.getAttribute(ATTR);
    }

    public static XOTclNames create(ITclModelBuildContext context) {
        XOTclNames names = XOTclNames.get(context);
        if (names == null) {
            names = new XOTclNames();
            context.setAttribute(ATTR, (Object)names);
        }
        return names;
    }

    public void addType(ITclTypeHandler resolvedType) {
        String namespace = resolvedType.getNamespace();
        if (namespace.startsWith("::")) {
            namespace = namespace.substring(2);
        }
        if (namespace.length() == 0) {
            return;
        }
        String[] segments = TclParseUtil.tclSplit((String)namespace);
        if (segments.length == 0) {
            return;
        }
        String lastName = segments[segments.length - 1];
        Map<String, XOTclTypeInfo> types = this.names.get(lastName);
        if (types == null) {
            types = new HashMap<String, XOTclTypeInfo>();
            this.names.put(lastName, types);
        }
        if (!types.containsKey(namespace)) {
            types.put(namespace, new XOTclTypeInfo(segments));
        }
    }

    public XOTclType resolve(String name) {
        String[] segments = TclParseUtil.tclSplit((String)name);
        if (segments.length == 0) {
            return null;
        }
        Map<String, XOTclTypeInfo> types = this.names.get(segments[segments.length - 1]);
        if (types == null) {
            return null;
        }
        for (Map.Entry<String, XOTclTypeInfo> entry : types.entrySet()) {
            if (!entry.getValue().endsWith(segments)) continue;
            return new XOTclType(entry.getKey(), entry.getValue());
        }
        return null;
    }

    static class XOTclTypeInfo {
        final String[] segments;

        public XOTclTypeInfo(String[] segments) {
            this.segments = segments;
        }

        public boolean endsWith(String[] parts) {
            int pLen = parts.length;
            int sLen = this.segments.length;
            if (pLen <= sLen) {
                int offset = sLen - pLen;
                int i = 0;
                while (i < pLen) {
                    if (!parts[i].equals(this.segments[offset + i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public String getSimpleName() {
            return this.segments[this.segments.length - 1];
        }
    }
}

