/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class JavaScriptBracketInserter
extends BracketInserter {
    JavaScriptBracketInserter(ScriptEditor scriptEditor) {
        super(scriptEditor);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit || this.editor.getInsertMode() != ScriptEditor.SMART_INSERT) {
            return;
        }
        switch (event.character) {
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': {
                break;
            }
            default: {
                return;
            }
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        Point selection = sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset + length, scanner.getPosition() - offset - length).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            switch (event.character) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '<': {
                    if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                    return;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                    return;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 2000 && prevToken != 2000 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (!JavaScriptBracketInserter.validatePartitioning((IDocument)document, (int)offset, (String)"__javascript_partitioning", (String[])new String[0])) {
                return;
            }
            if (!this.editor.validateEditorInputState()) {
                return;
            }
            this.insertBrackets(document, offset, length, event.character, JavaScriptBracketInserter.getPeerCharacter((char)event.character));
            event.doit = false;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }
}

