/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemIdentifierInt;
import org.eclipse.dltk.compiler.problem.ProblemIdentifierString;

public class ProblemCategoryManager {
    private static final String ID_ATTR = "id";
    private static final String NATURE_ATTR = "nature";
    private static final String SCOPE_ATTR = "scope";
    private static final String CATEGORY_ELEMENT = "problemCategory";
    private static final String PROBLEM_ELEMENT = "problem";
    private static ProblemCategoryManager instance = null;
    private final Map<Key, ScopeDescriptor> scopes = new HashMap<Key, ScopeDescriptor>();

    public static synchronized ProblemCategoryManager getInstance() {
        if (instance == null) {
            instance = new ProblemCategoryManager();
        }
        return instance;
    }

    public String[] getID(String natureId, String scopeId, IProblemIdentifier problem) {
        Assert.isNotNull((Object)natureId);
        ScopeDescriptor scope = this.getScope(natureId, scopeId);
        if (scope == null) {
            return new String[0];
        }
        Iterator iterator = scope.entrySet().iterator();
        ArrayList<String> ids = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((ProblemCategory)entry.getValue()).contains(problem)) continue;
            ids.add((String)entry.getKey());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public IProblemCategory getCategory(String natureId, String scopeId, String id) {
        Assert.isNotNull((Object)natureId);
        ScopeDescriptor scope = this.getScope(natureId, scopeId);
        if (scope == null) {
            return null;
        }
        return (IProblemCategory)scope.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScopeDescriptor getScope(String natureId, String scopeId) {
        IConfigurationElement[] elements;
        ScopeDescriptor scope;
        Key scopeKey = new Key(natureId, scopeId);
        Map<Key, ScopeDescriptor> map = this.scopes;
        synchronized (map) {
            scope = this.scopes.get(scopeKey);
            if (scope == null && this.scopes.containsKey(scopeKey)) {
                return null;
            }
        }
        if (scope != null) return scope;
        scope = new ScopeDescriptor();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.core.problemFactory");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String categoryId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (CATEGORY_ELEMENT.equals(element.getName()) && scopeKey.natureId.equals(element.getAttribute(NATURE_ATTR)) && scopeKey.scopeId.equals(element.getAttribute(SCOPE_ATTR)) && (categoryId = element.getAttribute(ID_ATTR)) != null) {
                ProblemCategory category = (ProblemCategory)scope.get(categoryId);
                if (category == null) {
                    category = new ProblemCategory(categoryId);
                    scope.put(categoryId, category);
                }
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren(PROBLEM_ELEMENT);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement problem = iConfigurationElementArray2[n4];
                    IProblemIdentifier identifier = DefaultProblemIdentifier.decode(problem.getValue());
                    if (identifier != null && !(identifier instanceof ProblemIdentifierInt) && !(identifier instanceof ProblemIdentifierString)) {
                        category.add(identifier);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Map<Key, ScopeDescriptor> map2 = this.scopes;
        synchronized (map2) {
            this.scopes.put(scopeKey, scope);
            return scope;
        }
    }

    static class Key {
        final String natureId;
        final String scopeId;

        public Key(String natureId, String scopeId) {
            this.natureId = natureId;
            this.scopeId = scopeId != null ? scopeId : "";
        }

        public int hashCode() {
            return this.natureId.hashCode() * 13 + this.scopeId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.natureId.equals(other.natureId) && this.scopeId.equals(other.scopeId);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProblemCategory
    extends HashSet<IProblemIdentifier>
    implements IProblemCategory {
        private final String name;
        private final Collection<IProblemIdentifier> contents;

        public ProblemCategory(String name) {
            this.name = name;
            this.contents = Collections.unmodifiableCollection(this);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<IProblemIdentifier> contents() {
            return this.contents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScopeDescriptor
    extends HashMap<String, ProblemCategory> {
        ScopeDescriptor() {
        }
    }
}

