/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.codeassist.InternalCompletionProposal;

public class CompletionProposal {
    public static final int FIELD_REF = 1;
    public static final int KEYWORD = 2;
    public static final int LABEL_REF = 3;
    public static final int LOCAL_VARIABLE_REF = 4;
    public static final int METHOD_REF = 5;
    public static final int METHOD_DECLARATION = 6;
    public static final int TYPE_REF = 7;
    public static final int VARIABLE_DECLARATION = 8;
    public static final int POTENTIAL_METHOD_DECLARATION = 9;
    public static final int METHOD_NAME_REFERENCE = 10;
    public static final int PACKAGE_REF = 11;
    public static final int USER = 15;
    protected static final int FIRST_KIND = 1;
    protected static final int LAST_KIND = 22;
    private boolean updateCompletion = false;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private String completion = "";
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private String declarationKey = null;
    private String name = null;
    private String key = null;
    private int flags = 0;
    private String[] parameterNames = null;
    private IModelElement modelElement;
    private Map<String, Object> attributes;
    private Object extraInfo;
    private int accessibility = 0;
    private boolean isConstructor = false;
    private static final String FOREIGN = String.valueOf(CompletionProposal.class.getName()) + ".FOREIGN";

    public static CompletionProposal create(int kind, int completionOffset) {
        return new InternalCompletionProposal(kind, completionOffset);
    }

    protected CompletionProposal(int kind, int completionLocation) {
        if (kind < 1 || kind > 22) {
            throw new IllegalArgumentException();
        }
        if (this.completion == null || completionLocation < 0) {
            if (this.completion == null || completionLocation != -1) {
                throw new IllegalArgumentException();
            }
            completionLocation = 0;
        }
        this.completionKind = kind;
        this.completionLocation = completionLocation;
    }

    public int getKind() {
        return this.completionKind;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.tokenStart = startIndex;
        this.tokenEnd = endIndex;
    }

    public String getCompletion() {
        if (this.completionKind == 6) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length());
                    int start = 0;
                    int end = this.completion.indexOf(37);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = this.completion.indexOf(37, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length() - start);
                        }
                        ++i;
                    }
                    this.completion = completionBuffer.toString();
                }
            }
        } else if (this.completionKind == 5) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length());
                    int start = 0;
                    int end = this.completion.indexOf(37);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = this.completion.indexOf(37, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length() - start);
                        }
                        ++i;
                    }
                    this.completion = completionBuffer.toString();
                }
            }
        }
        return this.completion;
    }

    public void setCompletion(String completion) {
        this.completion = completion;
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int rating) {
        if (rating <= 0) {
            throw new IllegalArgumentException();
        }
        this.relevance = rating;
    }

    public String getDeclarationKey() {
        return this.declarationKey;
    }

    public void setDeclarationKey(String key) {
        this.declarationKey = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String[] findParameterNames(IProgressMonitor monitor) {
        return this.parameterNames;
    }

    public void setParameterNames(String[] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        switch (this.completionKind) {
            case 1: {
                buffer.append("FIELD_REF");
                break;
            }
            case 2: {
                buffer.append("KEYWORD");
                break;
            }
            case 3: {
                buffer.append("LABEL_REF");
                break;
            }
            case 4: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 6: {
                buffer.append("METHOD_DECLARATION");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 5: {
                buffer.append("METHOD_REF");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 7: {
                buffer.append("TYPE_REF");
                break;
            }
            case 8: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 9: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 10: {
                buffer.append("METHOD_IMPORT");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        buffer.append("]{completion:");
        if (this.completion != null) {
            buffer.append(this.completion);
        }
        buffer.append(", declSign:");
        buffer.append(", declKey:");
        if (this.declarationKey != null) {
            buffer.append(this.declarationKey);
        }
        buffer.append(", key:");
        if (this.key != null) {
            buffer.append(this.key);
        }
        buffer.append(", name:");
        if (this.name != null) {
            buffer.append(this.name);
        }
        buffer.append(", [");
        buffer.append(this.replaceStart);
        buffer.append(',');
        buffer.append(this.replaceEnd);
        buffer.append("], relevance=");
        buffer.append(this.relevance);
        buffer.append('}');
        return buffer.toString();
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public void setModelElement(IModelElement modelElement) {
        this.modelElement = modelElement;
    }

    public void setForeign(Object f) {
        this.setAttribute(FOREIGN, f);
    }

    public Object getForeign() {
        return this.getAttribute(FOREIGN);
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(Object extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void setAttribute(String key, Object value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>(4);
            }
            this.attributes.put(key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public Object getAttribute(String key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public int getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(int accessiblility) {
        this.accessibility = accessiblility;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setIsConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void setCompletionLocation(int i) {
        this.completionLocation = i;
    }
}

