/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.internal.core.util.LRUCache;

public class ElementCache
extends OverflowingLRUCache {
    private IModelElement spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        Openable element;
        block5: {
            element = (Openable)entry._fKey;
            try {
                if (element.canBeRemovedFromCache()) break block5;
                return false;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        if (element instanceof ArchiveFolder || element instanceof ExternalScriptFolder) {
            IScriptFolder archiveFolder = (IScriptFolder)((Object)element);
            IProjectFragment root = (IProjectFragment)archiveFolder.getParent();
            root.close();
        } else {
            element.close();
        }
        return true;
    }

    public void ensureSpaceLimit(int childrenSize, IModelElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }

    public void resetSpaceLimit(int defaultLimit, IModelElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }
}

