/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetBuildpathOperation
extends ModelOperation {
    IBuildpathEntry[] oldResolvedPath;
    IBuildpathEntry[] newResolvedPath;
    IBuildpathEntry[] newRawPath;
    boolean canChangeResources;
    boolean buildpathWasSaved;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    ScriptProject project;
    boolean identicalRoots;
    public static final IBuildpathEntry[] DO_NOT_SET_ENTRIES = new IBuildpathEntry[0];
    public static final IBuildpathEntry[] DO_NOT_UPDATE_PROJECT_REFS = new IBuildpathEntry[0];

    public SetBuildpathOperation(ScriptProject project, IBuildpathEntry[] oldResolvedPath, IBuildpathEntry[] newRawPath, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IModelElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.canChangeResources = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
        this.project = project;
    }

    protected void addBuildpathDeltas(IProjectFragment[] roots, int flag, ModelElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0) {
                try {
                    root.close();
                }
                catch (ModelException modelException) {}
            }
            ++i;
        }
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected int buildpathContains(IBuildpathEntry[] list, IBuildpathEntry entry) {
        exclusionPatterns = entry.getExclusionPatterns();
        inclusionPatterns = entry.getInclusionPatterns();
        i = 0;
        while (i < list.length) {
            block7: {
                block9: {
                    block8: {
                        other = list[i];
                        if (other.getContentKind() != entry.getContentKind() || other.getEntryKind() != entry.getEntryKind() || other.isExported() != entry.isExported() || !other.getPath().equals((Object)entry.getPath())) break block7;
                        otherIncludes = other.getInclusionPatterns();
                        if (inclusionPatterns == otherIncludes) break block8;
                        if (inclusionPatterns == null) break block7;
                        includeLength = inclusionPatterns.length;
                        if (otherIncludes != null && otherIncludes.length == includeLength) {
                            j = 0;
                            while (j < includeLength) {
                                if (inclusionPatterns[j].toString().equals(otherIncludes[j].toString())) {
                                    ++j;
                                } else {
                                    ** GOTO lbl-1000
                                }
                            }
                        }
                        break block7;
lbl-1000:
                        // 2 sources

                        {
                            break block7;
                        }
                    }
                    if (exclusionPatterns == (otherExcludes = other.getExclusionPatterns())) break block9;
                    if (exclusionPatterns == null) break block7;
                    excludeLength = exclusionPatterns.length;
                    if (otherExcludes != null && otherExcludes.length == excludeLength) {
                        j = 0;
                        while (j < excludeLength) {
                            if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                ++j;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    }
                    break block7;
lbl-1000:
                    // 2 sources

                    {
                        break block7;
                    }
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList<IFolder> collection) throws ModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add((IFolder)r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected ArrayList<IScriptFolder> determineAffectedScriptFolders(IPath location) throws ModelException {
        ArrayList<IScriptFolder> fragments = new ArrayList<IScriptFolder>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IBuildpathEntry[] buildpath = this.project.getExpandedBuildpath(true);
            int i = 0;
            while (i < buildpath.length) {
                IBuildpathEntry entry = buildpath[i];
                IPath path = buildpath[i].getPath();
                if (entry.getEntryKind() != 2 && path.isPrefixOf(location) && !path.equals((Object)location)) {
                    IProjectFragment[] roots = this.project.computeProjectFragments(buildpath[i]);
                    IProjectFragment root = roots[0];
                    ArrayList<IFolder> folders = new ArrayList<IFolder>();
                    folders.add(folder);
                    this.collectAllSubfolders(folder, folders);
                    int segments = path.segmentCount();
                    for (IFolder f : folders) {
                        IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                        IScriptFolder pkg = root.getScriptFolder(relativePath);
                        fragments.add(pkg);
                    }
                }
                ++i;
            }
        }
        return fragments;
    }

    @Override
    protected void executeOperation() throws ModelException {
        this.updateProjectReferencesIfNecessary();
        this.saveBuildpathIfNecessary();
        try {
            if (this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS) {
                this.newRawPath = this.project.getRawBuildpath();
            }
            if (this.newRawPath != DO_NOT_SET_ENTRIES) {
                this.updateBuildpath();
                this.project.updateProjectFragments();
                ModelManager.getModelManager().getDeltaProcessor().addForRefresh(this.project);
            }
        }
        finally {
            block13: {
                if (!this.identicalRoots && this.canChangeResources) {
                    try {
                        this.project.getProject().touch(this.progressMonitor);
                    }
                    catch (CoreException e) {
                        if (!ModelManager.BP_RESOLVE_VERBOSE) break block13;
                        Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                        e.printStackTrace();
                    }
                }
            }
        }
        this.done();
    }

    protected void generateBuildpathChangeDeltas() {
        ModelManager manager = ModelManager.getModelManager();
        if (manager.deltaState.findProject(this.project.getElementName()) == null) {
            return;
        }
        boolean needToUpdateDependents = false;
        ModelElementDelta delta = new ModelElementDelta(this.getModel());
        boolean hasDelta = false;
        if (this.buildpathWasSaved) {
            delta.changed(this.project, 131072);
            hasDelta = true;
        }
        int oldLength = this.oldResolvedPath.length;
        int newLength = this.newResolvedPath.length;
        final IndexManager indexManager = manager.getIndexManager();
        HashMap<IPath, IProjectFragment> oldRoots = null;
        IProjectFragment[] roots = null;
        if (this.project.isOpen()) {
            try {
                roots = this.project.getProjectFragments();
            }
            catch (ModelException modelException) {}
        } else {
            Map allRemovedRoots = manager.getDeltaProcessor().removedRoots;
            if (allRemovedRoots != null) {
                roots = (IProjectFragment[])allRemovedRoots.get(this.project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IProjectFragment>();
            int i = 0;
            while (i < roots.length) {
                IProjectFragment root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            int index = this.buildpathContains(this.newResolvedPath, this.oldResolvedPath[i]);
            if (index == -1) {
                if (this.oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    IProjectFragment oldRoot;
                    IProjectFragment[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (IProjectFragment)oldRoots.get(this.oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new IProjectFragment[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ArrayList<IProjectFragment> accumulatedRoots = new ArrayList<IProjectFragment>();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(this.project.rootID());
                            this.project.computeProjectFragments(this.oldResolvedPath[i], accumulatedRoots, rootIDs, null, false, false, null);
                            pkgFragmentRoots = accumulatedRoots.toArray(new IProjectFragment[accumulatedRoots.size()]);
                        }
                        catch (ModelException modelException) {
                            pkgFragmentRoots = new IProjectFragment[]{};
                        }
                    }
                    this.addBuildpathDeltas(pkgFragmentRoots, 128, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || this.oldResolvedPath[i].isExported();
                    if (indexManager != null) {
                        IBuildpathEntry oldEntry = this.oldResolvedPath[i];
                        final IPath path = oldEntry.getPath();
                        switch (changeKind) {
                            case 3: {
                                final char[][] inclusionPatterns = ((BuildpathEntry)oldEntry).fullInclusionPatternChars();
                                final char[][] exclusionPatterns = ((BuildpathEntry)oldEntry).fullExclusionPatternChars();
                                this.postAction(new ModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        indexManager.removeSourceFolderFromIndex(SetBuildpathOperation.this.project, path, inclusionPatterns, exclusionPatterns);
                                        ProjectIndexerManager.removeProjectFragment(SetBuildpathOperation.this.project, path);
                                    }
                                }, 2);
                                break;
                            }
                            case 1: {
                                final DeltaProcessingState deltaState = manager.deltaState;
                                this.postAction(new ModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        if (deltaState.otherRoots.get(path) == null) {
                                            indexManager.discardJobs(path.toString());
                                            indexManager.removeIndex(path);
                                            ProjectIndexerManager.removeLibrary(SetBuildpathOperation.this.project, path);
                                        }
                                    }
                                }, 2);
                            }
                        }
                    }
                    hasDelta = true;
                }
            } else if (this.oldResolvedPath[i].getEntryKind() == 2) {
                BuildpathEntry oldEntry = (BuildpathEntry)this.oldResolvedPath[i];
                BuildpathEntry newEntry = (BuildpathEntry)this.newResolvedPath[index];
                if (oldEntry.isExported || newEntry.isExported) {
                    AccessRuleSet oldRuleSet = oldEntry.getAccessRuleSet();
                    AccessRuleSet newRuleSet = newEntry.getAccessRuleSet();
                    needToUpdateDependents = index != i ? (needToUpdateDependents |= oldRuleSet != null || newRuleSet != null) : (oldRuleSet == null ? (needToUpdateDependents |= newRuleSet != null) : (needToUpdateDependents |= !oldRuleSet.equals(newRuleSet)));
                }
                this.needCycleCheck |= oldEntry.isExported() ^ newEntry.isExported();
            } else {
                needToUpdateDependents |= this.oldResolvedPath[i].isExported() ^ this.newResolvedPath[index].isExported();
                if (index != i) {
                    this.addBuildpathDeltas(this.project.computeProjectFragments(this.oldResolvedPath[i]), 256, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            int index = this.buildpathContains(this.oldResolvedPath, this.newResolvedPath[i]);
            if (index == -1) {
                if (this.newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addBuildpathDeltas(this.project.computeProjectFragments(this.newResolvedPath[i]), 64, delta);
                    int changeKind = this.newResolvedPath[i].getEntryKind();
                    BuildpathEntry entry = (BuildpathEntry)this.newResolvedPath[i];
                    if (indexManager != null) {
                        switch (changeKind) {
                            case 1: {
                                boolean pathHasChanged = true;
                                final IPath newPath = this.newResolvedPath[i].getPath();
                                int j = 0;
                                while (j < oldLength) {
                                    IBuildpathEntry oldEntry = this.oldResolvedPath[j];
                                    if (oldEntry.getPath().equals((Object)newPath)) {
                                        pathHasChanged = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!pathHasChanged) break;
                                this.postAction(new ModelOperation.IPostAction(){

                                    public String getID() {
                                        return newPath.toString();
                                    }

                                    public void run() {
                                        ProjectIndexerManager.indexLibrary(SetBuildpathOperation.this.project, newPath);
                                    }
                                }, 2);
                                break;
                            }
                            case 3: {
                                final IPath path = entry.getPath();
                                this.postAction(new ModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        ProjectIndexerManager.indexProjectFragment(SetBuildpathOperation.this.project, path);
                                    }
                                }, 1);
                            }
                        }
                    }
                    needToUpdateDependents |= changeKind == 3 || this.newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        } else {
            this.identicalRoots = true;
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }

    protected void saveBuildpathIfNecessary() throws ModelException {
        if (!this.canChangeResources || !this.needSave) {
            return;
        }
        IBuildpathEntry[] buildpathForSave = this.newRawPath == DO_NOT_SET_ENTRIES || this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS ? this.project.getRawBuildpath() : this.newRawPath;
        if (this.project.saveBuildpath(buildpathForSave)) {
            this.buildpathWasSaved = true;
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetBuildpathOperation\n");
        buffer.append(" - buildpath : ");
        if (this.newRawPath == DO_NOT_SET_ENTRIES) {
            buffer.append("<Reuse Existing Buildpath Entries>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                IBuildpathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        return buffer.toString();
    }

    private void updateBuildpath() throws ModelException {
        this.beginTask(Messages.bind(Messages.buildpath_settingProgress, this.project.getElementName()), 2);
        this.project.getPerProjectInfo().updateBuildpathInformation(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedBuildpath(true, this.canChangeResources, false);
        }
        if (this.oldResolvedPath != null) {
            this.generateBuildpathChangeDeltas();
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary();
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        this.removeAllPostAction("UpdateClassPath:" + prerequisiteProjectPath.toString());
        try {
            Model model = ModelManager.getModelManager().getModel();
            ScriptProject initialProject = this.project;
            IScriptProject[] projects = model.getScriptProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        final ScriptProject affectedProject = (ScriptProject)projects[i];
                        if (affectedProject.equals(initialProject) || !affectedProject.isOpen()) break block7;
                        IBuildpathEntry[] buildpath = affectedProject.getExpandedBuildpath(true);
                        int j = 0;
                        int entryCount = buildpath.length;
                        while (j < entryCount) {
                            IBuildpathEntry entry = buildpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)prerequisiteProjectPath)) {
                                this.postAction(new ModelOperation.IPostAction(){

                                    public String getID() {
                                        return "UpdateClassPath:" + affectedProject.getPath().toString();
                                    }

                                    public void run() throws ModelException {
                                        affectedProject.setRawBuildpath(DO_NOT_UPDATE_PROJECT_REFS, SetBuildpathOperation.this.progressMonitor, SetBuildpathOperation.this.canChangeResources, affectedProject.getResolvedBuildpath(true, false, false), false, false);
                                    }
                                }, 2);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
    }

    protected void updateCycleMarkersIfNecessary() {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResources) {
            return;
        }
        if (!this.project.hasCycleMarker() && !this.project.hasBuildpathCycle(this.newResolvedPath)) {
            return;
        }
        this.postAction(new ModelOperation.IPostAction(){

            public String getID() {
                return "updateCycleMarkers";
            }

            public void run() throws ModelException {
                ScriptProject.updateAllCycleMarkers(null);
            }
        }, 2);
    }

    protected void updateProjectReferencesIfNecessary() throws ModelException {
        if (this.newRawPath == DO_NOT_SET_ENTRIES || this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS) {
            return;
        }
        ModelManager.getModelManager().deltaState.updateProjectReferences(this.project, this.oldResolvedPath, this.newResolvedPath, this.newRawPath, this.canChangeResources);
    }

    @Override
    public IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IBuildpathEntry[] entries = this.newRawPath;
            if (entries == DO_NOT_SET_ENTRIES) {
                try {
                    entries = this.project.getRawBuildpath();
                }
                catch (ModelException e) {
                    return e.getModelStatus();
                }
            }
            return BuildpathEntry.validateBuildpath(this.project, entries);
        }
        return ModelStatus.VERIFIED_OK;
    }
}

