/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.mylyn.DLTKUiBridgePlugin;
import org.eclipse.dltk.internal.mylyn.actions.Messages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ToggleActiveFoldingAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private static ToggleActiveFoldingAction INSTANCE;
    private IAction parentAction = null;

    public ToggleActiveFoldingAction() {
        INSTANCE = this;
        this.setText(Messages.ToggleActiveFoldingAction_Active_folding);
        this.setImageDescriptor(TasksUiImages.CONTEXT_FOCUS);
    }

    public static void toggleFolding(boolean on) {
        if (ToggleActiveFoldingAction.INSTANCE.parentAction != null) {
            INSTANCE.valueChanged(ToggleActiveFoldingAction.INSTANCE.parentAction, on);
        }
    }

    public void run(IAction action) {
        this.valueChanged(action, action.isChecked());
    }

    private void valueChanged(IAction action, boolean on) {
        try {
            if (on) {
                DLTKUIPlugin.getDefault().getPreferenceStore().setValue("editor_folding_enabled", true);
            }
            action.setChecked(on);
            DLTKUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.editor.folding.enabled", on);
        }
        catch (Throwable t) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not enable editor management", t));
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.parentAction = action;
        this.valueChanged(action, DLTKUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled"));
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IWorkbenchWindow window) {
    }
}

