/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.internal.ui.RubyLabelProvider;
import org.eclipse.dltk.ruby.internal.ui.text.hyperlink.RubyHyperlinkMessages;
import org.eclipse.dltk.ruby.internal.ui.text.hyperlink.SourceModuleLookup;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubyRequireHyperlink
implements IHyperlink {
    private final String path;
    private final IRegion region;
    private final ITextEditor editor;
    private static final String DEFAULT_EXTENSION = ".rb";

    public RubyRequireHyperlink(String path, IRegion region, ITextEditor editor) {
        this.path = path;
        this.region = region;
        this.editor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)RubyHyperlinkMessages.RequireHyperlink_text, (Object)this.path);
    }

    public String getTypeLabel() {
        return RubyHyperlinkMessages.RequireHyperlink_label;
    }

    public void open() {
        try {
            this.doOpen();
        }
        catch (Exception e) {
            RubyPlugin.log((Exception)e);
            this.showMessage(e.getMessage());
        }
    }

    private void doOpen() throws ModelException {
        OpenAction openAction;
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.editor, (boolean)false);
        if (input != null && (openAction = (OpenAction)this.editor.getAction("OpenEditor")) != null) {
            IScriptProject project = input.getScriptProject();
            Object[] modules = SourceModuleLookup.lookup(project, this.path, DEFAULT_EXTENSION);
            if (modules.length > 0) {
                if (modules.length == 1) {
                    openAction.run(modules);
                } else {
                    Object[] selection = this.selectModule((ISourceModule[])modules);
                    if (selection != null && selection.length > 0) {
                        openAction.run(selection);
                    }
                }
            } else {
                this.showMessage(RubyHyperlinkMessages.RequireHyperlink_BadSelection);
            }
        }
    }

    private ISourceModule[] selectModule(ISourceModule[] modules) {
        Object[] selection;
        Assert.isLegal((modules.length > 1 ? 1 : 0) != 0);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new RubyLabelProvider());
        dialog.setTitle(RubyHyperlinkMessages.RequireHyperlink_title);
        dialog.setMessage(RubyHyperlinkMessages.RequireHyperlink_message);
        dialog.setElements((Object[])modules);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            int size = selection.length;
            while (i < size) {
                Object current = selection[i];
                if (current instanceof ISourceModule) {
                    result.add(current);
                }
                ++i;
            }
            if (!result.isEmpty()) {
                return result.toArray(new ISourceModule[result.size()]);
            }
        }
        return null;
    }

    private void showMessage(String message) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, message, null);
        }
        this.getShell().getDisplay().beep();
    }

    private Shell getShell() {
        return this.editor.getEditorSite().getShell();
    }
}

