/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    private Checks() {
    }

    public static boolean isAvailable(IModelElement element) throws ModelException {
        if (element == null) {
            return false;
        }
        if (!element.exists()) {
            return false;
        }
        if (element.isReadOnly()) {
            return false;
        }
        return element instanceof IField || element instanceof IMethod || element instanceof ILocalVariable;
    }

    public static RefactoringStatus validateIdentifier(String newName) {
        if ("".equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (JavaScriptLanguageUtil.isValidIdentifier((String)newName)) {
            return new RefactoringStatus();
        }
        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_illegal_identifier, newName));
    }
}

