/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.javascript.core.dom.AccessorAssignment;
import org.eclipse.dltk.javascript.core.dom.CatchClause;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.GetterAssignment;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.SetterAssignment;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.ecore.EObject;

public abstract class VariableLookup
extends DomSwitch<Boolean> {
    private Map<String, List<Identifier>> decls = new HashMap<String, List<Identifier>>();
    private Set<String> scope = new HashSet<String>();

    protected abstract void reportDeclaration(Identifier var1);

    protected abstract void reportReference(Identifier var1, Identifier var2);

    public final void traverse(Node node) {
        if (this.doSwitch(node) == null) {
            for (EObject obj : node.eContents()) {
                this.traverse((Node)obj);
            }
        }
    }

    private void addDeclaration(Identifier id) {
        if (this.scope.contains(id.getName())) {
            List<Identifier> list = this.decls.get(id.getName());
            this.reportReference(id, list.get(list.size() - 1));
            return;
        }
        this.reportDeclaration(id);
        List<Identifier> list = this.decls.get(id.getName());
        if (list == null) {
            list = new ArrayList<Identifier>();
            this.decls.put(id.getName(), list);
        }
        list.add(id);
        this.scope.add(id.getName());
    }

    private void popScope(Set<String> outerScope) {
        for (String str : this.scope) {
            List<Identifier> list = this.decls.get(str);
            list.remove(list.size() - 1);
        }
        this.scope = outerScope;
    }

    protected final void findDeclarations(Node node) {
        switch (node.eClass().getClassifierID()) {
            case 35: {
                ExpressionStatement stmt = (ExpressionStatement)node;
                if (!(stmt.getExpression() instanceof FunctionExpression)) break;
                Identifier id = ((FunctionExpression)stmt.getExpression()).getIdentifier();
                if (id != null) {
                    this.addDeclaration(id);
                }
                return;
            }
            case 56: {
                return;
            }
            case 33: {
                this.addDeclaration(((VariableDeclaration)node).getIdentifier());
            }
        }
        for (EObject obj : node.eContents()) {
            this.findDeclarations((Node)obj);
        }
    }

    private Set<String> pushScope() {
        Set<String> outerScope = this.scope;
        this.scope = new HashSet<String>();
        return outerScope;
    }

    @Override
    public Boolean caseVariableReference(VariableReference node) {
        Identifier id = node.getVariable();
        List<Identifier> list = this.decls.get(id.getName());
        if (list == null || list.size() == 0) {
            this.reportReference(id, null);
        } else {
            this.reportReference(id, list.get(list.size() - 1));
        }
        return true;
    }

    @Override
    public Boolean caseGetterAssignment(GetterAssignment node) {
        Set<String> outerScope = this.pushScope();
        this.findDeclarations(node.getBody());
        this.traverse(node.getBody());
        this.popScope(outerScope);
        return true;
    }

    @Override
    public Boolean caseSetterAssignment(SetterAssignment node) {
        Set<String> outerScope = this.pushScope();
        this.addDeclaration(node.getParameter());
        this.findDeclarations(node.getBody());
        this.traverse(node.getBody());
        this.popScope(outerScope);
        return true;
    }

    @Override
    public Boolean caseCatchClause(CatchClause node) {
        Set<String> outerScope = this.pushScope();
        this.addDeclaration(node.getException());
        this.traverse(node.getBody());
        this.popScope(outerScope);
        return true;
    }

    @Override
    public Boolean caseFunctionExpression(FunctionExpression node) {
        Set<String> outerScope = this.pushScope();
        if (node.getIdentifier() != null && !(node.eContainer() instanceof ExpressionStatement)) {
            this.addDeclaration(node.getIdentifier());
        }
        for (Parameter param : node.getParameters()) {
            this.addDeclaration(param.getName());
        }
        this.findDeclarations(node.getBody());
        this.traverse(node.getBody());
        this.popScope(outerScope);
        return true;
    }

    @Override
    public Boolean caseSource(Source node) {
        Set<String> outerScope = this.pushScope();
        this.findDeclarations(node);
        for (EObject obj : node.getStatements()) {
            this.traverse((Node)obj);
        }
        this.popScope(outerScope);
        return true;
    }

    public static Set<String> getVisibleNames(Node node) {
        final HashSet<String> result = new HashSet<String>();
        final boolean[] reportDecls = new boolean[]{true};
        VariableLookup lookup = new VariableLookup(){

            @Override
            protected void reportDeclaration(Identifier decl) {
                if (reportDecls[0]) {
                    result.add(decl.getName());
                }
            }

            @Override
            protected void reportReference(Identifier ref, Identifier decl) {
                if (decl == null) {
                    result.add(ref.getName());
                }
            }
        };
        Node body = null;
        while (body == null) {
            node = (Node)node.eContainer();
            switch (node.eClass().getClassifierID()) {
                case 56: {
                    body = ((FunctionExpression)node).getBody();
                    break;
                }
                case 20: 
                case 21: {
                    body = ((AccessorAssignment)node).getBody();
                }
                case 58: {
                    body = node;
                }
            }
        }
        lookup.findDeclarations(body);
        reportDecls[0] = false;
        lookup.traverse(node);
        return result;
    }

    public static List<Identifier> findReferences(Node root, Set<String> names) {
        return VariableLookup.findReferences(root, names, false);
    }

    public static List<Identifier> findReferences(Node root, Set<String> names, final boolean firstOnly) {
        Set<String> wanted;
        if (firstOnly) {
            wanted = new HashSet<String>();
            wanted.addAll(names);
        } else {
            wanted = names;
        }
        final ArrayList<Identifier> refs = new ArrayList<Identifier>();
        VariableLookup lookup = new VariableLookup(){

            @Override
            protected void reportDeclaration(Identifier decl) {
            }

            @Override
            protected void reportReference(Identifier ref, Identifier decl) {
                if (decl != null) {
                    return;
                }
                String str = ref.getName();
                if (wanted.contains(str)) {
                    refs.add(ref);
                    if (firstOnly) {
                        wanted.remove(str);
                    }
                }
            }
        };
        lookup.traverse(root);
        return refs;
    }

    public static Map<Identifier, VariableBinding> findBindings(Node node) {
        final HashMap<Identifier, VariableBinding> bindings = new HashMap<Identifier, VariableBinding>();
        VariableLookup lookup = new VariableLookup(){

            @Override
            protected void reportDeclaration(Identifier decl) {
                Node parent = (Node)decl.eContainer();
                switch (parent.eClass().getClassifierID()) {
                    case 33: {
                        break;
                    }
                }
                String typeName = null;
                bindings.put(decl, new VariableBinding(decl.getName(), bindings.size(), decl, typeName));
            }

            @Override
            protected void reportReference(Identifier ref, Identifier decl) {
                if (decl != null) {
                    bindings.put(ref, (VariableBinding)bindings.get(decl));
                }
            }
        };
        lookup.traverse(node);
        return bindings;
    }
}

