/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.testing.internal.tcltest;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestingClient;
import org.eclipse.dltk.testing.ITestingProcessor;
import org.eclipse.dltk.testing.model.ITestRunSession;

class TcltestOutputProcessor
implements ITestingProcessor {
    private ILaunch launch;
    long start = 0L;
    int index = 0;
    private ITestRunSession session;
    private ITestingClient client;
    private boolean skip = false;
    private String message;
    private int state = 0;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RESULT_WAS = 1;
    private static final int STATE_RESULT_ACTUAL = 2;
    private String resultActual = "";
    private String resultExpected = "";

    public TcltestOutputProcessor(ILaunch launch) {
        this.launch = launch;
    }

    public void done() {
        if (this.session == null || this.client == null) {
            return;
        }
        this.session.setTotalCount(this.index);
        this.client.testTerminated((int)(System.currentTimeMillis() - this.start));
    }

    public void processLine(String line) {
        String name;
        int lastIndexOf;
        if (this.session == null || this.client == null) {
            return;
        }
        if (line.length() == 0) {
            return;
        }
        if (line.startsWith("====")) {
            if (line.endsWith("FAILED")) {
                if (!this.skip) {
                    this.message = line.substring(line.indexOf(" ", line.indexOf(" ") + 1), line.lastIndexOf(" "));
                }
                if (this.skip) {
                    lastIndexOf = line.indexOf(" ", line.indexOf(" ") + 1);
                    name = line.substring(5, lastIndexOf);
                    int id = ++this.index;
                    this.client.testTree(id, name, false, 0);
                    this.client.testStarted(id, name);
                    this.session.setTotalCount(id);
                    this.client.testError(id, name);
                    this.client.testActual(this.resultActual);
                    this.client.testExpected(this.resultExpected);
                    this.client.traceStart();
                    this.client.traceMessage(this.message);
                    this.client.traceEnd();
                    this.resetState();
                }
                this.skip = !this.skip;
            }
        } else {
            if (line.equals("---- Result was:")) {
                this.state = 1;
                return;
            }
            if (line.equals("---- Result should have been (exact matching):")) {
                this.state = 2;
                return;
            }
        }
        switch (this.state) {
            case 2: {
                String d = this.resultExpected.length() > 0 ? "\n" : "";
                this.resultExpected = String.valueOf(this.resultExpected) + d + line;
                break;
            }
            case 1: {
                String d = this.resultActual.length() > 0 ? "\n" : "";
                this.resultActual = String.valueOf(this.resultActual) + d + line;
            }
        }
        if (!this.skip && line.startsWith("++++")) {
            lastIndexOf = line.lastIndexOf(" ");
            name = line.substring(5, lastIndexOf);
            String state = line.substring(lastIndexOf + 1);
            if ("PASSED".equals(state)) {
                int id = ++this.index;
                this.client.testTree(id, name, false, 0);
                this.client.testStarted(id, name);
                this.session.setTotalCount(id);
                this.client.testEnded(id, name);
                this.resetState();
            } else {
                String sk = "SKIPPED:";
                if (line.indexOf(sk) != -1) {
                    lastIndexOf = line.lastIndexOf(sk);
                    name = line.substring(5, lastIndexOf);
                    state = line.substring(lastIndexOf + sk.length());
                    int id = ++this.index;
                    this.client.testTree(id, name, false, 0);
                    this.client.testStarted(id, name);
                    this.session.setTotalCount(id);
                    this.client.testFailed(id, name);
                    this.client.traceStart();
                    this.client.traceMessage(state);
                    this.client.traceEnd();
                    this.resetState();
                }
            }
        }
    }

    private void resetState() {
        this.state = 0;
        this.resultActual = "";
        this.resultExpected = "";
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.index = 0;
        this.session = DLTKTestingPlugin.getTestRunSession((ILaunch)this.launch);
        if (this.session == null) {
            return;
        }
        this.client = this.session.getTestRunnerClient();
        if (this.client != null) {
            this.client.testRunStart(0);
        }
    }
}

