/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.Messages;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

public class ExternalFoldersManager {
    private static final String EXTERNAL_PROJECT_NAME = ".org.eclipse.dltk.core.external.folders";
    private static final String LINKED_FOLDER_NAME = ".link";
    private HashMap folders;
    private int counter = 0;

    @Nullable
    public static HashSet<IPath> getExternalFolders(IBuildpathEntry[] buildpath) {
        if (buildpath == null) {
            return null;
        }
        HashSet<IPath> folders = null;
        int i = 0;
        while (i < buildpath.length) {
            IPath local;
            IPath entryPath;
            IBuildpathEntry entry = buildpath[i];
            if (entry.getEntryKind() == 1 && EnvironmentPathUtils.isLocalEnvironment(entryPath = entry.getPath()) && ExternalFoldersManager.isExternalFolderPath(local = EnvironmentPathUtils.getLocalPath(entryPath))) {
                if (folders == null) {
                    folders = new HashSet<IPath>();
                }
                folders.add(local);
            }
            ++i;
        }
        return folders;
    }

    public static boolean isExternalFolderPath(IPath externalPath) {
        if (externalPath == null) {
            return false;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(externalPath.segment(0)).exists()) {
            return false;
        }
        File externalFolder = externalPath.toFile();
        if (externalFolder.isFile()) {
            return false;
        }
        return externalPath.getFileExtension() == null || externalFolder.exists();
    }

    public static boolean isInternalPathForExternalFolder(IPath resourcePath) {
        return EXTERNAL_PROJECT_NAME.equals(resourcePath.segment(0));
    }

    public IFolder addFolder(IPath externalFolderPath) {
        return this.addFolder(externalFolderPath, this.getExternalFoldersProject());
    }

    public IFolder addFolder(IPath externalFolderPath, boolean scheduleForCreation) {
        return this.addFolder(externalFolderPath, this.getExternalFoldersProject());
    }

    private synchronized IFolder addFolder(IPath externalFolderPath, IProject externalFoldersProject) {
        IFolder result;
        HashMap knownFolders = this.getFolders();
        Object existing = knownFolders.get(externalFolderPath);
        if (existing != null) {
            return (IFolder)existing;
        }
        while ((result = externalFoldersProject.getFolder(LINKED_FOLDER_NAME + this.counter++)).exists()) {
        }
        knownFolders.put(externalFolderPath, result);
        return result;
    }

    public IFolder createLinkFolder(IPath externalFolderPath, boolean refreshIfExistAlready, IProgressMonitor monitor) throws CoreException {
        IProject externalFoldersProject = this.createExternalFoldersProject(monitor);
        IFolder result = this.addFolder(externalFolderPath, externalFoldersProject);
        if (!result.exists()) {
            result.createLink(externalFolderPath, 16, monitor);
        } else if (refreshIfExistAlready) {
            result.refreshLocal(2, monitor);
        }
        return result;
    }

    public synchronized void cleanUp(IProgressMonitor monitor) throws CoreException {
        DeltaProcessingState state = ModelManager.getModelManager().deltaState;
        HashMap roots = state.roots;
        if (roots == null) {
            return;
        }
        HashMap knownFolders = this.getFolders();
        for (IPath path : knownFolders.keySet()) {
            IFolder folder;
            if (roots == null || roots.containsKey(path) || (folder = (IFolder)knownFolders.get(path)) == null) continue;
            folder.delete(true, monitor);
        }
        IProject project = this.getExternalFoldersProject();
        if (project.isAccessible() && project.members().length == 1) {
            project.delete(true, monitor);
        }
    }

    public IProject getExternalFoldersProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(EXTERNAL_PROJECT_NAME);
    }

    private IProject createExternalFoldersProject(IProgressMonitor monitor) {
        IProject project = this.getExternalFoldersProject();
        if (!project.isAccessible()) {
            try {
                if (!project.exists()) {
                    IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                    IPath stateLocation = DLTKCore.getPlugin().getStateLocation();
                    desc.setLocation(stateLocation.append(EXTERNAL_PROJECT_NAME));
                    project.create(desc, 4096, monitor);
                }
                try {
                    project.open(monitor);
                }
                catch (CoreException coreException) {
                    IPath stateLocation = DLTKCore.getPlugin().getStateLocation();
                    IPath projectPath = stateLocation.append(EXTERNAL_PROJECT_NAME);
                    projectPath.toFile().mkdirs();
                    FileOutputStream output = new FileOutputStream(projectPath.append(".project").toOSString());
                    try {
                        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>.org.eclipse.dltk.core.external.folders</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n</projectDescription>".getBytes());
                    }
                    finally {
                        output.close();
                    }
                    project.open(null);
                }
            }
            catch (CoreException e) {
                Util.log(e, "Problem creating hidden project for external folders");
                return project;
            }
            catch (IOException e) {
                Util.log(e, "Problem creating hidden project for external folders");
                return project;
            }
        }
        return project;
    }

    public synchronized IFolder getFolder(IPath externalFolderPath) {
        return (IFolder)this.getFolders().get(externalFolderPath);
    }

    private HashMap getFolders() {
        if (this.folders == null) {
            this.folders = new HashMap();
            IProject project = this.getExternalFoldersProject();
            if (project.isAccessible()) {
                try {
                    IResource[] members = project.members();
                    int i = 0;
                    int length = members.length;
                    while (i < length) {
                        IResource member = members[i];
                        if (member.getType() == 2 && member.isLinked() && member.getName().startsWith(LINKED_FOLDER_NAME)) {
                            IPath externalFolderPath = member.getLocation();
                            this.folders.put(externalFolderPath, member);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Util.log(e, "Exception while initializing external folders");
                }
            }
        }
        return this.folders;
    }

    public void refreshReferences(IProject source, IProgressMonitor monitor) {
        IProject externalProject = this.getExternalFoldersProject();
        if (source.equals((Object)externalProject)) {
            return;
        }
        if (!ScriptProject.hasScriptNature(source)) {
            return;
        }
        try {
            HashSet<IPath> externalFolders = ExternalFoldersManager.getExternalFolders(((ScriptProject)DLTKCore.create(source)).getResolvedBuildpath());
            if (externalFolders == null) {
                return;
            }
            final Iterator<IPath> iterator = externalFolders.iterator();
            Job refreshJob = new Job(Messages.refreshing_external_folders){

                public boolean belongsTo(Object family) {
                    return family == ResourcesPlugin.FAMILY_MANUAL_REFRESH;
                }

                protected IStatus run(IProgressMonitor pm) {
                    try {
                        while (iterator.hasNext()) {
                            IPath externalPath = (IPath)iterator.next();
                            IFolder folder = ExternalFoldersManager.this.getFolder(externalPath);
                            if (folder == null) continue;
                            folder.refreshLocal(2, pm);
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule();
        }
        catch (CoreException e) {
            Util.log(e, "Exception while refreshing external project");
        }
    }

    public synchronized IFolder removeFolder(IPath externalFolderPath) {
        return (IFolder)this.getFolders().remove(externalFolderPath);
    }
}

