/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension4;
import org.eclipse.dltk.core.builder.IBuildParticipantFactory;
import org.eclipse.dltk.core.builder.IBuildParticipantFilter;
import org.eclipse.dltk.core.builder.IBuildParticipantFilterFactory;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.osgi.util.NLS;

public class BuildParticipantManager
extends NatureExtensionManager<FactoryValue> {
    private static final String EXT_POINT = "org.eclipse.dltk.core.buildParticipant";
    private static final String REQUIRES = "requires";
    private static final String REQUIRES_ID = "id";
    private static final String PARTICIPANT = "buildParticipant";
    private static final String FILTER = "filter";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static BuildParticipantManager instance = null;
    private static final IBuildParticipant[] NO_PARTICIPANTS = new IBuildParticipant[0];
    private static final IBuildParticipantFilter[] NO_PREDICATES = new IBuildParticipantFilter[0];

    private BuildParticipantManager() {
        super(EXT_POINT, FactoryValue.class);
    }

    @Override
    protected Object createInstanceByDescriptor(Object input) throws CoreException {
        IConfigurationElement element = (IConfigurationElement)input;
        if (PARTICIPANT.equals(element.getName())) {
            Object factory = element.createExecutableExtension("class");
            if (!(factory instanceof IBuildParticipantFactory)) {
                DLTKCore.warn(NLS.bind((String)"{0} contributed by {1} must implement {2}", (Object[])new Object[]{element.getName(), element.getContributor(), IBuildParticipantFactory.class.getName()}));
                return null;
            }
            BuildParticipantFactoryValue factoryValue = new BuildParticipantFactoryValue((IBuildParticipantFactory)factory, element.getAttribute("id"), element.getAttribute(ATTR_NAME));
            IConfigurationElement[] requires = element.getChildren(REQUIRES);
            int i = 0;
            while (i < requires.length) {
                String id = requires[i].getAttribute("id");
                if (id != null) {
                    factoryValue.requirements.add(id);
                }
                ++i;
            }
            return factoryValue;
        }
        if (FILTER.equals(element.getName())) {
            Object factory = element.createExecutableExtension("class");
            if (!(factory instanceof IBuildParticipantFilterFactory)) {
                DLTKCore.warn(NLS.bind((String)"{0} contributed by {1} must implement {2}", (Object[])new Object[]{element.getName(), element.getContributor(), IBuildParticipantFilterFactory.class.getName()}));
                return null;
            }
            return new FilterFactoryValue((IBuildParticipantFilterFactory)factory);
        }
        DLTKCore.warn(NLS.bind((String)"Wrong element {0} in {1} extension point contributed by {2}", (Object[])new Object[]{element.getName(), this.extensionPoint, element.getContributor()}));
        return null;
    }

    private static synchronized BuildParticipantManager getInstance() {
        if (instance == null) {
            instance = new BuildParticipantManager();
        }
        return instance;
    }

    public static BuildParticipantResult getBuildParticipants(IScriptProject project, String natureId) {
        FactoryValue[] factories = (FactoryValue[])BuildParticipantManager.getInstance().getInstances(natureId);
        if (factories == null || factories.length == 0) {
            return new BuildParticipantResult(NO_PARTICIPANTS, null);
        }
        return BuildParticipantManager.createParticipants(project, factories);
    }

    public static BuildParticipantResult createParticipants(IScriptProject project, FactoryValue<?>[] factories) {
        int iterationStartCount;
        IBuildParticipant[] result = new IBuildParticipant[factories.length];
        HashSet<String> processed = new HashSet<String>();
        HashMap<String, IBuildParticipant> created = new HashMap<String, IBuildParticipant>();
        HashMap<IBuildParticipant, List<IBuildParticipant>> dependencies = new HashMap<IBuildParticipant, List<IBuildParticipant>>();
        do {
            iterationStartCount = created.size();
            int i = 0;
            while (i < factories.length) {
                if (factories[i] instanceof BuildParticipantFactoryValue) {
                    BuildParticipantFactoryValue factory = (BuildParticipantFactoryValue)factories[i];
                    if (!processed.contains(factory.id) && created.keySet().containsAll(factory.requirements)) {
                        processed.add(factory.id);
                        try {
                            IBuildParticipant participant = ((IBuildParticipantFactory)factory.factory).createBuildParticipant(project);
                            if (participant != null) {
                                result[created.size()] = participant;
                                created.put(factory.id, participant);
                                if (!factory.requirements.isEmpty()) {
                                    for (String req : factory.requirements) {
                                        IBuildParticipant reqParticipant = (IBuildParticipant)created.get(req);
                                        ArrayList<IBuildParticipant> depList = (ArrayList<IBuildParticipant>)dependencies.get(reqParticipant);
                                        if (depList == null) {
                                            depList = new ArrayList<IBuildParticipant>();
                                            dependencies.put(reqParticipant, depList);
                                        }
                                        depList.add(participant);
                                    }
                                }
                            }
                        }
                        catch (CoreException e) {
                            String tpl = Messages.BuildParticipantManager_buildParticipantCreateError;
                            DLTKCore.warn(NLS.bind((String)tpl, (Object)factory.id), e);
                        }
                    }
                }
                ++i;
            }
        } while (iterationStartCount != created.size());
        if (created.size() != result.length) {
            if (created.size() == 0) {
                return new BuildParticipantResult(NO_PARTICIPANTS, null);
            }
            IBuildParticipant[] newResult = new IBuildParticipant[created.size()];
            System.arraycopy(result, 0, newResult, 0, created.size());
            return new BuildParticipantResult(newResult, dependencies);
        }
        return new BuildParticipantResult(result, dependencies);
    }

    public static IBuildParticipantFilter[] getFilters(IScriptProject project, String natureId, Object context) {
        FactoryValue[] factories = (FactoryValue[])BuildParticipantManager.getInstance().getInstances(natureId);
        if (factories == null || factories.length == 0) {
            return NO_PREDICATES;
        }
        return BuildParticipantManager.createFilters(project, factories, context);
    }

    public static IBuildParticipantFilter[] createFilters(IScriptProject project, FactoryValue<?>[] factories, Object context) {
        IBuildParticipantFilter[] result = new IBuildParticipantFilter[factories.length];
        int created = 0;
        int i = 0;
        while (i < factories.length) {
            if (factories[i] instanceof FilterFactoryValue) {
                FilterFactoryValue factory = (FilterFactoryValue)factories[i];
                try {
                    IBuildParticipantFilter filter = ((IBuildParticipantFilterFactory)factory.factory).createPredicate(project, context);
                    if (filter != null) {
                        result[created++] = filter;
                    }
                }
                catch (CoreException e) {
                    String tpl = Messages.BuildParticipantManager_buildParticipantCreateError;
                    DLTKCore.warn(NLS.bind((String)tpl, (Object)((IBuildParticipantFilterFactory)factory.factory).getClass().getName()), e);
                }
            }
            ++i;
        }
        if (created != result.length) {
            if (created == 0) {
                return NO_PREDICATES;
            }
            IBuildParticipantFilter[] newResult = new IBuildParticipantFilter[created];
            System.arraycopy(result, 0, newResult, 0, created);
            return newResult;
        }
        return result;
    }

    public static IBuildParticipant[] copyFirst(IBuildParticipant[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length == 0) {
            return NO_PARTICIPANTS;
        }
        IBuildParticipant[] temp = new IBuildParticipant[length];
        System.arraycopy(array, 0, temp, 0, length);
        return temp;
    }

    public static void notifyDependents(IBuildParticipant[] participants, Map<IBuildParticipant, List<IBuildParticipant>> dependencies) {
        if (dependencies == null) {
            return;
        }
        List<IBuildParticipant> list = Arrays.asList(participants);
        dependencies.keySet().retainAll(list);
        Iterator<Map.Entry<IBuildParticipant, List<IBuildParticipant>>> i = dependencies.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IBuildParticipant, List<IBuildParticipant>> entry = i.next();
            entry.getValue().retainAll(list);
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
        }
        if (dependencies.isEmpty()) {
            return;
        }
        for (Map.Entry<IBuildParticipant, List<IBuildParticipant>> entry : dependencies.entrySet()) {
            if (!(entry.getKey() instanceof IBuildParticipantExtension4)) continue;
            List<IBuildParticipant> dependents = entry.getValue();
            ((IBuildParticipantExtension4)entry.getKey()).notifyDependents(dependents.toArray(new IBuildParticipant[dependents.size()]));
        }
    }

    public static class BuildParticipantFactoryValue
    extends FactoryValue<IBuildParticipantFactory> {
        final String id;
        final String name;
        public final Set<String> requirements = new HashSet<String>();

        public BuildParticipantFactoryValue(IBuildParticipantFactory factory, String id, String name) {
            super(factory);
            this.id = id != null ? id : factory.getClass().getName();
            this.name = name;
        }
    }

    public static class BuildParticipantResult {
        public final IBuildParticipant[] participants;
        public final Map<IBuildParticipant, List<IBuildParticipant>> dependencies;

        public BuildParticipantResult(IBuildParticipant[] participants, Map<IBuildParticipant, List<IBuildParticipant>> dependencies) {
            this.participants = participants;
            this.dependencies = dependencies;
        }
    }

    public static class FactoryValue<T> {
        final T factory;

        public FactoryValue(T factory) {
            this.factory = factory;
        }
    }

    public static class FilterFactoryValue
    extends FactoryValue<IBuildParticipantFilterFactory> {
        public FilterFactoryValue(IBuildParticipantFilterFactory factory) {
            super(factory);
        }
    }
}

