/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.core.JSBindings;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;

public abstract class AbstractMatchingNode<E extends ASTNode>
implements MatchingNode {
    public final E node;

    public AbstractMatchingNode(E node) {
        this.node = node;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMatchingNode) {
            AbstractMatchingNode other = (AbstractMatchingNode)obj;
            return this.node.equals(other.node);
        }
        return false;
    }

    @Override
    public int sourceStart() {
        return this.node.sourceStart();
    }

    @Override
    public int sourceEnd() {
        return this.node.sourceEnd();
    }

    @Override
    public int length() {
        return this.sourceEnd() - this.sourceStart();
    }

    @Override
    public boolean needsResolve() {
        return false;
    }

    @Override
    public MatchingNode resolvePotentialMatch(JSBindings bindings) {
        return this;
    }

    public String getName() {
        if (this.node instanceof Identifier) {
            return ((Identifier)this.node).getName();
        }
        if (this.node instanceof StringLiteral) {
            return ((StringLiteral)this.node).getValue();
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.node + ")";
    }
}

