/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.core.JSBindings;
import org.eclipse.dltk.javascript.internal.search.AbstractMatchingNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

public abstract class MemberReferenceNode
extends AbstractMatchingNode<Identifier> {
    ReferenceLocation location;
    ReferenceKind kind;

    public MemberReferenceNode(Identifier node, ReferenceLocation location, ReferenceKind kind) {
        super(node);
        this.location = location;
        this.kind = kind;
    }

    public MemberReferenceNode(Identifier node) {
        this(node, null, null);
    }

    @Override
    public boolean needsResolve() {
        return this.location == null;
    }

    @Override
    public MatchingNode resolvePotentialMatch(JSBindings bindings) {
        if (this.location == null) {
            IValueReference reference = bindings.get(this.node);
            if (reference != null) {
                ReferenceLocation l = reference.getLocation();
                if (l != ReferenceLocation.UNKNOWN) {
                    this.location = l;
                    this.kind = reference.getKind();
                }
            } else {
                ReferenceLocation l;
                IValueReference parentReference;
                JSNode parent = ((Identifier)this.node).getParent();
                if (parent instanceof PropertyExpression && ((PropertyExpression)parent).getProperty() == this.node && (parentReference = bindings.get((ASTNode)parent)) != null && (l = parentReference.getLocation()) != ReferenceLocation.UNKNOWN) {
                    this.location = l;
                    this.kind = parentReference.getKind();
                }
            }
        }
        return this;
    }
}

