/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodCall;

public class CallSearchResultCollector {
    private Map fCalledMembers = this.createCalledMethodsData();

    public Map getCallers() {
        return this.fCalledMembers;
    }

    protected void addMember(IModelElement member, IModelElement calledMember, int start, int end) {
        this.addMember(member, calledMember, start, end, -1);
    }

    protected void addMember(IModelElement member, IModelElement calledMember, int start, int end, int lineNumber) {
        if (member != null && calledMember != null && !this.isIgnored(calledMember)) {
            MethodCall methodCall = (MethodCall)this.fCalledMembers.get(calledMember.getHandleIdentifier());
            if (methodCall == null) {
                methodCall = new MethodCall(calledMember);
                this.fCalledMembers.put(calledMember.getHandleIdentifier(), methodCall);
            }
            methodCall.addCallLocation(new CallLocation(member, calledMember, start, end, lineNumber));
        }
    }

    protected Map createCalledMethodsData() {
        return new HashMap();
    }

    private boolean isIgnored(IModelElement enclosingElement) {
        IType type = this.getTypeOfElement(enclosingElement);
        if (type != null) {
            String fullyQualifiedName = type.getFullyQualifiedName();
            return CallHierarchy.getDefault().isIgnored(fullyQualifiedName);
        }
        return false;
    }

    private IType getTypeOfElement(IModelElement element) {
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getDeclaringType();
        }
        return null;
    }
}

