/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.dnd;

import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDropAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;

public abstract class ViewerInputDropAdapter
extends SelectionTransferDropAdapter {
    private static final int ITEM_MARGIN_LEFT = 40;
    private static final int ITEM_MARGIN_RIGTH = 10;
    private static final int OPERATION = 4;

    public ViewerInputDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    protected abstract Object getInputElement(ISelection var1);

    protected abstract void doInputView(Object var1);

    @Override
    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        this.setSelectionFeedbackEnabled(true);
        this.setExpandEnabled(true);
        this.initializeSelection();
        if (target != null) {
            return super.determineOperation(target, operation, transferType, operations);
        }
        if (this.getInputElement(this.getSelection()) != null) {
            this.setSelectionFeedbackEnabled(false);
            this.setExpandEnabled(false);
            return 4;
        }
        return 0;
    }

    @Override
    public boolean performDrop(Object data) {
        this.setSelectionFeedbackEnabled(true);
        this.setExpandEnabled(true);
        if (this.getCurrentTarget() != null || this.getCurrentOperation() != 4) {
            return super.performDrop(data);
        }
        Object input = this.getInputElement(this.getSelection());
        if (input != null) {
            this.doInputView(input);
        }
        return false;
    }

    @Override
    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    @Override
    protected Object determineTarget(DropTargetEvent event) {
        if (event.item == null) {
            return super.determineTarget(event);
        }
        Point coordinates = this.getViewer().getControl().toControl(new Point(event.x, event.y));
        Rectangle bounds = this.getBounds((Item)event.item);
        if (coordinates.x < bounds.x - 40 || coordinates.x >= bounds.x + bounds.width + 10) {
            event.item = null;
            return null;
        }
        return super.determineTarget(event);
    }
}

