/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class BuildPathBasePage {
    protected String fTitle = null;

    public abstract List getSelection();

    public abstract void setSelection(List var1, boolean var2);

    public void addElement(BPListElement element) {
    }

    public abstract boolean isEntryKind(int var1);

    protected void filterAndSetSelection(List list) {
        ArrayList res = new ArrayList(list.size());
        int i = list.size() - 1;
        while (i >= 0) {
            BPListElement elem;
            Object curr = list.get(i);
            if (curr instanceof BPListElement && (elem = (BPListElement)curr).getParentContainer() == null && this.isEntryKind(elem.getEntryKind())) {
                res.add(curr);
            }
            --i;
        }
        this.setSelection(res, false);
    }

    public static void fixNestingConflicts(BPListElement[] newEntries, BPListElement[] existing, Set<BPListElement> modifiedSourceEntries) {
        int i = 0;
        while (i < newEntries.length) {
            BuildPathBasePage.addExclusionPatterns(newEntries[i], existing, modifiedSourceEntries);
            ++i;
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    private static void addExclusionPatterns(BPListElement newEntry, BPListElement[] existing, Set<BPListElement> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.length) {
            IPath currPath;
            BPListElement curr = existing[i];
            if (curr.getEntryKind() == 3 && !(currPath = curr.getPath()).equals((Object)entryPath)) {
                if (currPath.isPrefixOf(entryPath)) {
                    if (BuildPathBasePage.addToExclusions(entryPath, curr)) {
                        modifiedEntries.add(curr);
                    }
                } else if (entryPath.isPrefixOf(currPath) && BuildPathBasePage.addToExclusions(currPath, newEntry)) {
                    modifiedEntries.add(curr);
                }
            }
            ++i;
        }
    }

    private static boolean addToExclusions(IPath entryPath, BPListElement curr) {
        IPath[] exclusionFilters = (IPath[])curr.getAttribute("exclusion");
        if (!ScriptModelUtil.isExcludedPath((IPath)entryPath, (IPath[])exclusionFilters)) {
            IPath pathToExclude = entryPath.removeFirstSegments(curr.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            curr.setAttribute("exclusion", newExclusionFilters);
            return true;
        }
        return false;
    }

    protected boolean containsOnlyTopLevelEntries(List selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof BPListElement) {
                if (((BPListElement)elem).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract void init(IScriptProject var1);

    public abstract Control getControl(Composite var1);
}

