/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.dltk.core.environment.IDeployment;

public class DeploymentManager
implements ILaunchesListener2 {
    private Map launchToDeployment = new HashMap();
    private Set activeDeployments = new HashSet();
    private static DeploymentManager sInstance = null;

    public static synchronized DeploymentManager getInstance() {
        if (sInstance == null) {
            sInstance = new DeploymentManager();
        }
        return sInstance;
    }

    public void startup() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        this.undeployAll(this.activeDeployments);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public synchronized void launchesRemoved(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            if (this.launchToDeployment.containsKey(launches[i])) {
                Set deployments = (Set)this.launchToDeployment.get(launches[i]);
                this.undeployAll(deployments);
                this.launchToDeployment.remove(launches[i]);
            }
            ++i;
        }
    }

    private synchronized void undeployAll(Collection deployments) {
        HashSet copy = new HashSet(deployments);
        for (IDeployment deployment : copy) {
            deployment.dispose();
            this.activeDeployments.remove(deployment);
        }
    }

    public synchronized void addDeployment(IDeployment deployment) {
        this.activeDeployments.add(deployment);
    }

    public synchronized void addDeployment(ILaunch launch, IDeployment deployment) {
        this.activeDeployments.add(deployment);
        if (this.launchToDeployment.containsKey(launch)) {
            ((Set)this.launchToDeployment.get(launch)).add(deployment);
        } else {
            HashSet<IDeployment> elements = new HashSet<IDeployment>();
            elements.add(deployment);
            this.launchToDeployment.put(launch, elements);
        }
    }

    public synchronized void removeDeployment(IDeployment deployment) {
        this.activeDeployments.remove(deployment);
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.launchesRemoved(launches);
    }
}

