/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalEntryFile;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.internal.core.packages.PackageUtils;
import org.eclipse.dltk.tcl.internal.core.packages.TclPackageSourceModule;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.emf.common.util.EList;

public class TclPackageElement
extends Openable
implements IScriptFolder {
    private String packageName;
    private String packageVersion;

    protected TclPackageElement(ModelElement parent, String name, String version) {
        super(parent);
        this.packageName = name;
        this.packageVersion = version;
    }

    public String getElementName() {
        return PackageUtils.packageToPath(this.packageName, this.packageVersion);
    }

    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public int getElementType() {
        return 4;
    }

    public int getKind() throws ModelException {
        return 1;
    }

    public IResource getResource() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TclPackageElement)) {
            return false;
        }
        TclPackageElement other = (TclPackageElement)((Object)o);
        return this.packageName.equals(other.packageName) && this.getParent().equals(other.getParent());
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IInterpreterInstall install;
        block6: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.getScriptProject());
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (install != null) {
            HashSet<TclPackageSourceModule> vChildren = new HashSet<TclPackageSourceModule>();
            TclPackageInfo packageInfo = TclPackagesManager.getPackageInfo(install, this.packageName, true);
            if (packageInfo == null) {
                return true;
            }
            EList<String> sources = packageInfo.getSources();
            if (!sources.isEmpty()) {
                String[] paths = sources.toArray((String[])new String[sources.size()]);
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this.getScriptProject());
                int i = 0;
                while (i < paths.length) {
                    Path path = new Path(paths[i]);
                    ExternalEntryFile storage = new ExternalEntryFile(EnvironmentPathUtils.getFile((IEnvironment)environment, (IPath)path));
                    TclPackageSourceModule module = new TclPackageSourceModule((ModelElement)this, path.lastSegment(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, (IStorage)storage);
                    vChildren.add(module);
                    ++i;
                }
            }
            info.setChildren(vChildren.toArray(new IModelElement[vChildren.size()]));
        }
        return true;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)this.getSourceModule(classFileName);
                return classFile.getHandleFromMemento(memento, owner);
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento((MementoTokenizer)memento, (IParent)this, (WorkingCopyOwner)owner);
            }
        }
        return null;
    }

    public boolean containsScriptResources() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (!(elementInfo instanceof ScriptFolderInfo)) {
            return false;
        }
        ScriptFolderInfo scriptElementInfo = (ScriptFolderInfo)elementInfo;
        return scriptElementInfo.containsScriptResources();
    }

    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK TCL Package:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public ISourceModule createSourceModule(String name, String contents, boolean force, IProgressMonitor monitor) throws ModelException {
        return null;
    }

    public Object[] getForeignResources() throws ModelException {
        return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
    }

    public boolean exists() {
        return true;
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        List list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean hasSubfolders() throws ModelException {
        return false;
    }

    public boolean isRootFolder() {
        return false;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(PackageUtils.packageToPath(this.packageName, this.packageVersion));
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
    }

    public ISourceModule getSourceModule(String name) {
        block4: {
            IModelElement[] children = null;
            try {
                children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    IModelElement child = children[i];
                    if (child instanceof ISourceModule && name.equals(child.getElementName())) {
                        return (ISourceModule)child;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getVersion() {
        return this.packageVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isReadOnly() {
        return true;
    }
}

