/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import org.eclipse.dltk.internal.ui.actions.MultiActionGroup;
import org.eclipse.dltk.internal.ui.scriptview.LayoutAction;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

public class LayoutActionGroup
extends MultiActionGroup {
    LayoutActionGroup(ScriptExplorerPart packageExplorer) {
        super(LayoutActionGroup.createActions(packageExplorer), LayoutActionGroup.getSelectedState(packageExplorer));
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.contributeToViewMenu(actionBars.getMenuManager());
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(ScriptMessages.LayoutActionGroup_label);
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    static int getSelectedState(ScriptExplorerPart packageExplorer) {
        if (packageExplorer.isFlatLayout()) {
            return 0;
        }
        return 1;
    }

    static IAction[] createActions(ScriptExplorerPart packageExplorer) {
        LayoutAction flatLayoutAction = new LayoutAction(packageExplorer, true);
        flatLayoutAction.setText(ScriptMessages.LayoutActionGroup_flatLayoutAction_label);
        DLTKPluginImages.setLocalImageDescriptors(flatLayoutAction, "flatLayout.gif");
        LayoutAction hierarchicalLayout = new LayoutAction(packageExplorer, false);
        hierarchicalLayout.setText(ScriptMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        DLTKPluginImages.setLocalImageDescriptors(hierarchicalLayout, "hierarchicalLayout.gif");
        return new IAction[]{flatLayoutAction, hierarchicalLayout};
    }
}

