/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptBreakpointListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.preferences.StepFilterManager;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;

public class ScriptDebugOptionsManager
implements IDebugEventSetListener,
IPropertyChangeListener,
IScriptBreakpointListener,
ILaunchListener,
IBreakpointsListener {
    private static ScriptDebugOptionsManager instance;
    private static ILabelProvider fLabelProvider;

    static {
        fLabelProvider = DebugUITools.newDebugModelPresentation();
    }

    protected void updateBreakpoints(final IBreakpoint[] breakpoints, final IBreakpointUpdater updater) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < breakpoints.length) {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (breakpoint instanceof IScriptBreakpoint) {
                        try {
                            updater.update((IScriptBreakpoint)breakpoint);
                        }
                        catch (CoreException e) {
                            DLTKDebugUIPlugin.log(e);
                        }
                    }
                    ++i;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void updateBreakpointMessages(IBreakpoint[] breakpoints) {
        this.updateBreakpoints(breakpoints, new IBreakpointUpdater(){

            @Override
            public void update(IScriptBreakpoint breakpoint) throws CoreException {
                String message = fLabelProvider.getText((Object)breakpoint);
                breakpoint.setMessage(message);
            }
        });
    }

    protected void updateBreakpointHitCounts(IBreakpoint[] breakpoints, final IScriptThread thread) {
        this.updateBreakpoints(breakpoints, new IBreakpointUpdater(){

            @Override
            public void update(IScriptBreakpoint breakpoint) throws CoreException {
                String id;
                IDbgpBreakpoint br = null;
                if (breakpoint instanceof IScriptMethodEntryBreakpoint) {
                    String exitId;
                    IScriptMethodEntryBreakpoint entryBreakpoint = (IScriptMethodEntryBreakpoint)breakpoint;
                    String entryId = entryBreakpoint.getEntryBreakpointId();
                    if (entryId != null) {
                        br = thread.getDbgpBreakpoint(entryId);
                    }
                    if ((exitId = entryBreakpoint.getExitBreakpointId()) != null) {
                        br = thread.getDbgpBreakpoint(exitId);
                    }
                } else if (!(breakpoint instanceof IScriptSpawnpoint) && (id = breakpoint.getId(thread.getDbgpSession())) != null && id.length() != 0) {
                    br = thread.getDbgpBreakpoint(id);
                }
                if (br != null) {
                    breakpoint.setHitCount(thread.getDbgpSession(), br.getHitCount());
                }
            }
        });
    }

    protected void updateBreakpoinInfoToDefault(IBreakpoint[] breakpoints) {
        this.updateBreakpoints(breakpoints, new IBreakpointUpdater(){

            @Override
            public void update(IScriptBreakpoint breakpoint) throws CoreException {
                breakpoint.clearSessionInfo();
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            block11: {
                IBreakpoint[] breakpoints;
                DebugEvent event = events[i];
                int kind = event.getKind();
                Object source = event.getSource();
                if (kind == 2) {
                    if (source instanceof IScriptThread) {
                        IScriptThread thread = (IScriptThread)source;
                        breakpoints = thread.getBreakpoints();
                        this.updateBreakpointHitCounts(breakpoints, thread);
                        this.updateBreakpointMessages(breakpoints);
                    }
                } else if (kind == 8) {
                    if (source instanceof IScriptDebugTarget) {
                        String debugModelId = ((IScriptDebugTarget)source).getModelIdentifier();
                        breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(debugModelId);
                        this.updateBreakpoinInfoToDefault(breakpoints);
                        this.updateBreakpointMessages(breakpoints);
                    }
                } else if (kind == 4 && source instanceof IScriptDebugTarget) {
                    try {
                        IScriptProject project;
                        IScriptDebugTarget target = (IScriptDebugTarget)source;
                        ILaunchConfiguration configuration = target.getLaunch().getLaunchConfiguration();
                        if (configuration != null && (project = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration)) != null) {
                            String[] activeFilters = StepFilterManager.getActiveFilters(project);
                            target.setFilters(activeFilters);
                        }
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            try {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IScriptBreakpoint && ((IScriptBreakpoint)breakpoint).getMessage() == null) {
                    list.add(breakpoint);
                }
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            this.updateBreakpointMessages(list.toArray(new IBreakpoint[list.size()]));
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.updateBreakpointMessages(breakpoints);
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public static ScriptDebugOptionsManager getDefault() {
        if (instance == null) {
            instance = new ScriptDebugOptionsManager();
        }
        return instance;
    }

    public void startup() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        debugPlugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        ScriptEvaluationContextManager.startup();
    }

    public void shutdown() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        debugPlugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        if (!DLTKDebugUIPlugin.getDefault().isShuttingDown()) {
            DLTKDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        System.getProperties().remove(String.valueOf(DLTKDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive");
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    private static interface IBreakpointUpdater {
        public void update(IScriptBreakpoint var1) throws CoreException;
    }
}

