/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.util.Util;

public class ExternalSourceModule
extends AbstractExternalSourceModule {
    private IStorage storage;

    public ExternalSourceModule(ModelElement parent, String name, WorkingCopyOwner owner, IStorage storage) {
        super(parent, name, owner);
        this.storage = storage;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public InputStream getContents() throws CoreException {
        return this.storage.getContents();
    }

    @Override
    public String getFileName() {
        return this.getPath().toOSString();
    }

    public IPath getFullPath() {
        if (this.storage != null) {
            return this.storage.getFullPath();
        }
        return this.getPath();
    }

    public String getName() {
        return this.storage.getName();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected char[] getBufferContent() throws ModelException {
        char[] cArray;
        BufferedInputStream stream;
        IPath path = this.getBufferPath();
        IFileHandle file = EnvironmentPathUtils.getFile(path);
        IProjectFragment projectFragment = this.getProjectFragment();
        if (file != null && file.exists() && !projectFragment.isArchive()) {
            return Util.getResourceContentsAsCharArray(file);
        }
        if (!projectFragment.isArchive()) throw this.newNotPresentException();
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        try {
            stream = new BufferedInputStream(this.storage.getContents(), 4096);
        }
        catch (CoreException e) {
            throw new ModelException(e, 969);
        }
        try {
            char[] data = org.eclipse.dltk.compiler.util.Util.getInputStreamAsCharArray(stream, -1, "UTF-8");
            p.done("#", "IO Read", data.length);
            cArray = data;
        }
        catch (IOException e) {
            try {
                throw new ModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    protected IPath getBufferPath() {
        return this.getPath();
    }

    @Override
    protected String getModuleType() {
        return "DLTK External Source Moule";
    }

    @Override
    protected String getNatureId() {
        IPath path = this.getFullPath();
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(path);
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.getLanguageToolkit(this.getScriptProject());
        }
        return toolkit != null ? toolkit.getNatureId() : null;
    }

    @Override
    protected ISourceModule getOriginalSourceModule() {
        return new ExternalSourceModule((ModelElement)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY, this.storage);
    }
}

