/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class UnexcludeOperation
extends BuildpathModifierOperation {
    public UnexcludeOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip, 3);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List resources = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.unExclude(resources, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        IScriptProject project = this.fInformationProvider.getScriptProject();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            switch (types[i]) {
                case 6: {
                    if (this.isValidFolder((IResource)element, project)) break;
                    return false;
                }
                case 7: {
                    if (this.isValidExcludedFolder((IResource)element, project)) break;
                    return false;
                }
                case 8: {
                    if (this.isValidExcludedFile((IFile)element, project)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFolder(IResource resource, IScriptProject project) throws ModelException {
        return BuildpathModifier.isExcluded(resource, project);
    }

    private boolean isValidExcludedFolder(IResource resource, IScriptProject project) throws ModelException {
        return BuildpathModifier.isExcluded(resource, project);
    }

    private boolean isValidExcludedFile(IFile file, IScriptProject project) throws ModelException {
        return BuildpathModifier.isExcluded((IResource)file, project);
    }

    @Override
    public String getDescription(int type) {
        IResource resource = (IResource)this.getSelectedElements().get(0);
        String name = UnexcludeOperation.escapeSpecialChars(resource.getName());
        if (type == 6) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFolder, name);
        }
        if (type == 8) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_UnexcludeFile, name);
        }
        return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Unexclude, name);
    }
}

