/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableScriptModelAction(Shell shell, Object element) {
        if (!(element instanceof IScriptFolder) && !(element instanceof IProjectFragment)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource((Object)element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(ITextEditor editor) {
        if (editor == null) {
            return true;
        }
        Shell shell = editor.getSite().getShell();
        IModelElement input = SelectionConverter.getInput((IEditorPart)editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, ScriptEditor editor) {
        if (editor == null) {
            return true;
        }
        IModelElement input = SelectionConverter.getInput((IEditorPart)editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IModelElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IModelElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IModelElement element) {
        if (element.getElementType() == 2) {
            return true;
        }
        IScriptProject project = element.getScriptProject();
        if (!project.isOnBuildpath(element)) {
            return false;
        }
        IProject resourceProject = project.getProject();
        if (resourceProject == null) {
            return false;
        }
        return DLTKLanguageManager.hasScriptNature((IProject)project.getProject());
    }

    public static boolean areProcessable(Shell shell, IModelElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ActionUtil.isOnBuildPath(elements[i])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{elements[i].getPath()}));
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEditable(ITextEditor editor, Shell shell, IModelElement element) {
        if (editor != null) {
            IModelElement input = SelectionConverter.getInput((IEditorPart)editor);
            if (input != null && input.equals(element.getAncestor(5))) {
                return ActionUtil.isEditable(editor);
            }
            return ActionUtil.isEditable(editor) && ActionUtil.isEditable(shell, element);
        }
        return ActionUtil.isEditable(shell, element);
    }

    public static boolean isEditable(ITextEditor editor) {
        if (!ActionUtil.isProcessable(editor)) {
            return false;
        }
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).validateEditorInputState();
        }
        return false;
    }

    public static boolean isEditable(Shell shell, IModelElement element) {
        IResource resource;
        if (!ActionUtil.isProcessable(shell, element)) {
            return false;
        }
        IModelElement cu = element.getAncestor(5);
        if (cu != null && (resource = cu.getResource()) != null && resource.isDerived()) {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            if (!store.getBoolean("warn_if_input_derived")) {
                return true;
            }
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)ActionMessages.ActionUtil_warning_derived_title, (String)Messages.format(ActionMessages.ActionUtil_warning_derived_message, BasicElementLabels.getPathLabel(resource.getFullPath(), false)), (String)ActionMessages.ActionUtil_warning_derived_dontShowAgain, (boolean)false, null, null);
            EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !toggleDialog.getToggleState());
            return toggleDialog.getReturnCode() == 2;
        }
        return true;
    }
}

