/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.filters;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NoPackageContainingFoldersFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFolder) {
            try {
                return this.containsPackage((IFolder)element);
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return true;
    }

    private boolean containsPackage(IFolder folder) throws CoreException {
        IModelElement element = DLTKCore.create((IResource)folder);
        if (element instanceof IScriptFolder) {
            return true;
        }
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFolder && this.containsPackage((IFolder)resources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

