/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class BuildPathSupport {
    public static IPath getBundleLocation(JUnitPluginDescription pluginDesc) {
        Bundle bundle = pluginDesc.getBundle();
        if (bundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IPath getSourceLocation(JUnitPluginDescription pluginDesc) {
        Bundle bundle = pluginDesc.getBundle();
        if (bundle == null) {
            return null;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            return null;
        }
        Bundle sourceBundle = null;
        if (pluginDesc.isOrbitBundle()) {
            Bundle[] bundles = DLTKTestingPlugin.getDefault().getBundles(String.valueOf(pluginDesc.getBundleId()) + ".source", version);
            if (bundles != null && bundles.length > 0) {
                sourceBundle = bundles[0];
            }
        } else {
            sourceBundle = DLTKTestingPlugin.getDefault().getBundle("org.eclipse.jdt.source");
        }
        if (sourceBundle == null) {
            return null;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)sourceBundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = String.valueOf(new File(local.getPath()).getAbsolutePath()) + File.separator + "src" + File.separator + pluginDesc.getBundleId() + "_" + version;
        return Path.fromOSString((String)fullPath);
    }

    public static class JUnitPluginDescription {
        private final String fBundleId;
        private final VersionRange fVersionRange;
        private final boolean fIsOrbitBundle;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, boolean isOrbitBundle) {
            this.fBundleId = bundleId;
            this.fVersionRange = versionRange;
            this.fIsOrbitBundle = isOrbitBundle;
        }

        public Bundle getBundle() {
            Bundle[] bundles = DLTKTestingPlugin.getDefault().getBundles(this.fBundleId, null);
            if (bundles != null) {
                int i = 0;
                while (i < bundles.length) {
                    Bundle curr = bundles[i];
                    String version = (String)curr.getHeaders().get("Bundle-Version");
                    try {
                        if (this.fVersionRange.isIncluded(Version.parseVersion((String)version))) {
                            return curr;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    ++i;
                }
            }
            return null;
        }

        public String getBundleId() {
            return this.fBundleId;
        }

        public boolean isOrbitBundle() {
            return this.fIsOrbitBundle;
        }
    }
}

