/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;

public class ArchiveProjectFragmentRequest
extends IndexRequest {
    protected final IProjectFragment fragment;
    protected final IDLTKLanguageToolkit toolkit;
    private static final String SIGNATURE_PREFIX = "###.LIBRARY.###.SIGNATURE.###";

    public ArchiveProjectFragmentRequest(IProjectIndexer indexer, IProjectFragment fragment, IDLTKLanguageToolkit toolkit) {
        super(indexer);
        this.fragment = fragment;
        this.toolkit = toolkit;
    }

    @Override
    protected String getName() {
        return this.fragment.getElementName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws CoreException, IOException {
        IEnvironment environment = EnvironmentManager.getEnvironment(this.fragment.getScriptProject());
        if (environment == null) return;
        if (!environment.connect()) {
            return;
        }
        Set<ISourceModule> modules = this.getExternalSourceModules();
        Index index = this.getIndexer().getProjectFragmentIndex(this.fragment);
        if (index == null) {
            return;
        }
        IFileHandle archive = EnvironmentPathUtils.getFile(this.fragment.getPath());
        if (archive == null) {
            return;
        }
        String signature = String.valueOf(archive.lastModified()) + "#" + archive.length();
        IPath containerPath = this.fragment.getPath();
        List<Object> changes = this.checkChanges(index, modules, containerPath, signature);
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            try {
                index.separator = Index.JAR_SEPARATOR;
                index.addIndexEntry(IIndexConstants.STAMP, CharOperation.NO_CHAR, SIGNATURE_PREFIX + signature);
                Iterator<Object> i = changes.iterator();
                while (!this.isCancelled) {
                    if (!i.hasNext()) {
                        return;
                    }
                    Object change = i.next();
                    if (change instanceof String) {
                        index.remove((String)change);
                        continue;
                    }
                    if (!(change instanceof ISourceModule)) continue;
                    ISourceModule module = (ISourceModule)change;
                    this.getIndexer().indexSourceModule(index, this.toolkit, module, containerPath);
                }
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    try {
                        index.save();
                        return;
                    }
                    catch (IOException e2) {
                        DLTKCore.error("error saving index", e2);
                        imon.exitWrite();
                        return;
                    }
                }
                finally {
                    imon.exitWrite();
                }
            }
        }
        finally {
            block26: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    protected List<Object> checkChanges(Index index, Collection<ISourceModule> modules, IPath containerPath, String signature) throws ModelException, IOException {
        String[] documents = this.queryDocumentNames(index);
        if (documents != null && documents.length != 0) {
            ArrayList<Object> changes = new ArrayList<Object>();
            Map<String, ISourceModule> m = this.collectSourceModulePaths(modules, containerPath);
            boolean signatureOK = false;
            ArrayList<ISourceModule> updates = new ArrayList<ISourceModule>();
            int i = 0;
            while (i < documents.length) {
                String document = documents[i];
                if (document.startsWith(SIGNATURE_PREFIX)) {
                    signatureOK = document.substring(SIGNATURE_PREFIX.length()).equals(signature);
                    if (!signatureOK) {
                        changes.add(document);
                    }
                } else {
                    ISourceModule module = m.remove(document);
                    if (module == null) {
                        changes.add(document);
                    } else {
                        updates.add(module);
                    }
                }
                ++i;
            }
            if (!signatureOK) {
                changes.addAll(updates);
            }
            if (!m.isEmpty()) {
                changes.addAll(m.values());
            }
            return changes;
        }
        return new ArrayList<Object>(modules);
    }

    private Set<ISourceModule> getExternalSourceModules() throws ModelException {
        ExternalModuleVisitor visitor = new ExternalModuleVisitor();
        this.fragment.accept(visitor);
        return visitor.modules;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchiveProjectFragmentRequest other = (ArchiveProjectFragmentRequest)obj;
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set<ISourceModule> modules = new HashSet<ISourceModule>();

        ExternalModuleVisitor() {
        }

        @Override
        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                if (element instanceof IExternalSourceModule || element instanceof BuiltinSourceModule || ((ISourceModule)element).isBinary()) {
                    this.modules.add((ISourceModule)element);
                }
                return false;
            }
            return true;
        }
    }
}

