/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Messages;

public class ProgressJob
extends Job {
    private JobManager jobManager;
    private IProgressMonitor monitor;
    private transient boolean running;

    public ProgressJob(JobManager jobManager) {
        super(Messages.manager_indexingInProgress);
        this.jobManager = jobManager;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.running = true;
        try {
            this.monitor = monitor;
            monitor.beginTask(Messages.manager_indexingTask, -1);
            while (!monitor.isCanceled() && this.jobManager.awaitingJobsCount() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            monitor.done();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.running = false;
            this.monitor = null;
        }
    }

    public void subTask(String message) {
        if (!this.running) {
            this.schedule();
        }
        if (this.monitor != null) {
            this.monitor.subTask(message);
        }
    }
}

